/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChannelModeratedByAppInstanceUserSummary;
import software.amazon.awssdk.services.chime.model.ChannelModeratedByAppInstanceUserSummaryListCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelsModeratedByAppInstanceUserResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListChannelsModeratedByAppInstanceUserResponse> {
    private static final SdkField<List<ChannelModeratedByAppInstanceUserSummary>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(ListChannelsModeratedByAppInstanceUserResponse.getter(ListChannelsModeratedByAppInstanceUserResponse::channels)).setter(ListChannelsModeratedByAppInstanceUserResponse.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelModeratedByAppInstanceUserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelsModeratedByAppInstanceUserResponse.getter(ListChannelsModeratedByAppInstanceUserResponse::nextToken)).setter(ListChannelsModeratedByAppInstanceUserResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ChannelModeratedByAppInstanceUserSummary> channels;
    private final String nextToken;

    private ListChannelsModeratedByAppInstanceUserResponse(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<ChannelModeratedByAppInstanceUserSummary> channels() {
        return this.channels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsModeratedByAppInstanceUserResponse)) {
            return false;
        }
        ListChannelsModeratedByAppInstanceUserResponse other = (ListChannelsModeratedByAppInstanceUserResponse)((Object)obj);
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelsModeratedByAppInstanceUserResponse").add("Channels", this.hasChannels() ? this.channels() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsModeratedByAppInstanceUserResponse, T> g) {
        return obj -> g.apply((ListChannelsModeratedByAppInstanceUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<ChannelModeratedByAppInstanceUserSummary> channels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsModeratedByAppInstanceUserResponse model) {
            super(model);
            this.channels(model.channels);
            this.nextToken(model.nextToken);
        }

        public final List<ChannelModeratedByAppInstanceUserSummary.Builder> getChannels() {
            List<ChannelModeratedByAppInstanceUserSummary.Builder> result = ChannelModeratedByAppInstanceUserSummaryListCopier.copyToBuilder(this.channels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannels(Collection<ChannelModeratedByAppInstanceUserSummary.BuilderImpl> channels) {
            this.channels = ChannelModeratedByAppInstanceUserSummaryListCopier.copyFromBuilder(channels);
        }

        @Override
        public final Builder channels(Collection<ChannelModeratedByAppInstanceUserSummary> channels) {
            this.channels = ChannelModeratedByAppInstanceUserSummaryListCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(ChannelModeratedByAppInstanceUserSummary ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<ChannelModeratedByAppInstanceUserSummary.Builder> ... channels) {
            this.channels(Stream.of(channels).map(c -> (ChannelModeratedByAppInstanceUserSummary)((ChannelModeratedByAppInstanceUserSummary.Builder)ChannelModeratedByAppInstanceUserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelsModeratedByAppInstanceUserResponse build() {
            return new ListChannelsModeratedByAppInstanceUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelsModeratedByAppInstanceUserResponse> {
        public Builder channels(Collection<ChannelModeratedByAppInstanceUserSummary> var1);

        public Builder channels(ChannelModeratedByAppInstanceUserSummary ... var1);

        public Builder channels(Consumer<ChannelModeratedByAppInstanceUserSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

