/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the membership details of an <code>AppInstanceUser</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceUserMembershipSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AppInstanceUserMembershipSummary.Builder, AppInstanceUserMembershipSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AppInstanceUserMembershipSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> READ_MARKER_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReadMarkerTimestamp").getter(getter(AppInstanceUserMembershipSummary::readMarkerTimestamp))
            .setter(setter(Builder::readMarkerTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadMarkerTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            READ_MARKER_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Instant readMarkerTimestamp;

    private AppInstanceUserMembershipSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.readMarkerTimestamp = builder.readMarkerTimestamp;
    }

    /**
     * <p>
     * The type of <code>ChannelMembership</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>ChannelMembership</code>.
     * @see ChannelMembershipType
     */
    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(type);
    }

    /**
     * <p>
     * The type of <code>ChannelMembership</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>ChannelMembership</code>.
     * @see ChannelMembershipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The time at which a message was last read.
     * </p>
     * 
     * @return The time at which a message was last read.
     */
    public final Instant readMarkerTimestamp() {
        return readMarkerTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(readMarkerTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceUserMembershipSummary)) {
            return false;
        }
        AppInstanceUserMembershipSummary other = (AppInstanceUserMembershipSummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(readMarkerTimestamp(), other.readMarkerTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceUserMembershipSummary").add("Type", typeAsString())
                .add("ReadMarkerTimestamp", readMarkerTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ReadMarkerTimestamp":
            return Optional.ofNullable(clazz.cast(readMarkerTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceUserMembershipSummary, T> g) {
        return obj -> g.apply((AppInstanceUserMembershipSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceUserMembershipSummary> {
        /**
         * <p>
         * The type of <code>ChannelMembership</code>.
         * </p>
         * 
         * @param type
         *        The type of <code>ChannelMembership</code>.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of <code>ChannelMembership</code>.
         * </p>
         * 
         * @param type
         *        The type of <code>ChannelMembership</code>.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(ChannelMembershipType type);

        /**
         * <p>
         * The time at which a message was last read.
         * </p>
         * 
         * @param readMarkerTimestamp
         *        The time at which a message was last read.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readMarkerTimestamp(Instant readMarkerTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Instant readMarkerTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceUserMembershipSummary model) {
            type(model.type);
            readMarkerTimestamp(model.readMarkerTimestamp);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getReadMarkerTimestamp() {
            return readMarkerTimestamp;
        }

        public final void setReadMarkerTimestamp(Instant readMarkerTimestamp) {
            this.readMarkerTimestamp = readMarkerTimestamp;
        }

        @Override
        @Transient
        public final Builder readMarkerTimestamp(Instant readMarkerTimestamp) {
            this.readMarkerTimestamp = readMarkerTimestamp;
            return this;
        }

        @Override
        public AppInstanceUserMembershipSummary build() {
            return new AppInstanceUserMembershipSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
