/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a channel moderator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelModerator implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelModerator.Builder, ChannelModerator> {
    private static final SdkField<Identity> MODERATOR_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("Moderator").getter(getter(ChannelModerator::moderator)).setter(setter(Builder::moderator))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Moderator").build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ChannelModerator::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(ChannelModerator::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Identity> CREATED_BY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(ChannelModerator::createdBy)).setter(setter(Builder::createdBy))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODERATOR_FIELD,
            CHANNEL_ARN_FIELD, CREATED_TIMESTAMP_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Identity moderator;

    private final String channelArn;

    private final Instant createdTimestamp;

    private final Identity createdBy;

    private ChannelModerator(BuilderImpl builder) {
        this.moderator = builder.moderator;
        this.channelArn = builder.channelArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The moderator's data.
     * </p>
     * 
     * @return The moderator's data.
     */
    public final Identity moderator() {
        return moderator;
    }

    /**
     * <p>
     * The ARN of the moderator's channel.
     * </p>
     * 
     * @return The ARN of the moderator's channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The time at which the moderator was created.
     * </p>
     * 
     * @return The time at which the moderator was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The <code>AppInstanceUser</code> who created the moderator.
     * </p>
     * 
     * @return The <code>AppInstanceUser</code> who created the moderator.
     */
    public final Identity createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moderator());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelModerator)) {
            return false;
        }
        ChannelModerator other = (ChannelModerator) obj;
        return Objects.equals(moderator(), other.moderator()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(createdTimestamp(), other.createdTimestamp()) && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelModerator").add("Moderator", moderator()).add("ChannelArn", channelArn())
                .add("CreatedTimestamp", createdTimestamp()).add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Moderator":
            return Optional.ofNullable(clazz.cast(moderator()));
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelModerator, T> g) {
        return obj -> g.apply((ChannelModerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelModerator> {
        /**
         * <p>
         * The moderator's data.
         * </p>
         * 
         * @param moderator
         *        The moderator's data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderator(Identity moderator);

        /**
         * <p>
         * The moderator's data.
         * </p>
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #moderator(Identity)}.
         * 
         * @param moderator
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moderator(Identity)
         */
        default Builder moderator(Consumer<Identity.Builder> moderator) {
            return moderator(Identity.builder().applyMutation(moderator).build());
        }

        /**
         * <p>
         * The ARN of the moderator's channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the moderator's channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The time at which the moderator was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the moderator was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The <code>AppInstanceUser</code> who created the moderator.
         * </p>
         * 
         * @param createdBy
         *        The <code>AppInstanceUser</code> who created the moderator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(Identity createdBy);

        /**
         * <p>
         * The <code>AppInstanceUser</code> who created the moderator.
         * </p>
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #createdBy(Identity)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(Identity)
         */
        default Builder createdBy(Consumer<Identity.Builder> createdBy) {
            return createdBy(Identity.builder().applyMutation(createdBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Identity moderator;

        private String channelArn;

        private Instant createdTimestamp;

        private Identity createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelModerator model) {
            moderator(model.moderator);
            channelArn(model.channelArn);
            createdTimestamp(model.createdTimestamp);
            createdBy(model.createdBy);
        }

        public final Identity.Builder getModerator() {
            return moderator != null ? moderator.toBuilder() : null;
        }

        public final void setModerator(Identity.BuilderImpl moderator) {
            this.moderator = moderator != null ? moderator.build() : null;
        }

        @Override
        @Transient
        public final Builder moderator(Identity moderator) {
            this.moderator = moderator;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        @Transient
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Identity.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(Identity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        @Transient
        public final Builder createdBy(Identity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public ChannelModerator build() {
            return new ChannelModerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
