/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration object of the Amazon Chime SDK meeting for a specified media capture pipeline.
 * <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChimeSdkMeetingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChimeSdkMeetingConfiguration.Builder, ChimeSdkMeetingConfiguration> {
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("SourceConfiguration")
            .getter(getter(ChimeSdkMeetingConfiguration::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build())
            .build();

    private static final SdkField<ArtifactsConfiguration> ARTIFACTS_CONFIGURATION_FIELD = SdkField
            .<ArtifactsConfiguration> builder(MarshallingType.SDK_POJO).memberName("ArtifactsConfiguration")
            .getter(getter(ChimeSdkMeetingConfiguration::artifactsConfiguration)).setter(setter(Builder::artifactsConfiguration))
            .constructor(ArtifactsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CONFIGURATION_FIELD,
            ARTIFACTS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SourceConfiguration sourceConfiguration;

    private final ArtifactsConfiguration artifactsConfiguration;

    private ChimeSdkMeetingConfiguration(BuilderImpl builder) {
        this.sourceConfiguration = builder.sourceConfiguration;
        this.artifactsConfiguration = builder.artifactsConfiguration;
    }

    /**
     * <p>
     * The source configuration for a specified media capture pipline.
     * </p>
     * 
     * @return The source configuration for a specified media capture pipline.
     */
    public final SourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    /**
     * <p>
     * The configuration for the artifacts in an Amazon Chime SDK meeting.
     * </p>
     * 
     * @return The configuration for the artifacts in an Amazon Chime SDK meeting.
     */
    public final ArtifactsConfiguration artifactsConfiguration() {
        return artifactsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(artifactsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChimeSdkMeetingConfiguration)) {
            return false;
        }
        ChimeSdkMeetingConfiguration other = (ChimeSdkMeetingConfiguration) obj;
        return Objects.equals(sourceConfiguration(), other.sourceConfiguration())
                && Objects.equals(artifactsConfiguration(), other.artifactsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChimeSdkMeetingConfiguration").add("SourceConfiguration", sourceConfiguration())
                .add("ArtifactsConfiguration", artifactsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        case "ArtifactsConfiguration":
            return Optional.ofNullable(clazz.cast(artifactsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChimeSdkMeetingConfiguration, T> g) {
        return obj -> g.apply((ChimeSdkMeetingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChimeSdkMeetingConfiguration> {
        /**
         * <p>
         * The source configuration for a specified media capture pipline.
         * </p>
         * 
         * @param sourceConfiguration
         *        The source configuration for a specified media capture pipline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SourceConfiguration sourceConfiguration);

        /**
         * <p>
         * The source configuration for a specified media capture pipline.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceConfiguration.Builder} avoiding the need
         * to create one manually via {@link SourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceConfiguration(SourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }

        /**
         * <p>
         * The configuration for the artifacts in an Amazon Chime SDK meeting.
         * </p>
         * 
         * @param artifactsConfiguration
         *        The configuration for the artifacts in an Amazon Chime SDK meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactsConfiguration(ArtifactsConfiguration artifactsConfiguration);

        /**
         * <p>
         * The configuration for the artifacts in an Amazon Chime SDK meeting.
         * </p>
         * This is a convenience that creates an instance of the {@link ArtifactsConfiguration.Builder} avoiding the
         * need to create one manually via {@link ArtifactsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArtifactsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #artifactsConfiguration(ArtifactsConfiguration)}.
         * 
         * @param artifactsConfiguration
         *        a consumer that will call methods on {@link ArtifactsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactsConfiguration(ArtifactsConfiguration)
         */
        default Builder artifactsConfiguration(Consumer<ArtifactsConfiguration.Builder> artifactsConfiguration) {
            return artifactsConfiguration(ArtifactsConfiguration.builder().applyMutation(artifactsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SourceConfiguration sourceConfiguration;

        private ArtifactsConfiguration artifactsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ChimeSdkMeetingConfiguration model) {
            sourceConfiguration(model.sourceConfiguration);
            artifactsConfiguration(model.artifactsConfiguration);
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final ArtifactsConfiguration.Builder getArtifactsConfiguration() {
            return artifactsConfiguration != null ? artifactsConfiguration.toBuilder() : null;
        }

        public final void setArtifactsConfiguration(ArtifactsConfiguration.BuilderImpl artifactsConfiguration) {
            this.artifactsConfiguration = artifactsConfiguration != null ? artifactsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder artifactsConfiguration(ArtifactsConfiguration artifactsConfiguration) {
            this.artifactsConfiguration = artifactsConfiguration;
            return this;
        }

        @Override
        public ChimeSdkMeetingConfiguration build() {
            return new ChimeSdkMeetingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
