/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaCapturePipelineRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateMediaCapturePipelineRequest.Builder, CreateMediaCapturePipelineRequest> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(CreateMediaCapturePipelineRequest::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(CreateMediaCapturePipelineRequest::sourceArn))
            .setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkType").getter(getter(CreateMediaCapturePipelineRequest::sinkTypeAsString))
            .setter(setter(Builder::sinkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()).build();

    private static final SdkField<String> SINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkArn").getter(getter(CreateMediaCapturePipelineRequest::sinkArn)).setter(setter(Builder::sinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMediaCapturePipelineRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ChimeSdkMeetingConfiguration> CHIME_SDK_MEETING_CONFIGURATION_FIELD = SdkField
            .<ChimeSdkMeetingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ChimeSdkMeetingConfiguration")
            .getter(getter(CreateMediaCapturePipelineRequest::chimeSdkMeetingConfiguration))
            .setter(setter(Builder::chimeSdkMeetingConfiguration))
            .constructor(ChimeSdkMeetingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChimeSdkMeetingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, SINK_TYPE_FIELD, SINK_ARN_FIELD,
                    CLIENT_REQUEST_TOKEN_FIELD, CHIME_SDK_MEETING_CONFIGURATION_FIELD));

    private final String sourceType;

    private final String sourceArn;

    private final String sinkType;

    private final String sinkArn;

    private final String clientRequestToken;

    private final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

    private CreateMediaCapturePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.sourceType = builder.sourceType;
        this.sourceArn = builder.sourceArn;
        this.sinkType = builder.sinkType;
        this.sinkArn = builder.sinkArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.chimeSdkMeetingConfiguration = builder.chimeSdkMeetingConfiguration;
    }

    /**
     * <p>
     * Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MediaPipelineSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported
     *         source.
     * @see MediaPipelineSourceType
     */
    public final MediaPipelineSourceType sourceType() {
        return MediaPipelineSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MediaPipelineSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported
     *         source.
     * @see MediaPipelineSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * ARN of the source from which the media artifacts are captured.
     * </p>
     * 
     * @return ARN of the source from which the media artifacts are captured.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * @see MediaPipelineSinkType
     */
    public final MediaPipelineSinkType sinkType() {
        return MediaPipelineSinkType.fromValue(sinkType);
    }

    /**
     * <p>
     * Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return Destination type to which the media artifacts are saved. You must use an S3 bucket.
     * @see MediaPipelineSinkType
     */
    public final String sinkTypeAsString() {
        return sinkType;
    }

    /**
     * <p>
     * The ARN of the sink type.
     * </p>
     * 
     * @return The ARN of the sink type.
     */
    public final String sinkArn() {
        return sinkArn;
    }

    /**
     * <p>
     * The token assigned to the client making the pipeline request.
     * </p>
     * 
     * @return The token assigned to the client making the pipeline request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The configuration for a specified media capture pipeline. <code>SourceType</code> must be
     * <code>ChimeSdkMeeting</code>.
     * </p>
     * 
     * @return The configuration for a specified media capture pipeline. <code>SourceType</code> must be
     *         <code>ChimeSdkMeeting</code>.
     */
    public final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration() {
        return chimeSdkMeetingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(chimeSdkMeetingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaCapturePipelineRequest)) {
            return false;
        }
        CreateMediaCapturePipelineRequest other = (CreateMediaCapturePipelineRequest) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(sinkTypeAsString(), other.sinkTypeAsString()) && Objects.equals(sinkArn(), other.sinkArn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(chimeSdkMeetingConfiguration(), other.chimeSdkMeetingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaCapturePipelineRequest").add("SourceType", sourceTypeAsString())
                .add("SourceArn", sourceArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SinkType", sinkTypeAsString()).add("SinkArn", sinkArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChimeSdkMeetingConfiguration", chimeSdkMeetingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "SinkType":
            return Optional.ofNullable(clazz.cast(sinkTypeAsString()));
        case "SinkArn":
            return Optional.ofNullable(clazz.cast(sinkArn()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ChimeSdkMeetingConfiguration":
            return Optional.ofNullable(clazz.cast(chimeSdkMeetingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaCapturePipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaCapturePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMediaCapturePipelineRequest> {
        /**
         * <p>
         * Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported
         * source.
         * </p>
         * 
         * @param sourceType
         *        Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported
         *        source.
         * @see MediaPipelineSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported
         * source.
         * </p>
         * 
         * @param sourceType
         *        Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported
         *        source.
         * @see MediaPipelineSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSourceType
         */
        Builder sourceType(MediaPipelineSourceType sourceType);

        /**
         * <p>
         * ARN of the source from which the media artifacts are captured.
         * </p>
         * 
         * @param sourceArn
         *        ARN of the source from which the media artifacts are captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * </p>
         * 
         * @param sinkType
         *        Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * @see MediaPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSinkType
         */
        Builder sinkType(String sinkType);

        /**
         * <p>
         * Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * </p>
         * 
         * @param sinkType
         *        Destination type to which the media artifacts are saved. You must use an S3 bucket.
         * @see MediaPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineSinkType
         */
        Builder sinkType(MediaPipelineSinkType sinkType);

        /**
         * <p>
         * The ARN of the sink type.
         * </p>
         * 
         * @param sinkArn
         *        The ARN of the sink type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkArn(String sinkArn);

        /**
         * <p>
         * The token assigned to the client making the pipeline request.
         * </p>
         * 
         * @param clientRequestToken
         *        The token assigned to the client making the pipeline request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The configuration for a specified media capture pipeline. <code>SourceType</code> must be
         * <code>ChimeSdkMeeting</code>.
         * </p>
         * 
         * @param chimeSdkMeetingConfiguration
         *        The configuration for a specified media capture pipeline. <code>SourceType</code> must be
         *        <code>ChimeSdkMeeting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration);

        /**
         * <p>
         * The configuration for a specified media capture pipeline. <code>SourceType</code> must be
         * <code>ChimeSdkMeeting</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ChimeSdkMeetingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ChimeSdkMeetingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChimeSdkMeetingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration)}.
         * 
         * @param chimeSdkMeetingConfiguration
         *        a consumer that will call methods on {@link ChimeSdkMeetingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration)
         */
        default Builder chimeSdkMeetingConfiguration(Consumer<ChimeSdkMeetingConfiguration.Builder> chimeSdkMeetingConfiguration) {
            return chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.builder()
                    .applyMutation(chimeSdkMeetingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String sourceType;

        private String sourceArn;

        private String sinkType;

        private String sinkArn;

        private String clientRequestToken;

        private ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaCapturePipelineRequest model) {
            super(model);
            sourceType(model.sourceType);
            sourceArn(model.sourceArn);
            sinkType(model.sinkType);
            sinkArn(model.sinkArn);
            clientRequestToken(model.clientRequestToken);
            chimeSdkMeetingConfiguration(model.chimeSdkMeetingConfiguration);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder sourceType(MediaPipelineSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSinkType() {
            return sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        @Transient
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        @Transient
        public final Builder sinkType(MediaPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final String getSinkArn() {
            return sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        @Transient
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ChimeSdkMeetingConfiguration.Builder getChimeSdkMeetingConfiguration() {
            return chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.toBuilder() : null;
        }

        public final void setChimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.BuilderImpl chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaCapturePipelineRequest build() {
            return new CreateMediaCapturePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
