/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeetingDialOutRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateMeetingDialOutRequest.Builder, CreateMeetingDialOutRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(CreateMeetingDialOutRequest::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meetingId").build()).build();

    private static final SdkField<String> FROM_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromPhoneNumber").getter(getter(CreateMeetingDialOutRequest::fromPhoneNumber))
            .setter(setter(Builder::fromPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPhoneNumber").build()).build();

    private static final SdkField<String> TO_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ToPhoneNumber").getter(getter(CreateMeetingDialOutRequest::toPhoneNumber))
            .setter(setter(Builder::toPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPhoneNumber").build()).build();

    private static final SdkField<String> JOIN_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JoinToken").getter(getter(CreateMeetingDialOutRequest::joinToken)).setter(setter(Builder::joinToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            FROM_PHONE_NUMBER_FIELD, TO_PHONE_NUMBER_FIELD, JOIN_TOKEN_FIELD));

    private final String meetingId;

    private final String fromPhoneNumber;

    private final String toPhoneNumber;

    private final String joinToken;

    private CreateMeetingDialOutRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.fromPhoneNumber = builder.fromPhoneNumber;
        this.toPhoneNumber = builder.toPhoneNumber;
        this.joinToken = builder.joinToken;
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting ID.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting ID.
     */
    public final String meetingId() {
        return meetingId;
    }

    /**
     * <p>
     * Phone number used as the caller ID when the remote party receives a call.
     * </p>
     * 
     * @return Phone number used as the caller ID when the remote party receives a call.
     */
    public final String fromPhoneNumber() {
        return fromPhoneNumber;
    }

    /**
     * <p>
     * Phone number called when inviting someone to a meeting.
     * </p>
     * 
     * @return Phone number called when inviting someone to a meeting.
     */
    public final String toPhoneNumber() {
        return toPhoneNumber;
    }

    /**
     * <p>
     * Token used by the Amazon Chime SDK attendee. Call the <a
     * href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to
     * get a join token.
     * </p>
     * 
     * @return Token used by the Amazon Chime SDK attendee. Call the <a
     *         href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a>
     *         action to get a join token.
     */
    public final String joinToken() {
        return joinToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(fromPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(toPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(joinToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingDialOutRequest)) {
            return false;
        }
        CreateMeetingDialOutRequest other = (CreateMeetingDialOutRequest) obj;
        return Objects.equals(meetingId(), other.meetingId()) && Objects.equals(fromPhoneNumber(), other.fromPhoneNumber())
                && Objects.equals(toPhoneNumber(), other.toPhoneNumber()) && Objects.equals(joinToken(), other.joinToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMeetingDialOutRequest").add("MeetingId", meetingId())
                .add("FromPhoneNumber", fromPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ToPhoneNumber", toPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JoinToken", joinToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "FromPhoneNumber":
            return Optional.ofNullable(clazz.cast(fromPhoneNumber()));
        case "ToPhoneNumber":
            return Optional.ofNullable(clazz.cast(toPhoneNumber()));
        case "JoinToken":
            return Optional.ofNullable(clazz.cast(joinToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingDialOutRequest, T> g) {
        return obj -> g.apply((CreateMeetingDialOutRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMeetingDialOutRequest> {
        /**
         * <p>
         * The Amazon Chime SDK meeting ID.
         * </p>
         * 
         * @param meetingId
         *        The Amazon Chime SDK meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * Phone number used as the caller ID when the remote party receives a call.
         * </p>
         * 
         * @param fromPhoneNumber
         *        Phone number used as the caller ID when the remote party receives a call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPhoneNumber(String fromPhoneNumber);

        /**
         * <p>
         * Phone number called when inviting someone to a meeting.
         * </p>
         * 
         * @param toPhoneNumber
         *        Phone number called when inviting someone to a meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPhoneNumber(String toPhoneNumber);

        /**
         * <p>
         * Token used by the Amazon Chime SDK attendee. Call the <a
         * href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a>
         * action to get a join token.
         * </p>
         * 
         * @param joinToken
         *        Token used by the Amazon Chime SDK attendee. Call the <a
         *        href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html"
         *        >CreateAttendee</a> action to get a join token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinToken(String joinToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String meetingId;

        private String fromPhoneNumber;

        private String toPhoneNumber;

        private String joinToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingDialOutRequest model) {
            super(model);
            meetingId(model.meetingId);
            fromPhoneNumber(model.fromPhoneNumber);
            toPhoneNumber(model.toPhoneNumber);
            joinToken(model.joinToken);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        @Transient
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getFromPhoneNumber() {
            return fromPhoneNumber;
        }

        public final void setFromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
        }

        @Override
        @Transient
        public final Builder fromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
            return this;
        }

        public final String getToPhoneNumber() {
            return toPhoneNumber;
        }

        public final void setToPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
        }

        @Override
        @Transient
        public final Builder toPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
            return this;
        }

        public final String getJoinToken() {
            return joinToken;
        }

        public final void setJoinToken(String joinToken) {
            this.joinToken = joinToken;
        }

        @Override
        @Transient
        public final Builder joinToken(String joinToken) {
            this.joinToken = joinToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingDialOutRequest build() {
            return new CreateMeetingDialOutRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
