/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoomMembershipRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateRoomMembershipRequest.Builder, CreateRoomMembershipRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(CreateRoomMembershipRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<String> ROOM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoomId")
            .getter(getter(CreateRoomMembershipRequest::roomId)).setter(setter(Builder::roomId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("roomId").build()).build();

    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(CreateRoomMembershipRequest::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateRoomMembershipRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ROOM_ID_FIELD, MEMBER_ID_FIELD, ROLE_FIELD));

    private final String accountId;

    private final String roomId;

    private final String memberId;

    private final String role;

    private CreateRoomMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.roomId = builder.roomId;
        this.memberId = builder.memberId;
        this.role = builder.role;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The room ID.
     * </p>
     * 
     * @return The room ID.
     */
    public final String roomId() {
        return roomId;
    }

    /**
     * <p>
     * The Amazon Chime member ID (user ID or bot ID).
     * </p>
     * 
     * @return The Amazon Chime member ID (user ID or bot ID).
     */
    public final String memberId() {
        return memberId;
    }

    /**
     * <p>
     * The role of the member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoomMembershipRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the member.
     * @see RoomMembershipRole
     */
    public final RoomMembershipRole role() {
        return RoomMembershipRole.fromValue(role);
    }

    /**
     * <p>
     * The role of the member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoomMembershipRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the member.
     * @see RoomMembershipRole
     */
    public final String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(roomId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoomMembershipRequest)) {
            return false;
        }
        CreateRoomMembershipRequest other = (CreateRoomMembershipRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(roomId(), other.roomId())
                && Objects.equals(memberId(), other.memberId()) && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRoomMembershipRequest").add("AccountId", accountId()).add("RoomId", roomId())
                .add("MemberId", memberId()).add("Role", roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "RoomId":
            return Optional.ofNullable(clazz.cast(roomId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoomMembershipRequest, T> g) {
        return obj -> g.apply((CreateRoomMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoomMembershipRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The room ID.
         * </p>
         * 
         * @param roomId
         *        The room ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomId(String roomId);

        /**
         * <p>
         * The Amazon Chime member ID (user ID or bot ID).
         * </p>
         * 
         * @param memberId
         *        The Amazon Chime member ID (user ID or bot ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);

        /**
         * <p>
         * The role of the member.
         * </p>
         * 
         * @param role
         *        The role of the member.
         * @see RoomMembershipRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoomMembershipRole
         */
        Builder role(String role);

        /**
         * <p>
         * The role of the member.
         * </p>
         * 
         * @param role
         *        The role of the member.
         * @see RoomMembershipRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoomMembershipRole
         */
        Builder role(RoomMembershipRole role);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private String roomId;

        private String memberId;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoomMembershipRequest model) {
            super(model);
            accountId(model.accountId);
            roomId(model.roomId);
            memberId(model.memberId);
            role(model.role);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRoomId() {
            return roomId;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        @Override
        @Transient
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final String getMemberId() {
            return memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        @Transient
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        @Transient
        public final Builder role(RoomMembershipRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoomMembershipRequest build() {
            return new CreateRoomMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
