/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSipMediaApplicationRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateSipMediaApplicationRequest.Builder, CreateSipMediaApplicationRequest> {
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(CreateSipMediaApplicationRequest::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateSipMediaApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<SipMediaApplicationEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<SipMediaApplicationEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(CreateSipMediaApplicationRequest::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipMediaApplicationEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipMediaApplicationEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_REGION_FIELD, NAME_FIELD,
            ENDPOINTS_FIELD));

    private final String awsRegion;

    private final String name;

    private final List<SipMediaApplicationEndpoint> endpoints;

    private CreateSipMediaApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.awsRegion = builder.awsRegion;
        this.name = builder.name;
        this.endpoints = builder.endpoints;
    }

    /**
     * <p>
     * The AWS Region assigned to the SIP media application.
     * </p>
     * 
     * @return The AWS Region assigned to the SIP media application.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The SIP media application name.
     * </p>
     * 
     * @return The SIP media application name.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one
     * endpoint is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only
     *         one endpoint is supported.
     */
    public final List<SipMediaApplicationEndpoint> endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSipMediaApplicationRequest)) {
            return false;
        }
        CreateSipMediaApplicationRequest other = (CreateSipMediaApplicationRequest) obj;
        return Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(name(), other.name())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSipMediaApplicationRequest").add("AwsRegion", awsRegion()).add("Name", name())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSipMediaApplicationRequest, T> g) {
        return obj -> g.apply((CreateSipMediaApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSipMediaApplicationRequest> {
        /**
         * <p>
         * The AWS Region assigned to the SIP media application.
         * </p>
         * 
         * @param awsRegion
         *        The AWS Region assigned to the SIP media application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The SIP media application name.
         * </p>
         * 
         * @param name
         *        The SIP media application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one
         * endpoint is supported.
         * </p>
         * 
         * @param endpoints
         *        List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently,
         *        only one endpoint is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints);

        /**
         * <p>
         * List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one
         * endpoint is supported.
         * </p>
         * 
         * @param endpoints
         *        List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently,
         *        only one endpoint is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(SipMediaApplicationEndpoint... endpoints);

        /**
         * <p>
         * List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one
         * endpoint is supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SipMediaApplicationEndpoint>.Builder}
         * avoiding the need to create one manually via {@link List<SipMediaApplicationEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SipMediaApplicationEndpoint>.Builder#build()} is called
         * immediately and its result is passed to {@link #endpoints(List<SipMediaApplicationEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<SipMediaApplicationEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<SipMediaApplicationEndpoint>)
         */
        Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder>... endpoints);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String awsRegion;

        private String name;

        private List<SipMediaApplicationEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSipMediaApplicationRequest model) {
            super(model);
            awsRegion(model.awsRegion);
            name(model.name);
            endpoints(model.endpoints);
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        @Transient
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<SipMediaApplicationEndpoint.Builder> getEndpoints() {
            List<SipMediaApplicationEndpoint.Builder> result = SipMediaApplicationEndpointListCopier
                    .copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<SipMediaApplicationEndpoint.BuilderImpl> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copyFromBuilder(endpoints);
        }

        @Override
        @Transient
        public final Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copy(endpoints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpoints(SipMediaApplicationEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> SipMediaApplicationEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSipMediaApplicationRequest build() {
            return new CreateSipMediaApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
