/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVoiceConnectorGroupRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateVoiceConnectorGroupRequest.Builder, CreateVoiceConnectorGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateVoiceConnectorGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<VoiceConnectorItem>> VOICE_CONNECTOR_ITEMS_FIELD = SdkField
            .<List<VoiceConnectorItem>> builder(MarshallingType.LIST)
            .memberName("VoiceConnectorItems")
            .getter(getter(CreateVoiceConnectorGroupRequest::voiceConnectorItems))
            .setter(setter(Builder::voiceConnectorItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VoiceConnectorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(VoiceConnectorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            VOICE_CONNECTOR_ITEMS_FIELD));

    private final String name;

    private final List<VoiceConnectorItem> voiceConnectorItems;

    private CreateVoiceConnectorGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.voiceConnectorItems = builder.voiceConnectorItems;
    }

    /**
     * <p>
     * The name of the Amazon Chime Voice Connector group.
     * </p>
     * 
     * @return The name of the Amazon Chime Voice Connector group.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the VoiceConnectorItems property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVoiceConnectorItems() {
        return voiceConnectorItems != null && !(voiceConnectorItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Chime Voice Connectors to route inbound calls to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoiceConnectorItems} method.
     * </p>
     * 
     * @return The Amazon Chime Voice Connectors to route inbound calls to.
     */
    public final List<VoiceConnectorItem> voiceConnectorItems() {
        return voiceConnectorItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasVoiceConnectorItems() ? voiceConnectorItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceConnectorGroupRequest)) {
            return false;
        }
        CreateVoiceConnectorGroupRequest other = (CreateVoiceConnectorGroupRequest) obj;
        return Objects.equals(name(), other.name()) && hasVoiceConnectorItems() == other.hasVoiceConnectorItems()
                && Objects.equals(voiceConnectorItems(), other.voiceConnectorItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVoiceConnectorGroupRequest").add("Name", name())
                .add("VoiceConnectorItems", hasVoiceConnectorItems() ? voiceConnectorItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VoiceConnectorItems":
            return Optional.ofNullable(clazz.cast(voiceConnectorItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceConnectorGroupRequest, T> g) {
        return obj -> g.apply((CreateVoiceConnectorGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVoiceConnectorGroupRequest> {
        /**
         * <p>
         * The name of the Amazon Chime Voice Connector group.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Chime Voice Connector group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Chime Voice Connectors to route inbound calls to.
         * </p>
         * 
         * @param voiceConnectorItems
         *        The Amazon Chime Voice Connectors to route inbound calls to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems);

        /**
         * <p>
         * The Amazon Chime Voice Connectors to route inbound calls to.
         * </p>
         * 
         * @param voiceConnectorItems
         *        The Amazon Chime Voice Connectors to route inbound calls to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorItems(VoiceConnectorItem... voiceConnectorItems);

        /**
         * <p>
         * The Amazon Chime Voice Connectors to route inbound calls to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VoiceConnectorItem>.Builder} avoiding the
         * need to create one manually via {@link List<VoiceConnectorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VoiceConnectorItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #voiceConnectorItems(List<VoiceConnectorItem>)}.
         * 
         * @param voiceConnectorItems
         *        a consumer that will call methods on {@link List<VoiceConnectorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnectorItems(List<VoiceConnectorItem>)
         */
        Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder>... voiceConnectorItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String name;

        private List<VoiceConnectorItem> voiceConnectorItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceConnectorGroupRequest model) {
            super(model);
            name(model.name);
            voiceConnectorItems(model.voiceConnectorItems);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<VoiceConnectorItem.Builder> getVoiceConnectorItems() {
            List<VoiceConnectorItem.Builder> result = VoiceConnectorItemListCopier.copyToBuilder(this.voiceConnectorItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceConnectorItems(Collection<VoiceConnectorItem.BuilderImpl> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copyFromBuilder(voiceConnectorItems);
        }

        @Override
        @Transient
        public final Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copy(voiceConnectorItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder voiceConnectorItems(VoiceConnectorItem... voiceConnectorItems) {
            voiceConnectorItems(Arrays.asList(voiceConnectorItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder>... voiceConnectorItems) {
            voiceConnectorItems(Stream.of(voiceConnectorItems).map(c -> VoiceConnectorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVoiceConnectorGroupRequest build() {
            return new CreateVoiceConnectorGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
