/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings specific to the Amazon Transcribe Medical engine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineTranscribeMedicalSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EngineTranscribeMedicalSettings.Builder, EngineTranscribeMedicalSettings> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(EngineTranscribeMedicalSettings::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> SPECIALTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Specialty").getter(getter(EngineTranscribeMedicalSettings::specialtyAsString))
            .setter(setter(Builder::specialty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specialty").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EngineTranscribeMedicalSettings::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(EngineTranscribeMedicalSettings::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(EngineTranscribeMedicalSettings::regionAsString)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(EngineTranscribeMedicalSettings::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            SPECIALTY_FIELD, TYPE_FIELD, VOCABULARY_NAME_FIELD, REGION_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final String specialty;

    private final String type;

    private final String vocabularyName;

    private final String region;

    private final String contentIdentificationType;

    private EngineTranscribeMedicalSettings(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.specialty = builder.specialty;
        this.type = builder.type;
        this.vocabularyName = builder.vocabularyName;
        this.region = builder.region;
        this.contentIdentificationType = builder.contentIdentificationType;
    }

    /**
     * <p>
     * The language code specified for the Amazon Transcribe Medical engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link TranscribeMedicalLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code specified for the Amazon Transcribe Medical engine.
     * @see TranscribeMedicalLanguageCode
     */
    public final TranscribeMedicalLanguageCode languageCode() {
        return TranscribeMedicalLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code specified for the Amazon Transcribe Medical engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link TranscribeMedicalLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code specified for the Amazon Transcribe Medical engine.
     * @see TranscribeMedicalLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The specialty specified for the Amazon Transcribe Medical engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link TranscribeMedicalSpecialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specialtyAsString}.
     * </p>
     * 
     * @return The specialty specified for the Amazon Transcribe Medical engine.
     * @see TranscribeMedicalSpecialty
     */
    public final TranscribeMedicalSpecialty specialty() {
        return TranscribeMedicalSpecialty.fromValue(specialty);
    }

    /**
     * <p>
     * The specialty specified for the Amazon Transcribe Medical engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link TranscribeMedicalSpecialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specialtyAsString}.
     * </p>
     * 
     * @return The specialty specified for the Amazon Transcribe Medical engine.
     * @see TranscribeMedicalSpecialty
     */
    public final String specialtyAsString() {
        return specialty;
    }

    /**
     * <p>
     * The type of transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TranscribeMedicalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of transcription.
     * @see TranscribeMedicalType
     */
    public final TranscribeMedicalType type() {
        return TranscribeMedicalType.fromValue(type);
    }

    /**
     * <p>
     * The type of transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TranscribeMedicalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of transcription.
     * @see TranscribeMedicalType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the vocabulary passed to Amazon Transcribe Medical.
     * </p>
     * 
     * @return The name of the vocabulary passed to Amazon Transcribe Medical.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the
     * meeting's Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link TranscribeMedicalRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #regionAsString}.
     * </p>
     * 
     * @return The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the
     *         meeting's Region.
     * @see TranscribeMedicalRegion
     */
    public final TranscribeMedicalRegion region() {
        return TranscribeMedicalRegion.fromValue(region);
    }

    /**
     * <p>
     * The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the
     * meeting's Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link TranscribeMedicalRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #regionAsString}.
     * </p>
     * 
     * @return The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the
     *         meeting's Region.
     * @see TranscribeMedicalRegion
     */
    public final String regionAsString() {
        return region;
    }

    /**
     * <p>
     * Set this field to <code>PHI</code> to identify personal health information in the transcription output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return
     * {@link TranscribeMedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Set this field to <code>PHI</code> to identify personal health information in the transcription output.
     * @see TranscribeMedicalContentIdentificationType
     */
    public final TranscribeMedicalContentIdentificationType contentIdentificationType() {
        return TranscribeMedicalContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Set this field to <code>PHI</code> to identify personal health information in the transcription output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return
     * {@link TranscribeMedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Set this field to <code>PHI</code> to identify personal health information in the transcription output.
     * @see TranscribeMedicalContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineTranscribeMedicalSettings)) {
            return false;
        }
        EngineTranscribeMedicalSettings other = (EngineTranscribeMedicalSettings) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(specialtyAsString(), other.specialtyAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(regionAsString(), other.regionAsString())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngineTranscribeMedicalSettings").add("LanguageCode", languageCodeAsString())
                .add("Specialty", specialtyAsString()).add("Type", typeAsString()).add("VocabularyName", vocabularyName())
                .add("Region", regionAsString()).add("ContentIdentificationType", contentIdentificationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "Specialty":
            return Optional.ofNullable(clazz.cast(specialtyAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "Region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineTranscribeMedicalSettings, T> g) {
        return obj -> g.apply((EngineTranscribeMedicalSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineTranscribeMedicalSettings> {
        /**
         * <p>
         * The language code specified for the Amazon Transcribe Medical engine.
         * </p>
         * 
         * @param languageCode
         *        The language code specified for the Amazon Transcribe Medical engine.
         * @see TranscribeMedicalLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code specified for the Amazon Transcribe Medical engine.
         * </p>
         * 
         * @param languageCode
         *        The language code specified for the Amazon Transcribe Medical engine.
         * @see TranscribeMedicalLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalLanguageCode
         */
        Builder languageCode(TranscribeMedicalLanguageCode languageCode);

        /**
         * <p>
         * The specialty specified for the Amazon Transcribe Medical engine.
         * </p>
         * 
         * @param specialty
         *        The specialty specified for the Amazon Transcribe Medical engine.
         * @see TranscribeMedicalSpecialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalSpecialty
         */
        Builder specialty(String specialty);

        /**
         * <p>
         * The specialty specified for the Amazon Transcribe Medical engine.
         * </p>
         * 
         * @param specialty
         *        The specialty specified for the Amazon Transcribe Medical engine.
         * @see TranscribeMedicalSpecialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalSpecialty
         */
        Builder specialty(TranscribeMedicalSpecialty specialty);

        /**
         * <p>
         * The type of transcription.
         * </p>
         * 
         * @param type
         *        The type of transcription.
         * @see TranscribeMedicalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of transcription.
         * </p>
         * 
         * @param type
         *        The type of transcription.
         * @see TranscribeMedicalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalType
         */
        Builder type(TranscribeMedicalType type);

        /**
         * <p>
         * The name of the vocabulary passed to Amazon Transcribe Medical.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary passed to Amazon Transcribe Medical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the
         * meeting's Region.
         * </p>
         * 
         * @param region
         *        The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses
         *        the meeting's Region.
         * @see TranscribeMedicalRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalRegion
         */
        Builder region(String region);

        /**
         * <p>
         * The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the
         * meeting's Region.
         * </p>
         * 
         * @param region
         *        The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses
         *        the meeting's Region.
         * @see TranscribeMedicalRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalRegion
         */
        Builder region(TranscribeMedicalRegion region);

        /**
         * <p>
         * Set this field to <code>PHI</code> to identify personal health information in the transcription output.
         * </p>
         * 
         * @param contentIdentificationType
         *        Set this field to <code>PHI</code> to identify personal health information in the transcription
         *        output.
         * @see TranscribeMedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Set this field to <code>PHI</code> to identify personal health information in the transcription output.
         * </p>
         * 
         * @param contentIdentificationType
         *        Set this field to <code>PHI</code> to identify personal health information in the transcription
         *        output.
         * @see TranscribeMedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeMedicalContentIdentificationType
         */
        Builder contentIdentificationType(TranscribeMedicalContentIdentificationType contentIdentificationType);
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private String specialty;

        private String type;

        private String vocabularyName;

        private String region;

        private String contentIdentificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineTranscribeMedicalSettings model) {
            languageCode(model.languageCode);
            specialty(model.specialty);
            type(model.type);
            vocabularyName(model.vocabularyName);
            region(model.region);
            contentIdentificationType(model.contentIdentificationType);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(TranscribeMedicalLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getSpecialty() {
            return specialty;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        @Override
        @Transient
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        @Transient
        public final Builder specialty(TranscribeMedicalSpecialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(TranscribeMedicalType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        @Transient
        public final Builder region(TranscribeMedicalRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(TranscribeMedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        @Override
        public EngineTranscribeMedicalSettings build() {
            return new EngineTranscribeMedicalSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
