/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings specific to the Amazon Transcribe engine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineTranscribeSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EngineTranscribeSettings.Builder, EngineTranscribeSettings> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(EngineTranscribeSettings::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod").getter(getter(EngineTranscribeSettings::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(EngineTranscribeSettings::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(EngineTranscribeSettings::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(EngineTranscribeSettings::regionAsString)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<Boolean> ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePartialResultsStabilization")
            .getter(getter(EngineTranscribeSettings::enablePartialResultsStabilization))
            .setter(setter(Builder::enablePartialResultsStabilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePartialResultsStabilization")
                    .build()).build();

    private static final SdkField<String> PARTIAL_RESULTS_STABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartialResultsStability").getter(getter(EngineTranscribeSettings::partialResultsStabilityAsString))
            .setter(setter(Builder::partialResultsStability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialResultsStability").build())
            .build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType").getter(getter(EngineTranscribeSettings::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build())
            .build();

    private static final SdkField<String> CONTENT_REDACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentRedactionType").getter(getter(EngineTranscribeSettings::contentRedactionTypeAsString))
            .setter(setter(Builder::contentRedactionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedactionType").build())
            .build();

    private static final SdkField<String> PII_ENTITY_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PiiEntityTypes").getter(getter(EngineTranscribeSettings::piiEntityTypes))
            .setter(setter(Builder::piiEntityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build()).build();

    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageModelName").getter(getter(EngineTranscribeSettings::languageModelName))
            .setter(setter(Builder::languageModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            VOCABULARY_FILTER_METHOD_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_NAME_FIELD, REGION_FIELD,
            ENABLE_PARTIAL_RESULTS_STABILIZATION_FIELD, PARTIAL_RESULTS_STABILITY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD,
            CONTENT_REDACTION_TYPE_FIELD, PII_ENTITY_TYPES_FIELD, LANGUAGE_MODEL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final String vocabularyFilterMethod;

    private final String vocabularyFilterName;

    private final String vocabularyName;

    private final String region;

    private final Boolean enablePartialResultsStabilization;

    private final String partialResultsStability;

    private final String contentIdentificationType;

    private final String contentRedactionType;

    private final String piiEntityTypes;

    private final String languageModelName;

    private EngineTranscribeSettings(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyName = builder.vocabularyName;
        this.region = builder.region;
        this.enablePartialResultsStabilization = builder.enablePartialResultsStabilization;
        this.partialResultsStability = builder.partialResultsStability;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.contentRedactionType = builder.contentRedactionType;
        this.piiEntityTypes = builder.piiEntityTypes;
        this.languageModelName = builder.languageModelName;
    }

    /**
     * <p>
     * The language code specified for the Amazon Transcribe engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link TranscribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code specified for the Amazon Transcribe engine.
     * @see TranscribeLanguageCode
     */
    public final TranscribeLanguageCode languageCode() {
        return TranscribeLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code specified for the Amazon Transcribe engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link TranscribeLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code specified for the Amazon Transcribe engine.
     * @see TranscribeLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The filtering method passed to Amazon Transcribe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link TranscribeVocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The filtering method passed to Amazon Transcribe.
     * @see TranscribeVocabularyFilterMethod
     */
    public final TranscribeVocabularyFilterMethod vocabularyFilterMethod() {
        return TranscribeVocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * The filtering method passed to Amazon Transcribe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link TranscribeVocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return The filtering method passed to Amazon Transcribe.
     * @see TranscribeVocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * The name of the vocabulary filter passed to Amazon Transcribe.
     * </p>
     * 
     * @return The name of the vocabulary filter passed to Amazon Transcribe.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The name of the vocabulary passed to Amazon Transcribe.
     * </p>
     * 
     * @return The name of the vocabulary passed to Amazon Transcribe.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's
     * Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link TranscribeRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the
     *         meeting's Region.
     * @see TranscribeRegion
     */
    public final TranscribeRegion region() {
        return TranscribeRegion.fromValue(region);
    }

    /**
     * <p>
     * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's
     * Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link TranscribeRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the
     *         meeting's Region.
     * @see TranscribeRegion
     */
    public final String regionAsString() {
        return region;
    }

    /**
     * <p>
     * Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by
     * only allowing the last few words from the partial results to change.
     * </p>
     * 
     * @return Generates partial transcription results that are less likely to change as meeting attendees speak. It
     *         does so by only allowing the last few words from the partial results to change.
     */
    public final Boolean enablePartialResultsStabilization() {
        return enablePartialResultsStabilization;
    }

    /**
     * <p>
     * The stabity level of a partial results transcription. Determines how stable you want the transcription results to
     * be. A higher level means the transcription results are less likely to change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link TranscribePartialResultsStability#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return The stabity level of a partial results transcription. Determines how stable you want the transcription
     *         results to be. A higher level means the transcription results are less likely to change.
     * @see TranscribePartialResultsStability
     */
    public final TranscribePartialResultsStability partialResultsStability() {
        return TranscribePartialResultsStability.fromValue(partialResultsStability);
    }

    /**
     * <p>
     * The stabity level of a partial results transcription. Determines how stable you want the transcription results to
     * be. A higher level means the transcription results are less likely to change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #partialResultsStability} will return {@link TranscribePartialResultsStability#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #partialResultsStabilityAsString}.
     * </p>
     * 
     * @return The stabity level of a partial results transcription. Determines how stable you want the transcription
     *         results to be. A higher level means the transcription results are less likely to change.
     * @see TranscribePartialResultsStability
     */
    public final String partialResultsStabilityAsString() {
        return partialResultsStability;
    }

    /**
     * <p>
     * Set this field to <code>PII</code> to identify personal health information in the transcription output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link TranscribeContentIdentificationType#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Set this field to <code>PII</code> to identify personal health information in the transcription output.
     * @see TranscribeContentIdentificationType
     */
    public final TranscribeContentIdentificationType contentIdentificationType() {
        return TranscribeContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Set this field to <code>PII</code> to identify personal health information in the transcription output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link TranscribeContentIdentificationType#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Set this field to <code>PII</code> to identify personal health information in the transcription output.
     * @see TranscribeContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * Set this field to <code>PII</code> to redact personally identifiable information in the transcription output.
     * Content redaction is performed only upon complete transcription of the audio segments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link TranscribeContentRedactionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Set this field to <code>PII</code> to redact personally identifiable information in the transcription
     *         output. Content redaction is performed only upon complete transcription of the audio segments.
     * @see TranscribeContentRedactionType
     */
    public final TranscribeContentRedactionType contentRedactionType() {
        return TranscribeContentRedactionType.fromValue(contentRedactionType);
    }

    /**
     * <p>
     * Set this field to <code>PII</code> to redact personally identifiable information in the transcription output.
     * Content redaction is performed only upon complete transcription of the audio segments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentRedactionType} will return {@link TranscribeContentRedactionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentRedactionTypeAsString}.
     * </p>
     * 
     * @return Set this field to <code>PII</code> to redact personally identifiable information in the transcription
     *         output. Content redaction is performed only upon complete transcription of the audio segments.
     * @see TranscribeContentRedactionType
     */
    public final String contentRedactionTypeAsString() {
        return contentRedactionType;
    }

    /**
     * <p>
     * Lists the PII entity types you want to identify or redact. To specify entity types, you must enable
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     * </p>
     * <p>
     * <code>PIIEntityTypes</code> must be comma-separated. The available values are: <code>BANK_ACCOUNT_NUMBER</code>,
     * <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>,
     * <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>,
     * <code>SSN</code>, and <code>ALL</code>.
     * </p>
     * <p>
     * <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.
     * </p>
     * 
     * @return Lists the PII entity types you want to identify or redact. To specify entity types, you must enable
     *         <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
     *         <p>
     *         <code>PIIEntityTypes</code> must be comma-separated. The available values are:
     *         <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>,
     *         <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>,
     *         <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.
     *         </p>
     *         <p>
     *         <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.
     */
    public final String piiEntityTypes() {
        return piiEntityTypes;
    }

    /**
     * <p>
     * The name of the language model used during transcription.
     * </p>
     * 
     * @return The name of the language model used during transcription.
     */
    public final String languageModelName() {
        return languageModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enablePartialResultsStabilization());
        hashCode = 31 * hashCode + Objects.hashCode(partialResultsStabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(piiEntityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(languageModelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineTranscribeSettings)) {
            return false;
        }
        EngineTranscribeSettings other = (EngineTranscribeSettings) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(regionAsString(), other.regionAsString())
                && Objects.equals(enablePartialResultsStabilization(), other.enablePartialResultsStabilization())
                && Objects.equals(partialResultsStabilityAsString(), other.partialResultsStabilityAsString())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(contentRedactionTypeAsString(), other.contentRedactionTypeAsString())
                && Objects.equals(piiEntityTypes(), other.piiEntityTypes())
                && Objects.equals(languageModelName(), other.languageModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngineTranscribeSettings").add("LanguageCode", languageCodeAsString())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString())
                .add("VocabularyFilterName", vocabularyFilterName()).add("VocabularyName", vocabularyName())
                .add("Region", regionAsString()).add("EnablePartialResultsStabilization", enablePartialResultsStabilization())
                .add("PartialResultsStability", partialResultsStabilityAsString())
                .add("ContentIdentificationType", contentIdentificationTypeAsString())
                .add("ContentRedactionType", contentRedactionTypeAsString()).add("PiiEntityTypes", piiEntityTypes())
                .add("LanguageModelName", languageModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "Region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "EnablePartialResultsStabilization":
            return Optional.ofNullable(clazz.cast(enablePartialResultsStabilization()));
        case "PartialResultsStability":
            return Optional.ofNullable(clazz.cast(partialResultsStabilityAsString()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "ContentRedactionType":
            return Optional.ofNullable(clazz.cast(contentRedactionTypeAsString()));
        case "PiiEntityTypes":
            return Optional.ofNullable(clazz.cast(piiEntityTypes()));
        case "LanguageModelName":
            return Optional.ofNullable(clazz.cast(languageModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineTranscribeSettings, T> g) {
        return obj -> g.apply((EngineTranscribeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineTranscribeSettings> {
        /**
         * <p>
         * The language code specified for the Amazon Transcribe engine.
         * </p>
         * 
         * @param languageCode
         *        The language code specified for the Amazon Transcribe engine.
         * @see TranscribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code specified for the Amazon Transcribe engine.
         * </p>
         * 
         * @param languageCode
         *        The language code specified for the Amazon Transcribe engine.
         * @see TranscribeLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeLanguageCode
         */
        Builder languageCode(TranscribeLanguageCode languageCode);

        /**
         * <p>
         * The filtering method passed to Amazon Transcribe.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The filtering method passed to Amazon Transcribe.
         * @see TranscribeVocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeVocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * The filtering method passed to Amazon Transcribe.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        The filtering method passed to Amazon Transcribe.
         * @see TranscribeVocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeVocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(TranscribeVocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * The name of the vocabulary filter passed to Amazon Transcribe.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the vocabulary filter passed to Amazon Transcribe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The name of the vocabulary passed to Amazon Transcribe.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary passed to Amazon Transcribe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's
         * Region.
         * </p>
         * 
         * @param region
         *        The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the
         *        meeting's Region.
         * @see TranscribeRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeRegion
         */
        Builder region(String region);

        /**
         * <p>
         * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's
         * Region.
         * </p>
         * 
         * @param region
         *        The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the
         *        meeting's Region.
         * @see TranscribeRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeRegion
         */
        Builder region(TranscribeRegion region);

        /**
         * <p>
         * Generates partial transcription results that are less likely to change as meeting attendees speak. It does so
         * by only allowing the last few words from the partial results to change.
         * </p>
         * 
         * @param enablePartialResultsStabilization
         *        Generates partial transcription results that are less likely to change as meeting attendees speak. It
         *        does so by only allowing the last few words from the partial results to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization);

        /**
         * <p>
         * The stabity level of a partial results transcription. Determines how stable you want the transcription
         * results to be. A higher level means the transcription results are less likely to change.
         * </p>
         * 
         * @param partialResultsStability
         *        The stabity level of a partial results transcription. Determines how stable you want the transcription
         *        results to be. A higher level means the transcription results are less likely to change.
         * @see TranscribePartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribePartialResultsStability
         */
        Builder partialResultsStability(String partialResultsStability);

        /**
         * <p>
         * The stabity level of a partial results transcription. Determines how stable you want the transcription
         * results to be. A higher level means the transcription results are less likely to change.
         * </p>
         * 
         * @param partialResultsStability
         *        The stabity level of a partial results transcription. Determines how stable you want the transcription
         *        results to be. A higher level means the transcription results are less likely to change.
         * @see TranscribePartialResultsStability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribePartialResultsStability
         */
        Builder partialResultsStability(TranscribePartialResultsStability partialResultsStability);

        /**
         * <p>
         * Set this field to <code>PII</code> to identify personal health information in the transcription output.
         * </p>
         * 
         * @param contentIdentificationType
         *        Set this field to <code>PII</code> to identify personal health information in the transcription
         *        output.
         * @see TranscribeContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Set this field to <code>PII</code> to identify personal health information in the transcription output.
         * </p>
         * 
         * @param contentIdentificationType
         *        Set this field to <code>PII</code> to identify personal health information in the transcription
         *        output.
         * @see TranscribeContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeContentIdentificationType
         */
        Builder contentIdentificationType(TranscribeContentIdentificationType contentIdentificationType);

        /**
         * <p>
         * Set this field to <code>PII</code> to redact personally identifiable information in the transcription output.
         * Content redaction is performed only upon complete transcription of the audio segments.
         * </p>
         * 
         * @param contentRedactionType
         *        Set this field to <code>PII</code> to redact personally identifiable information in the transcription
         *        output. Content redaction is performed only upon complete transcription of the audio segments.
         * @see TranscribeContentRedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeContentRedactionType
         */
        Builder contentRedactionType(String contentRedactionType);

        /**
         * <p>
         * Set this field to <code>PII</code> to redact personally identifiable information in the transcription output.
         * Content redaction is performed only upon complete transcription of the audio segments.
         * </p>
         * 
         * @param contentRedactionType
         *        Set this field to <code>PII</code> to redact personally identifiable information in the transcription
         *        output. Content redaction is performed only upon complete transcription of the audio segments.
         * @see TranscribeContentRedactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscribeContentRedactionType
         */
        Builder contentRedactionType(TranscribeContentRedactionType contentRedactionType);

        /**
         * <p>
         * Lists the PII entity types you want to identify or redact. To specify entity types, you must enable
         * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
         * </p>
         * <p>
         * <code>PIIEntityTypes</code> must be comma-separated. The available values are:
         * <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>,
         * <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>,
         * <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.
         * </p>
         * <p>
         * <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.
         * </p>
         * 
         * @param piiEntityTypes
         *        Lists the PII entity types you want to identify or redact. To specify entity types, you must enable
         *        <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
         *        <p>
         *        <code>PIIEntityTypes</code> must be comma-separated. The available values are:
         *        <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>,
         *        <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>,
         *        <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.
         *        </p>
         *        <p>
         *        <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntityTypes(String piiEntityTypes);

        /**
         * <p>
         * The name of the language model used during transcription.
         * </p>
         * 
         * @param languageModelName
         *        The name of the language model used during transcription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageModelName(String languageModelName);
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private String vocabularyFilterMethod;

        private String vocabularyFilterName;

        private String vocabularyName;

        private String region;

        private Boolean enablePartialResultsStabilization;

        private String partialResultsStability;

        private String contentIdentificationType;

        private String contentRedactionType;

        private String piiEntityTypes;

        private String languageModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineTranscribeSettings model) {
            languageCode(model.languageCode);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyName(model.vocabularyName);
            region(model.region);
            enablePartialResultsStabilization(model.enablePartialResultsStabilization);
            partialResultsStability(model.partialResultsStability);
            contentIdentificationType(model.contentIdentificationType);
            contentRedactionType(model.contentRedactionType);
            piiEntityTypes(model.piiEntityTypes);
            languageModelName(model.languageModelName);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(TranscribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(TranscribeVocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        @Transient
        public final Builder region(TranscribeRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final Boolean getEnablePartialResultsStabilization() {
            return enablePartialResultsStabilization;
        }

        public final void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
        }

        @Override
        @Transient
        public final Builder enablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
            this.enablePartialResultsStabilization = enablePartialResultsStabilization;
            return this;
        }

        public final String getPartialResultsStability() {
            return partialResultsStability;
        }

        public final void setPartialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(String partialResultsStability) {
            this.partialResultsStability = partialResultsStability;
            return this;
        }

        @Override
        @Transient
        public final Builder partialResultsStability(TranscribePartialResultsStability partialResultsStability) {
            this.partialResultsStability(partialResultsStability == null ? null : partialResultsStability.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(TranscribeContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getContentRedactionType() {
            return contentRedactionType;
        }

        public final void setContentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
        }

        @Override
        @Transient
        public final Builder contentRedactionType(String contentRedactionType) {
            this.contentRedactionType = contentRedactionType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentRedactionType(TranscribeContentRedactionType contentRedactionType) {
            this.contentRedactionType(contentRedactionType == null ? null : contentRedactionType.toString());
            return this;
        }

        public final String getPiiEntityTypes() {
            return piiEntityTypes;
        }

        public final void setPiiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
        }

        @Override
        @Transient
        public final Builder piiEntityTypes(String piiEntityTypes) {
            this.piiEntityTypes = piiEntityTypes;
            return this;
        }

        public final String getLanguageModelName() {
            return languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        @Transient
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        @Override
        public EngineTranscribeSettings build() {
            return new EngineTranscribeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
