/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGlobalSettingsResponse extends ChimeResponse implements
        ToCopyableBuilder<GetGlobalSettingsResponse.Builder, GetGlobalSettingsResponse> {
    private static final SdkField<BusinessCallingSettings> BUSINESS_CALLING_FIELD = SdkField
            .<BusinessCallingSettings> builder(MarshallingType.SDK_POJO).memberName("BusinessCalling")
            .getter(getter(GetGlobalSettingsResponse::businessCalling)).setter(setter(Builder::businessCalling))
            .constructor(BusinessCallingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessCalling").build()).build();

    private static final SdkField<VoiceConnectorSettings> VOICE_CONNECTOR_FIELD = SdkField
            .<VoiceConnectorSettings> builder(MarshallingType.SDK_POJO).memberName("VoiceConnector")
            .getter(getter(GetGlobalSettingsResponse::voiceConnector)).setter(setter(Builder::voiceConnector))
            .constructor(VoiceConnectorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_CALLING_FIELD,
            VOICE_CONNECTOR_FIELD));

    private final BusinessCallingSettings businessCalling;

    private final VoiceConnectorSettings voiceConnector;

    private GetGlobalSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.businessCalling = builder.businessCalling;
        this.voiceConnector = builder.voiceConnector;
    }

    /**
     * <p>
     * The Amazon Chime Business Calling settings.
     * </p>
     * 
     * @return The Amazon Chime Business Calling settings.
     */
    public final BusinessCallingSettings businessCalling() {
        return businessCalling;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector settings.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector settings.
     */
    public final VoiceConnectorSettings voiceConnector() {
        return voiceConnector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(businessCalling());
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGlobalSettingsResponse)) {
            return false;
        }
        GetGlobalSettingsResponse other = (GetGlobalSettingsResponse) obj;
        return Objects.equals(businessCalling(), other.businessCalling())
                && Objects.equals(voiceConnector(), other.voiceConnector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGlobalSettingsResponse").add("BusinessCalling", businessCalling())
                .add("VoiceConnector", voiceConnector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BusinessCalling":
            return Optional.ofNullable(clazz.cast(businessCalling()));
        case "VoiceConnector":
            return Optional.ofNullable(clazz.cast(voiceConnector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGlobalSettingsResponse, T> g) {
        return obj -> g.apply((GetGlobalSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGlobalSettingsResponse> {
        /**
         * <p>
         * The Amazon Chime Business Calling settings.
         * </p>
         * 
         * @param businessCalling
         *        The Amazon Chime Business Calling settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessCalling(BusinessCallingSettings businessCalling);

        /**
         * <p>
         * The Amazon Chime Business Calling settings.
         * </p>
         * This is a convenience that creates an instance of the {@link BusinessCallingSettings.Builder} avoiding the
         * need to create one manually via {@link BusinessCallingSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link BusinessCallingSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #businessCalling(BusinessCallingSettings)}.
         * 
         * @param businessCalling
         *        a consumer that will call methods on {@link BusinessCallingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessCalling(BusinessCallingSettings)
         */
        default Builder businessCalling(Consumer<BusinessCallingSettings.Builder> businessCalling) {
            return businessCalling(BusinessCallingSettings.builder().applyMutation(businessCalling).build());
        }

        /**
         * <p>
         * The Amazon Chime Voice Connector settings.
         * </p>
         * 
         * @param voiceConnector
         *        The Amazon Chime Voice Connector settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnector(VoiceConnectorSettings voiceConnector);

        /**
         * <p>
         * The Amazon Chime Voice Connector settings.
         * </p>
         * This is a convenience that creates an instance of the {@link VoiceConnectorSettings.Builder} avoiding the
         * need to create one manually via {@link VoiceConnectorSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VoiceConnectorSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #voiceConnector(VoiceConnectorSettings)}.
         * 
         * @param voiceConnector
         *        a consumer that will call methods on {@link VoiceConnectorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnector(VoiceConnectorSettings)
         */
        default Builder voiceConnector(Consumer<VoiceConnectorSettings.Builder> voiceConnector) {
            return voiceConnector(VoiceConnectorSettings.builder().applyMutation(voiceConnector).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private BusinessCallingSettings businessCalling;

        private VoiceConnectorSettings voiceConnector;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGlobalSettingsResponse model) {
            super(model);
            businessCalling(model.businessCalling);
            voiceConnector(model.voiceConnector);
        }

        public final BusinessCallingSettings.Builder getBusinessCalling() {
            return businessCalling != null ? businessCalling.toBuilder() : null;
        }

        public final void setBusinessCalling(BusinessCallingSettings.BuilderImpl businessCalling) {
            this.businessCalling = businessCalling != null ? businessCalling.build() : null;
        }

        @Override
        @Transient
        public final Builder businessCalling(BusinessCallingSettings businessCalling) {
            this.businessCalling = businessCalling;
            return this;
        }

        public final VoiceConnectorSettings.Builder getVoiceConnector() {
            return voiceConnector != null ? voiceConnector.toBuilder() : null;
        }

        public final void setVoiceConnector(VoiceConnectorSettings.BuilderImpl voiceConnector) {
            this.voiceConnector = voiceConnector != null ? voiceConnector.build() : null;
        }

        @Override
        @Transient
        public final Builder voiceConnector(VoiceConnectorSettings voiceConnector) {
            this.voiceConnector = voiceConnector;
            return this;
        }

        @Override
        public GetGlobalSettingsResponse build() {
            return new GetGlobalSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
