/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceConnectorTerminationHealthResponse extends ChimeResponse implements
        ToCopyableBuilder<GetVoiceConnectorTerminationHealthResponse.Builder, GetVoiceConnectorTerminationHealthResponse> {
    private static final SdkField<TerminationHealth> TERMINATION_HEALTH_FIELD = SdkField
            .<TerminationHealth> builder(MarshallingType.SDK_POJO).memberName("TerminationHealth")
            .getter(getter(GetVoiceConnectorTerminationHealthResponse::terminationHealth))
            .setter(setter(Builder::terminationHealth)).constructor(TerminationHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationHealth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATION_HEALTH_FIELD));

    private final TerminationHealth terminationHealth;

    private GetVoiceConnectorTerminationHealthResponse(BuilderImpl builder) {
        super(builder);
        this.terminationHealth = builder.terminationHealth;
    }

    /**
     * <p>
     * The termination health details.
     * </p>
     * 
     * @return The termination health details.
     */
    public final TerminationHealth terminationHealth() {
        return terminationHealth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(terminationHealth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceConnectorTerminationHealthResponse)) {
            return false;
        }
        GetVoiceConnectorTerminationHealthResponse other = (GetVoiceConnectorTerminationHealthResponse) obj;
        return Objects.equals(terminationHealth(), other.terminationHealth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceConnectorTerminationHealthResponse").add("TerminationHealth", terminationHealth())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminationHealth":
            return Optional.ofNullable(clazz.cast(terminationHealth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceConnectorTerminationHealthResponse, T> g) {
        return obj -> g.apply((GetVoiceConnectorTerminationHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceConnectorTerminationHealthResponse> {
        /**
         * <p>
         * The termination health details.
         * </p>
         * 
         * @param terminationHealth
         *        The termination health details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationHealth(TerminationHealth terminationHealth);

        /**
         * <p>
         * The termination health details.
         * </p>
         * This is a convenience that creates an instance of the {@link TerminationHealth.Builder} avoiding the need to
         * create one manually via {@link TerminationHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminationHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #terminationHealth(TerminationHealth)}.
         * 
         * @param terminationHealth
         *        a consumer that will call methods on {@link TerminationHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminationHealth(TerminationHealth)
         */
        default Builder terminationHealth(Consumer<TerminationHealth.Builder> terminationHealth) {
            return terminationHealth(TerminationHealth.builder().applyMutation(terminationHealth).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private TerminationHealth terminationHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceConnectorTerminationHealthResponse model) {
            super(model);
            terminationHealth(model.terminationHealth);
        }

        public final TerminationHealth.Builder getTerminationHealth() {
            return terminationHealth != null ? terminationHealth.toBuilder() : null;
        }

        public final void setTerminationHealth(TerminationHealth.BuilderImpl terminationHealth) {
            this.terminationHealth = terminationHealth != null ? terminationHealth.build() : null;
        }

        @Override
        @Transient
        public final Builder terminationHealth(TerminationHealth terminationHealth) {
            this.terminationHealth = terminationHealth;
            return this;
        }

        @Override
        public GetVoiceConnectorTerminationHealthResponse build() {
            return new GetVoiceConnectorTerminationHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
