/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppInstanceAdminsResponse extends ChimeResponse implements
        ToCopyableBuilder<ListAppInstanceAdminsResponse.Builder, ListAppInstanceAdminsResponse> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(ListAppInstanceAdminsResponse::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()).build();

    private static final SdkField<List<AppInstanceAdminSummary>> APP_INSTANCE_ADMINS_FIELD = SdkField
            .<List<AppInstanceAdminSummary>> builder(MarshallingType.LIST)
            .memberName("AppInstanceAdmins")
            .getter(getter(ListAppInstanceAdminsResponse::appInstanceAdmins))
            .setter(setter(Builder::appInstanceAdmins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceAdmins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppInstanceAdminSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppInstanceAdminSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppInstanceAdminsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD,
            APP_INSTANCE_ADMINS_FIELD, NEXT_TOKEN_FIELD));

    private final String appInstanceArn;

    private final List<AppInstanceAdminSummary> appInstanceAdmins;

    private final String nextToken;

    private ListAppInstanceAdminsResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceAdmins = builder.appInstanceAdmins;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code>.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppInstanceAdmins property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppInstanceAdmins() {
        return appInstanceAdmins != null && !(appInstanceAdmins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for each administrator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppInstanceAdmins} method.
     * </p>
     * 
     * @return The information for each administrator.
     */
    public final List<AppInstanceAdminSummary> appInstanceAdmins() {
        return appInstanceAdmins;
    }

    /**
     * <p>
     * The token returned from previous API requests until the number of administrators is reached.
     * </p>
     * 
     * @return The token returned from previous API requests until the number of administrators is reached.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppInstanceAdmins() ? appInstanceAdmins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstanceAdminsResponse)) {
            return false;
        }
        ListAppInstanceAdminsResponse other = (ListAppInstanceAdminsResponse) obj;
        return Objects.equals(appInstanceArn(), other.appInstanceArn()) && hasAppInstanceAdmins() == other.hasAppInstanceAdmins()
                && Objects.equals(appInstanceAdmins(), other.appInstanceAdmins())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppInstanceAdminsResponse").add("AppInstanceArn", appInstanceArn())
                .add("AppInstanceAdmins", hasAppInstanceAdmins() ? appInstanceAdmins() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "AppInstanceAdmins":
            return Optional.ofNullable(clazz.cast(appInstanceAdmins()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstanceAdminsResponse, T> g) {
        return obj -> g.apply((ListAppInstanceAdminsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppInstanceAdminsResponse> {
        /**
         * <p>
         * The ARN of the <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The information for each administrator.
         * </p>
         * 
         * @param appInstanceAdmins
         *        The information for each administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceAdmins(Collection<AppInstanceAdminSummary> appInstanceAdmins);

        /**
         * <p>
         * The information for each administrator.
         * </p>
         * 
         * @param appInstanceAdmins
         *        The information for each administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceAdmins(AppInstanceAdminSummary... appInstanceAdmins);

        /**
         * <p>
         * The information for each administrator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppInstanceAdminSummary>.Builder} avoiding
         * the need to create one manually via {@link List<AppInstanceAdminSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppInstanceAdminSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #appInstanceAdmins(List<AppInstanceAdminSummary>)}.
         * 
         * @param appInstanceAdmins
         *        a consumer that will call methods on {@link List<AppInstanceAdminSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceAdmins(List<AppInstanceAdminSummary>)
         */
        Builder appInstanceAdmins(Consumer<AppInstanceAdminSummary.Builder>... appInstanceAdmins);

        /**
         * <p>
         * The token returned from previous API requests until the number of administrators is reached.
         * </p>
         * 
         * @param nextToken
         *        The token returned from previous API requests until the number of administrators is reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private String appInstanceArn;

        private List<AppInstanceAdminSummary> appInstanceAdmins = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstanceAdminsResponse model) {
            super(model);
            appInstanceArn(model.appInstanceArn);
            appInstanceAdmins(model.appInstanceAdmins);
            nextToken(model.nextToken);
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        @Transient
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final List<AppInstanceAdminSummary.Builder> getAppInstanceAdmins() {
            List<AppInstanceAdminSummary.Builder> result = AppInstanceAdminListCopier.copyToBuilder(this.appInstanceAdmins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInstanceAdmins(Collection<AppInstanceAdminSummary.BuilderImpl> appInstanceAdmins) {
            this.appInstanceAdmins = AppInstanceAdminListCopier.copyFromBuilder(appInstanceAdmins);
        }

        @Override
        @Transient
        public final Builder appInstanceAdmins(Collection<AppInstanceAdminSummary> appInstanceAdmins) {
            this.appInstanceAdmins = AppInstanceAdminListCopier.copy(appInstanceAdmins);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appInstanceAdmins(AppInstanceAdminSummary... appInstanceAdmins) {
            appInstanceAdmins(Arrays.asList(appInstanceAdmins));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appInstanceAdmins(Consumer<AppInstanceAdminSummary.Builder>... appInstanceAdmins) {
            appInstanceAdmins(Stream.of(appInstanceAdmins).map(c -> AppInstanceAdminSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInstanceAdminsResponse build() {
            return new ListAppInstanceAdminsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
