/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppInstanceUsersResponse extends ChimeResponse implements
        ToCopyableBuilder<ListAppInstanceUsersResponse.Builder, ListAppInstanceUsersResponse> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(ListAppInstanceUsersResponse::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()).build();

    private static final SdkField<List<AppInstanceUserSummary>> APP_INSTANCE_USERS_FIELD = SdkField
            .<List<AppInstanceUserSummary>> builder(MarshallingType.LIST)
            .memberName("AppInstanceUsers")
            .getter(getter(ListAppInstanceUsersResponse::appInstanceUsers))
            .setter(setter(Builder::appInstanceUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppInstanceUserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppInstanceUserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppInstanceUsersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD,
            APP_INSTANCE_USERS_FIELD, NEXT_TOKEN_FIELD));

    private final String appInstanceArn;

    private final List<AppInstanceUserSummary> appInstanceUsers;

    private final String nextToken;

    private ListAppInstanceUsersResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceUsers = builder.appInstanceUsers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code>.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppInstanceUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppInstanceUsers() {
        return appInstanceUsers != null && !(appInstanceUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for each requested <code>AppInstanceUser</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppInstanceUsers} method.
     * </p>
     * 
     * @return The information for each requested <code>AppInstanceUser</code>.
     */
    public final List<AppInstanceUserSummary> appInstanceUsers() {
        return appInstanceUsers;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested users are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested users are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppInstanceUsers() ? appInstanceUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstanceUsersResponse)) {
            return false;
        }
        ListAppInstanceUsersResponse other = (ListAppInstanceUsersResponse) obj;
        return Objects.equals(appInstanceArn(), other.appInstanceArn()) && hasAppInstanceUsers() == other.hasAppInstanceUsers()
                && Objects.equals(appInstanceUsers(), other.appInstanceUsers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppInstanceUsersResponse").add("AppInstanceArn", appInstanceArn())
                .add("AppInstanceUsers", hasAppInstanceUsers() ? appInstanceUsers() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "AppInstanceUsers":
            return Optional.ofNullable(clazz.cast(appInstanceUsers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstanceUsersResponse, T> g) {
        return obj -> g.apply((ListAppInstanceUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppInstanceUsersResponse> {
        /**
         * <p>
         * The ARN of the <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The information for each requested <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUsers
         *        The information for each requested <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUsers(Collection<AppInstanceUserSummary> appInstanceUsers);

        /**
         * <p>
         * The information for each requested <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUsers
         *        The information for each requested <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUsers(AppInstanceUserSummary... appInstanceUsers);

        /**
         * <p>
         * The information for each requested <code>AppInstanceUser</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppInstanceUserSummary>.Builder} avoiding
         * the need to create one manually via {@link List<AppInstanceUserSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppInstanceUserSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #appInstanceUsers(List<AppInstanceUserSummary>)}.
         * 
         * @param appInstanceUsers
         *        a consumer that will call methods on {@link List<AppInstanceUserSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceUsers(List<AppInstanceUserSummary>)
         */
        Builder appInstanceUsers(Consumer<AppInstanceUserSummary.Builder>... appInstanceUsers);

        /**
         * <p>
         * The token passed by previous API calls until all requested users are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested users are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private String appInstanceArn;

        private List<AppInstanceUserSummary> appInstanceUsers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstanceUsersResponse model) {
            super(model);
            appInstanceArn(model.appInstanceArn);
            appInstanceUsers(model.appInstanceUsers);
            nextToken(model.nextToken);
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        @Transient
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final List<AppInstanceUserSummary.Builder> getAppInstanceUsers() {
            List<AppInstanceUserSummary.Builder> result = AppInstanceUserListCopier.copyToBuilder(this.appInstanceUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInstanceUsers(Collection<AppInstanceUserSummary.BuilderImpl> appInstanceUsers) {
            this.appInstanceUsers = AppInstanceUserListCopier.copyFromBuilder(appInstanceUsers);
        }

        @Override
        @Transient
        public final Builder appInstanceUsers(Collection<AppInstanceUserSummary> appInstanceUsers) {
            this.appInstanceUsers = AppInstanceUserListCopier.copy(appInstanceUsers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appInstanceUsers(AppInstanceUserSummary... appInstanceUsers) {
            appInstanceUsers(Arrays.asList(appInstanceUsers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appInstanceUsers(Consumer<AppInstanceUserSummary.Builder>... appInstanceUsers) {
            appInstanceUsers(Stream.of(appInstanceUsers).map(c -> AppInstanceUserSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInstanceUsersResponse build() {
            return new ListAppInstanceUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
