/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelModeratorsResponse extends ChimeResponse implements
        ToCopyableBuilder<ListChannelModeratorsResponse.Builder, ListChannelModeratorsResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ListChannelModeratorsResponse::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelModeratorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ChannelModeratorSummary>> CHANNEL_MODERATORS_FIELD = SdkField
            .<List<ChannelModeratorSummary>> builder(MarshallingType.LIST)
            .memberName("ChannelModerators")
            .getter(getter(ListChannelModeratorsResponse::channelModerators))
            .setter(setter(Builder::channelModerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelModerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelModeratorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelModeratorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            NEXT_TOKEN_FIELD, CHANNEL_MODERATORS_FIELD));

    private final String channelArn;

    private final String nextToken;

    private final List<ChannelModeratorSummary> channelModerators;

    private ListChannelModeratorsResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.nextToken = builder.nextToken;
        this.channelModerators = builder.channelModerators;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested moderators are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested moderators are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelModerators property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelModerators() {
        return channelModerators != null && !(channelModerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information about and names of each moderator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelModerators} method.
     * </p>
     * 
     * @return The information about and names of each moderator.
     */
    public final List<ChannelModeratorSummary> channelModerators() {
        return channelModerators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelModerators() ? channelModerators() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelModeratorsResponse)) {
            return false;
        }
        ListChannelModeratorsResponse other = (ListChannelModeratorsResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(nextToken(), other.nextToken())
                && hasChannelModerators() == other.hasChannelModerators()
                && Objects.equals(channelModerators(), other.channelModerators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelModeratorsResponse").add("ChannelArn", channelArn())
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelModerators", hasChannelModerators() ? channelModerators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ChannelModerators":
            return Optional.ofNullable(clazz.cast(channelModerators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelModeratorsResponse, T> g) {
        return obj -> g.apply((ListChannelModeratorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListChannelModeratorsResponse> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The token passed by previous API calls until all requested moderators are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested moderators are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The information about and names of each moderator.
         * </p>
         * 
         * @param channelModerators
         *        The information about and names of each moderator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelModerators(Collection<ChannelModeratorSummary> channelModerators);

        /**
         * <p>
         * The information about and names of each moderator.
         * </p>
         * 
         * @param channelModerators
         *        The information about and names of each moderator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelModerators(ChannelModeratorSummary... channelModerators);

        /**
         * <p>
         * The information about and names of each moderator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ChannelModeratorSummary>.Builder} avoiding
         * the need to create one manually via {@link List<ChannelModeratorSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelModeratorSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #channelModerators(List<ChannelModeratorSummary>)}.
         * 
         * @param channelModerators
         *        a consumer that will call methods on {@link List<ChannelModeratorSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelModerators(List<ChannelModeratorSummary>)
         */
        Builder channelModerators(Consumer<ChannelModeratorSummary.Builder>... channelModerators);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private String channelArn;

        private String nextToken;

        private List<ChannelModeratorSummary> channelModerators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelModeratorsResponse model) {
            super(model);
            channelArn(model.channelArn);
            nextToken(model.nextToken);
            channelModerators(model.channelModerators);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChannelModeratorSummary.Builder> getChannelModerators() {
            List<ChannelModeratorSummary.Builder> result = ChannelModeratorSummaryListCopier
                    .copyToBuilder(this.channelModerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelModerators(Collection<ChannelModeratorSummary.BuilderImpl> channelModerators) {
            this.channelModerators = ChannelModeratorSummaryListCopier.copyFromBuilder(channelModerators);
        }

        @Override
        @Transient
        public final Builder channelModerators(Collection<ChannelModeratorSummary> channelModerators) {
            this.channelModerators = ChannelModeratorSummaryListCopier.copy(channelModerators);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelModerators(ChannelModeratorSummary... channelModerators) {
            channelModerators(Arrays.asList(channelModerators));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelModerators(Consumer<ChannelModeratorSummary.Builder>... channelModerators) {
            channelModerators(Stream.of(channelModerators).map(c -> ChannelModeratorSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListChannelModeratorsResponse build() {
            return new ListChannelModeratorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
