/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proxy configuration for an Amazon Chime Voice Connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Proxy implements SdkPojo, Serializable, ToCopyableBuilder<Proxy.Builder, Proxy> {
    private static final SdkField<Integer> DEFAULT_SESSION_EXPIRY_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultSessionExpiryMinutes")
            .getter(getter(Proxy::defaultSessionExpiryMinutes))
            .setter(setter(Builder::defaultSessionExpiryMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSessionExpiryMinutes")
                    .build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(Proxy::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<String> FALL_BACK_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallBackPhoneNumber").getter(getter(Proxy::fallBackPhoneNumber))
            .setter(setter(Builder::fallBackPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallBackPhoneNumber").build())
            .build();

    private static final SdkField<List<String>> PHONE_NUMBER_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberCountries")
            .getter(getter(Proxy::phoneNumberCountries))
            .setter(setter(Builder::phoneNumberCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_SESSION_EXPIRY_MINUTES_FIELD, DISABLED_FIELD, FALL_BACK_PHONE_NUMBER_FIELD, PHONE_NUMBER_COUNTRIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer defaultSessionExpiryMinutes;

    private final Boolean disabled;

    private final String fallBackPhoneNumber;

    private final List<String> phoneNumberCountries;

    private Proxy(BuilderImpl builder) {
        this.defaultSessionExpiryMinutes = builder.defaultSessionExpiryMinutes;
        this.disabled = builder.disabled;
        this.fallBackPhoneNumber = builder.fallBackPhoneNumber;
        this.phoneNumberCountries = builder.phoneNumberCountries;
    }

    /**
     * <p>
     * The default number of minutes allowed for proxy sessions.
     * </p>
     * 
     * @return The default number of minutes allowed for proxy sessions.
     */
    public final Integer defaultSessionExpiryMinutes() {
        return defaultSessionExpiryMinutes;
    }

    /**
     * <p>
     * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
     * </p>
     * 
     * @return When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * <p>
     * The phone number to route calls to after a proxy session expires.
     * </p>
     * 
     * @return The phone number to route calls to after a proxy session expires.
     */
    public final String fallBackPhoneNumber() {
        return fallBackPhoneNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumberCountries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhoneNumberCountries() {
        return phoneNumberCountries != null && !(phoneNumberCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The countries for proxy phone numbers to be selected from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumberCountries} method.
     * </p>
     * 
     * @return The countries for proxy phone numbers to be selected from.
     */
    public final List<String> phoneNumberCountries() {
        return phoneNumberCountries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultSessionExpiryMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(fallBackPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberCountries() ? phoneNumberCountries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Proxy)) {
            return false;
        }
        Proxy other = (Proxy) obj;
        return Objects.equals(defaultSessionExpiryMinutes(), other.defaultSessionExpiryMinutes())
                && Objects.equals(disabled(), other.disabled())
                && Objects.equals(fallBackPhoneNumber(), other.fallBackPhoneNumber())
                && hasPhoneNumberCountries() == other.hasPhoneNumberCountries()
                && Objects.equals(phoneNumberCountries(), other.phoneNumberCountries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Proxy").add("DefaultSessionExpiryMinutes", defaultSessionExpiryMinutes())
                .add("Disabled", disabled())
                .add("FallBackPhoneNumber", fallBackPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumberCountries", hasPhoneNumberCountries() ? phoneNumberCountries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultSessionExpiryMinutes":
            return Optional.ofNullable(clazz.cast(defaultSessionExpiryMinutes()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "FallBackPhoneNumber":
            return Optional.ofNullable(clazz.cast(fallBackPhoneNumber()));
        case "PhoneNumberCountries":
            return Optional.ofNullable(clazz.cast(phoneNumberCountries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Proxy, T> g) {
        return obj -> g.apply((Proxy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Proxy> {
        /**
         * <p>
         * The default number of minutes allowed for proxy sessions.
         * </p>
         * 
         * @param defaultSessionExpiryMinutes
         *        The default number of minutes allowed for proxy sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes);

        /**
         * <p>
         * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
         * </p>
         * 
         * @param disabled
         *        When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * The phone number to route calls to after a proxy session expires.
         * </p>
         * 
         * @param fallBackPhoneNumber
         *        The phone number to route calls to after a proxy session expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fallBackPhoneNumber(String fallBackPhoneNumber);

        /**
         * <p>
         * The countries for proxy phone numbers to be selected from.
         * </p>
         * 
         * @param phoneNumberCountries
         *        The countries for proxy phone numbers to be selected from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountries(Collection<String> phoneNumberCountries);

        /**
         * <p>
         * The countries for proxy phone numbers to be selected from.
         * </p>
         * 
         * @param phoneNumberCountries
         *        The countries for proxy phone numbers to be selected from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountries(String... phoneNumberCountries);
    }

    static final class BuilderImpl implements Builder {
        private Integer defaultSessionExpiryMinutes;

        private Boolean disabled;

        private String fallBackPhoneNumber;

        private List<String> phoneNumberCountries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Proxy model) {
            defaultSessionExpiryMinutes(model.defaultSessionExpiryMinutes);
            disabled(model.disabled);
            fallBackPhoneNumber(model.fallBackPhoneNumber);
            phoneNumberCountries(model.phoneNumberCountries);
        }

        public final Integer getDefaultSessionExpiryMinutes() {
            return defaultSessionExpiryMinutes;
        }

        public final void setDefaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
        }

        @Override
        @Transient
        public final Builder defaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        @Transient
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final String getFallBackPhoneNumber() {
            return fallBackPhoneNumber;
        }

        public final void setFallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
        }

        @Override
        @Transient
        public final Builder fallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
            return this;
        }

        public final Collection<String> getPhoneNumberCountries() {
            if (phoneNumberCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return phoneNumberCountries;
        }

        public final void setPhoneNumberCountries(Collection<String> phoneNumberCountries) {
            this.phoneNumberCountries = StringListCopier.copy(phoneNumberCountries);
        }

        @Override
        @Transient
        public final Builder phoneNumberCountries(Collection<String> phoneNumberCountries) {
            this.phoneNumberCountries = StringListCopier.copy(phoneNumberCountries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phoneNumberCountries(String... phoneNumberCountries) {
            phoneNumberCountries(Arrays.asList(phoneNumberCountries));
            return this;
        }

        @Override
        public Proxy build() {
            return new Proxy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
