/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAppInstanceRetentionSettingsResponse extends ChimeResponse implements
        ToCopyableBuilder<PutAppInstanceRetentionSettingsResponse.Builder, PutAppInstanceRetentionSettingsResponse> {
    private static final SdkField<AppInstanceRetentionSettings> APP_INSTANCE_RETENTION_SETTINGS_FIELD = SdkField
            .<AppInstanceRetentionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("AppInstanceRetentionSettings")
            .getter(getter(PutAppInstanceRetentionSettingsResponse::appInstanceRetentionSettings))
            .setter(setter(Builder::appInstanceRetentionSettings))
            .constructor(AppInstanceRetentionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceRetentionSettings")
                    .build()).build();

    private static final SdkField<Instant> INITIATE_DELETION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("InitiateDeletionTimestamp")
            .getter(getter(PutAppInstanceRetentionSettingsResponse::initiateDeletionTimestamp))
            .setter(setter(Builder::initiateDeletionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiateDeletionTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APP_INSTANCE_RETENTION_SETTINGS_FIELD, INITIATE_DELETION_TIMESTAMP_FIELD));

    private final AppInstanceRetentionSettings appInstanceRetentionSettings;

    private final Instant initiateDeletionTimestamp;

    private PutAppInstanceRetentionSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceRetentionSettings = builder.appInstanceRetentionSettings;
        this.initiateDeletionTimestamp = builder.initiateDeletionTimestamp;
    }

    /**
     * <p>
     * The time in days to retain data. Data type: number.
     * </p>
     * 
     * @return The time in days to retain data. Data type: number.
     */
    public final AppInstanceRetentionSettings appInstanceRetentionSettings() {
        return appInstanceRetentionSettings;
    }

    /**
     * <p>
     * The time at which the API deletes data.
     * </p>
     * 
     * @return The time at which the API deletes data.
     */
    public final Instant initiateDeletionTimestamp() {
        return initiateDeletionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceRetentionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(initiateDeletionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppInstanceRetentionSettingsResponse)) {
            return false;
        }
        PutAppInstanceRetentionSettingsResponse other = (PutAppInstanceRetentionSettingsResponse) obj;
        return Objects.equals(appInstanceRetentionSettings(), other.appInstanceRetentionSettings())
                && Objects.equals(initiateDeletionTimestamp(), other.initiateDeletionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAppInstanceRetentionSettingsResponse")
                .add("AppInstanceRetentionSettings", appInstanceRetentionSettings())
                .add("InitiateDeletionTimestamp", initiateDeletionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceRetentionSettings":
            return Optional.ofNullable(clazz.cast(appInstanceRetentionSettings()));
        case "InitiateDeletionTimestamp":
            return Optional.ofNullable(clazz.cast(initiateDeletionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAppInstanceRetentionSettingsResponse, T> g) {
        return obj -> g.apply((PutAppInstanceRetentionSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutAppInstanceRetentionSettingsResponse> {
        /**
         * <p>
         * The time in days to retain data. Data type: number.
         * </p>
         * 
         * @param appInstanceRetentionSettings
         *        The time in days to retain data. Data type: number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceRetentionSettings(AppInstanceRetentionSettings appInstanceRetentionSettings);

        /**
         * <p>
         * The time in days to retain data. Data type: number.
         * </p>
         * This is a convenience that creates an instance of the {@link AppInstanceRetentionSettings.Builder} avoiding
         * the need to create one manually via {@link AppInstanceRetentionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppInstanceRetentionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #appInstanceRetentionSettings(AppInstanceRetentionSettings)}.
         * 
         * @param appInstanceRetentionSettings
         *        a consumer that will call methods on {@link AppInstanceRetentionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceRetentionSettings(AppInstanceRetentionSettings)
         */
        default Builder appInstanceRetentionSettings(Consumer<AppInstanceRetentionSettings.Builder> appInstanceRetentionSettings) {
            return appInstanceRetentionSettings(AppInstanceRetentionSettings.builder()
                    .applyMutation(appInstanceRetentionSettings).build());
        }

        /**
         * <p>
         * The time at which the API deletes data.
         * </p>
         * 
         * @param initiateDeletionTimestamp
         *        The time at which the API deletes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiateDeletionTimestamp(Instant initiateDeletionTimestamp);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private AppInstanceRetentionSettings appInstanceRetentionSettings;

        private Instant initiateDeletionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppInstanceRetentionSettingsResponse model) {
            super(model);
            appInstanceRetentionSettings(model.appInstanceRetentionSettings);
            initiateDeletionTimestamp(model.initiateDeletionTimestamp);
        }

        public final AppInstanceRetentionSettings.Builder getAppInstanceRetentionSettings() {
            return appInstanceRetentionSettings != null ? appInstanceRetentionSettings.toBuilder() : null;
        }

        public final void setAppInstanceRetentionSettings(AppInstanceRetentionSettings.BuilderImpl appInstanceRetentionSettings) {
            this.appInstanceRetentionSettings = appInstanceRetentionSettings != null ? appInstanceRetentionSettings.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder appInstanceRetentionSettings(AppInstanceRetentionSettings appInstanceRetentionSettings) {
            this.appInstanceRetentionSettings = appInstanceRetentionSettings;
            return this;
        }

        public final Instant getInitiateDeletionTimestamp() {
            return initiateDeletionTimestamp;
        }

        public final void setInitiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
        }

        @Override
        @Transient
        public final Builder initiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
            return this;
        }

        @Override
        public PutAppInstanceRetentionSettingsResponse build() {
            return new PutAppInstanceRetentionSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
