/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorStreamingConfigurationRequest extends ChimeRequest implements
        ToCopyableBuilder<PutVoiceConnectorStreamingConfigurationRequest.Builder, PutVoiceConnectorStreamingConfigurationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(PutVoiceConnectorStreamingConfigurationRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()).build();

    private static final SdkField<StreamingConfiguration> STREAMING_CONFIGURATION_FIELD = SdkField
            .<StreamingConfiguration> builder(MarshallingType.SDK_POJO).memberName("StreamingConfiguration")
            .getter(getter(PutVoiceConnectorStreamingConfigurationRequest::streamingConfiguration))
            .setter(setter(Builder::streamingConfiguration)).constructor(StreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            STREAMING_CONFIGURATION_FIELD));

    private final String voiceConnectorId;

    private final StreamingConfiguration streamingConfiguration;

    private PutVoiceConnectorStreamingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.streamingConfiguration = builder.streamingConfiguration;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector ID.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The streaming configuration details to add.
     * </p>
     * 
     * @return The streaming configuration details to add.
     */
    public final StreamingConfiguration streamingConfiguration() {
        return streamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(streamingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorStreamingConfigurationRequest)) {
            return false;
        }
        PutVoiceConnectorStreamingConfigurationRequest other = (PutVoiceConnectorStreamingConfigurationRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(streamingConfiguration(), other.streamingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVoiceConnectorStreamingConfigurationRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("StreamingConfiguration", streamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "StreamingConfiguration":
            return Optional.ofNullable(clazz.cast(streamingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorStreamingConfigurationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorStreamingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutVoiceConnectorStreamingConfigurationRequest> {
        /**
         * <p>
         * The Amazon Chime Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Amazon Chime Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The streaming configuration details to add.
         * </p>
         * 
         * @param streamingConfiguration
         *        The streaming configuration details to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingConfiguration(StreamingConfiguration streamingConfiguration);

        /**
         * <p>
         * The streaming configuration details to add.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingConfiguration.Builder} avoiding the
         * need to create one manually via {@link StreamingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingConfiguration(StreamingConfiguration)}.
         * 
         * @param streamingConfiguration
         *        a consumer that will call methods on {@link StreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingConfiguration(StreamingConfiguration)
         */
        default Builder streamingConfiguration(Consumer<StreamingConfiguration.Builder> streamingConfiguration) {
            return streamingConfiguration(StreamingConfiguration.builder().applyMutation(streamingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private StreamingConfiguration streamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorStreamingConfigurationRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            streamingConfiguration(model.streamingConfiguration);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        @Transient
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final StreamingConfiguration.Builder getStreamingConfiguration() {
            return streamingConfiguration != null ? streamingConfiguration.toBuilder() : null;
        }

        public final void setStreamingConfiguration(StreamingConfiguration.BuilderImpl streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration != null ? streamingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder streamingConfiguration(StreamingConfiguration streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorStreamingConfigurationRequest build() {
            return new PutVoiceConnectorStreamingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
