/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAvailablePhoneNumbersRequest extends ChimeRequest implements
        ToCopyableBuilder<SearchAvailablePhoneNumbersRequest.Builder, SearchAvailablePhoneNumbersRequest> {
    private static final SdkField<String> AREA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AreaCode").getter(getter(SearchAvailablePhoneNumbersRequest::areaCode))
            .setter(setter(Builder::areaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("area-code").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(SearchAvailablePhoneNumbersRequest::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("city").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(SearchAvailablePhoneNumbersRequest::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("country").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(SearchAvailablePhoneNumbersRequest::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()).build();

    private static final SdkField<String> TOLL_FREE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TollFreePrefix").getter(getter(SearchAvailablePhoneNumbersRequest::tollFreePrefix))
            .setter(setter(Builder::tollFreePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("toll-free-prefix").build())
            .build();

    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberType").getter(getter(SearchAvailablePhoneNumbersRequest::phoneNumberTypeAsString))
            .setter(setter(Builder::phoneNumberType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("phone-number-type").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchAvailablePhoneNumbersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchAvailablePhoneNumbersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_CODE_FIELD, CITY_FIELD,
            COUNTRY_FIELD, STATE_FIELD, TOLL_FREE_PREFIX_FIELD, PHONE_NUMBER_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String areaCode;

    private final String city;

    private final String country;

    private final String state;

    private final String tollFreePrefix;

    private final String phoneNumberType;

    private final Integer maxResults;

    private final String nextToken;

    private SearchAvailablePhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.areaCode = builder.areaCode;
        this.city = builder.city;
        this.country = builder.country;
        this.state = builder.state;
        this.tollFreePrefix = builder.tollFreePrefix;
        this.phoneNumberType = builder.phoneNumberType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The area code used to filter results. Only applies to the US.
     * </p>
     * 
     * @return The area code used to filter results. Only applies to the US.
     */
    public final String areaCode() {
        return areaCode;
    }

    /**
     * <p>
     * The city used to filter results. Only applies to the US.
     * </p>
     * 
     * @return The city used to filter results. Only applies to the US.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.
     * </p>
     * 
     * @return The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.
     * </p>
     * 
     * @return The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The toll-free prefix that you use to filter results. Only applies to the US.
     * </p>
     * 
     * @return The toll-free prefix that you use to filter results. Only applies to the US.
     */
    public final String tollFreePrefix() {
        return tollFreePrefix;
    }

    /**
     * <p>
     * The phone number type used to filter results. Required for non-US numbers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The phone number type used to filter results. Required for non-US numbers.
     * @see PhoneNumberType
     */
    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(phoneNumberType);
    }

    /**
     * <p>
     * The phone number type used to filter results. Required for non-US numbers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The phone number type used to filter results. Required for non-US numbers.
     * @see PhoneNumberType
     */
    public final String phoneNumberTypeAsString() {
        return phoneNumberType;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results.
     * </p>
     * 
     * @return The token used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(areaCode());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(tollFreePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersRequest)) {
            return false;
        }
        SearchAvailablePhoneNumbersRequest other = (SearchAvailablePhoneNumbersRequest) obj;
        return Objects.equals(areaCode(), other.areaCode()) && Objects.equals(city(), other.city())
                && Objects.equals(country(), other.country()) && Objects.equals(state(), other.state())
                && Objects.equals(tollFreePrefix(), other.tollFreePrefix())
                && Objects.equals(phoneNumberTypeAsString(), other.phoneNumberTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAvailablePhoneNumbersRequest").add("AreaCode", areaCode()).add("City", city())
                .add("Country", country()).add("State", state()).add("TollFreePrefix", tollFreePrefix())
                .add("PhoneNumberType", phoneNumberTypeAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AreaCode":
            return Optional.ofNullable(clazz.cast(areaCode()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "TollFreePrefix":
            return Optional.ofNullable(clazz.cast(tollFreePrefix()));
        case "PhoneNumberType":
            return Optional.ofNullable(clazz.cast(phoneNumberTypeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersRequest, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchAvailablePhoneNumbersRequest> {
        /**
         * <p>
         * The area code used to filter results. Only applies to the US.
         * </p>
         * 
         * @param areaCode
         *        The area code used to filter results. Only applies to the US.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areaCode(String areaCode);

        /**
         * <p>
         * The city used to filter results. Only applies to the US.
         * </p>
         * 
         * @param city
         *        The city used to filter results. Only applies to the US.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.
         * </p>
         * 
         * @param country
         *        The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.
         * </p>
         * 
         * @param state
         *        The state used to filter results. Required only if you provide <code>City</code>. Only applies to the
         *        US.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The toll-free prefix that you use to filter results. Only applies to the US.
         * </p>
         * 
         * @param tollFreePrefix
         *        The toll-free prefix that you use to filter results. Only applies to the US.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollFreePrefix(String tollFreePrefix);

        /**
         * <p>
         * The phone number type used to filter results. Required for non-US numbers.
         * </p>
         * 
         * @param phoneNumberType
         *        The phone number type used to filter results. Required for non-US numbers.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(String phoneNumberType);

        /**
         * <p>
         * The phone number type used to filter results. Required for non-US numbers.
         * </p>
         * 
         * @param phoneNumberType
         *        The phone number type used to filter results. Required for non-US numbers.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(PhoneNumberType phoneNumberType);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String areaCode;

        private String city;

        private String country;

        private String state;

        private String tollFreePrefix;

        private String phoneNumberType;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersRequest model) {
            super(model);
            areaCode(model.areaCode);
            city(model.city);
            country(model.country);
            state(model.state);
            tollFreePrefix(model.tollFreePrefix);
            phoneNumberType(model.phoneNumberType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAreaCode() {
            return areaCode;
        }

        public final void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        @Override
        @Transient
        public final Builder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        @Transient
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        @Transient
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getTollFreePrefix() {
            return tollFreePrefix;
        }

        public final void setTollFreePrefix(String tollFreePrefix) {
            this.tollFreePrefix = tollFreePrefix;
        }

        @Override
        @Transient
        public final Builder tollFreePrefix(String tollFreePrefix) {
            this.tollFreePrefix = tollFreePrefix;
            return this;
        }

        public final String getPhoneNumberType() {
            return phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        @Transient
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        @Transient
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAvailablePhoneNumbersRequest build() {
            return new SearchAvailablePhoneNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
