/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SipRuleListCopier {
    static List<SipRule> copy(Collection<? extends SipRule> sipRuleListParam) {
        List<SipRule> list;
        if (sipRuleListParam == null || sipRuleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SipRule> modifiableList = new ArrayList<>();
            sipRuleListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SipRule> copyFromBuilder(Collection<? extends SipRule.Builder> sipRuleListParam) {
        List<SipRule> list;
        if (sipRuleListParam == null || sipRuleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SipRule> modifiableList = new ArrayList<>();
            sipRuleListParam.forEach(entry -> {
                SipRule member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SipRule.Builder> copyToBuilder(Collection<? extends SipRule> sipRuleListParam) {
        List<SipRule.Builder> list;
        if (sipRuleListParam == null || sipRuleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SipRule.Builder> modifiableList = new ArrayList<>();
            sipRuleListParam.forEach(entry -> {
                SipRule.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
