/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user on the Amazon Chime account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(User::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(User::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> PRIMARY_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryEmail").getter(getter(User::primaryEmail)).setter(setter(Builder::primaryEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmail").build()).build();

    private static final SdkField<String> PRIMARY_PROVISIONED_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryProvisionedNumber").getter(getter(User::primaryProvisionedNumber))
            .setter(setter(Builder::primaryProvisionedNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryProvisionedNumber").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(User::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseType").getter(getter(User::licenseTypeAsString)).setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()).build();

    private static final SdkField<String> USER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserType").getter(getter(User::userTypeAsString)).setter(setter(Builder::userType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()).build();

    private static final SdkField<String> USER_REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRegistrationStatus").getter(getter(User::userRegistrationStatusAsString))
            .setter(setter(Builder::userRegistrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRegistrationStatus").build())
            .build();

    private static final SdkField<String> USER_INVITATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserInvitationStatus").getter(getter(User::userInvitationStatusAsString))
            .setter(setter(Builder::userInvitationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInvitationStatus").build())
            .build();

    private static final SdkField<Instant> REGISTERED_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RegisteredOn")
            .getter(getter(User::registeredOn))
            .setter(setter(Builder::registeredOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredOn").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> INVITED_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvitedOn")
            .getter(getter(User::invitedOn))
            .setter(setter(Builder::invitedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedOn").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<AlexaForBusinessMetadata> ALEXA_FOR_BUSINESS_METADATA_FIELD = SdkField
            .<AlexaForBusinessMetadata> builder(MarshallingType.SDK_POJO).memberName("AlexaForBusinessMetadata")
            .getter(getter(User::alexaForBusinessMetadata)).setter(setter(Builder::alexaForBusinessMetadata))
            .constructor(AlexaForBusinessMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaForBusinessMetadata").build())
            .build();

    private static final SdkField<String> PERSONAL_PIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersonalPIN").getter(getter(User::personalPIN)).setter(setter(Builder::personalPIN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalPIN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            ACCOUNT_ID_FIELD, PRIMARY_EMAIL_FIELD, PRIMARY_PROVISIONED_NUMBER_FIELD, DISPLAY_NAME_FIELD, LICENSE_TYPE_FIELD,
            USER_TYPE_FIELD, USER_REGISTRATION_STATUS_FIELD, USER_INVITATION_STATUS_FIELD, REGISTERED_ON_FIELD, INVITED_ON_FIELD,
            ALEXA_FOR_BUSINESS_METADATA_FIELD, PERSONAL_PIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String accountId;

    private final String primaryEmail;

    private final String primaryProvisionedNumber;

    private final String displayName;

    private final String licenseType;

    private final String userType;

    private final String userRegistrationStatus;

    private final String userInvitationStatus;

    private final Instant registeredOn;

    private final Instant invitedOn;

    private final AlexaForBusinessMetadata alexaForBusinessMetadata;

    private final String personalPIN;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.accountId = builder.accountId;
        this.primaryEmail = builder.primaryEmail;
        this.primaryProvisionedNumber = builder.primaryProvisionedNumber;
        this.displayName = builder.displayName;
        this.licenseType = builder.licenseType;
        this.userType = builder.userType;
        this.userRegistrationStatus = builder.userRegistrationStatus;
        this.userInvitationStatus = builder.userInvitationStatus;
        this.registeredOn = builder.registeredOn;
        this.invitedOn = builder.invitedOn;
        this.alexaForBusinessMetadata = builder.alexaForBusinessMetadata;
        this.personalPIN = builder.personalPIN;
    }

    /**
     * <p>
     * The user ID.
     * </p>
     * 
     * @return The user ID.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The primary email address of the user.
     * </p>
     * 
     * @return The primary email address of the user.
     */
    public final String primaryEmail() {
        return primaryEmail;
    }

    /**
     * <p>
     * The primary phone number associated with the user.
     * </p>
     * 
     * @return The primary phone number associated with the user.
     */
    public final String primaryProvisionedNumber() {
        return primaryProvisionedNumber;
    }

    /**
     * <p>
     * The display name of the user.
     * </p>
     * 
     * @return The display name of the user.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The license type for the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link License#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type for the user.
     * @see License
     */
    public final License licenseType() {
        return License.fromValue(licenseType);
    }

    /**
     * <p>
     * The license type for the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link License#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type for the user.
     * @see License
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * The user type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return The user type.
     * @see UserType
     */
    public final UserType userType() {
        return UserType.fromValue(userType);
    }

    /**
     * <p>
     * The user type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return The user type.
     * @see UserType
     */
    public final String userTypeAsString() {
        return userType;
    }

    /**
     * <p>
     * The user registration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userRegistrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userRegistrationStatusAsString}.
     * </p>
     * 
     * @return The user registration status.
     * @see RegistrationStatus
     */
    public final RegistrationStatus userRegistrationStatus() {
        return RegistrationStatus.fromValue(userRegistrationStatus);
    }

    /**
     * <p>
     * The user registration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userRegistrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userRegistrationStatusAsString}.
     * </p>
     * 
     * @return The user registration status.
     * @see RegistrationStatus
     */
    public final String userRegistrationStatusAsString() {
        return userRegistrationStatus;
    }

    /**
     * <p>
     * The user invite status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userInvitationStatus} will return {@link InviteStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #userInvitationStatusAsString}.
     * </p>
     * 
     * @return The user invite status.
     * @see InviteStatus
     */
    public final InviteStatus userInvitationStatus() {
        return InviteStatus.fromValue(userInvitationStatus);
    }

    /**
     * <p>
     * The user invite status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userInvitationStatus} will return {@link InviteStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #userInvitationStatusAsString}.
     * </p>
     * 
     * @return The user invite status.
     * @see InviteStatus
     */
    public final String userInvitationStatusAsString() {
        return userInvitationStatus;
    }

    /**
     * <p>
     * Date and time when the user is registered, in ISO 8601 format.
     * </p>
     * 
     * @return Date and time when the user is registered, in ISO 8601 format.
     */
    public final Instant registeredOn() {
        return registeredOn;
    }

    /**
     * <p>
     * Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.
     * </p>
     * 
     * @return Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.
     */
    public final Instant invitedOn() {
        return invitedOn;
    }

    /**
     * <p>
     * The Alexa for Business metadata.
     * </p>
     * 
     * @return The Alexa for Business metadata.
     */
    public final AlexaForBusinessMetadata alexaForBusinessMetadata() {
        return alexaForBusinessMetadata;
    }

    /**
     * <p>
     * The user's personal meeting PIN.
     * </p>
     * 
     * @return The user's personal meeting PIN.
     */
    public final String personalPIN() {
        return personalPIN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(primaryEmail());
        hashCode = 31 * hashCode + Objects.hashCode(primaryProvisionedNumber());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userInvitationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(registeredOn());
        hashCode = 31 * hashCode + Objects.hashCode(invitedOn());
        hashCode = 31 * hashCode + Objects.hashCode(alexaForBusinessMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(personalPIN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(primaryEmail(), other.primaryEmail())
                && Objects.equals(primaryProvisionedNumber(), other.primaryProvisionedNumber())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && Objects.equals(userTypeAsString(), other.userTypeAsString())
                && Objects.equals(userRegistrationStatusAsString(), other.userRegistrationStatusAsString())
                && Objects.equals(userInvitationStatusAsString(), other.userInvitationStatusAsString())
                && Objects.equals(registeredOn(), other.registeredOn()) && Objects.equals(invitedOn(), other.invitedOn())
                && Objects.equals(alexaForBusinessMetadata(), other.alexaForBusinessMetadata())
                && Objects.equals(personalPIN(), other.personalPIN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("UserId", userId()).add("AccountId", accountId())
                .add("PrimaryEmail", primaryEmail() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PrimaryProvisionedNumber", primaryProvisionedNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LicenseType", licenseTypeAsString()).add("UserType", userTypeAsString())
                .add("UserRegistrationStatus", userRegistrationStatusAsString())
                .add("UserInvitationStatus", userInvitationStatusAsString()).add("RegisteredOn", registeredOn())
                .add("InvitedOn", invitedOn()).add("AlexaForBusinessMetadata", alexaForBusinessMetadata())
                .add("PersonalPIN", personalPIN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "PrimaryEmail":
            return Optional.ofNullable(clazz.cast(primaryEmail()));
        case "PrimaryProvisionedNumber":
            return Optional.ofNullable(clazz.cast(primaryProvisionedNumber()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "LicenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "UserType":
            return Optional.ofNullable(clazz.cast(userTypeAsString()));
        case "UserRegistrationStatus":
            return Optional.ofNullable(clazz.cast(userRegistrationStatusAsString()));
        case "UserInvitationStatus":
            return Optional.ofNullable(clazz.cast(userInvitationStatusAsString()));
        case "RegisteredOn":
            return Optional.ofNullable(clazz.cast(registeredOn()));
        case "InvitedOn":
            return Optional.ofNullable(clazz.cast(invitedOn()));
        case "AlexaForBusinessMetadata":
            return Optional.ofNullable(clazz.cast(alexaForBusinessMetadata()));
        case "PersonalPIN":
            return Optional.ofNullable(clazz.cast(personalPIN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The user ID.
         * </p>
         * 
         * @param userId
         *        The user ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The primary email address of the user.
         * </p>
         * 
         * @param primaryEmail
         *        The primary email address of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryEmail(String primaryEmail);

        /**
         * <p>
         * The primary phone number associated with the user.
         * </p>
         * 
         * @param primaryProvisionedNumber
         *        The primary phone number associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryProvisionedNumber(String primaryProvisionedNumber);

        /**
         * <p>
         * The display name of the user.
         * </p>
         * 
         * @param displayName
         *        The display name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The license type for the user.
         * </p>
         * 
         * @param licenseType
         *        The license type for the user.
         * @see License
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see License
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The license type for the user.
         * </p>
         * 
         * @param licenseType
         *        The license type for the user.
         * @see License
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see License
         */
        Builder licenseType(License licenseType);

        /**
         * <p>
         * The user type.
         * </p>
         * 
         * @param userType
         *        The user type.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder userType(String userType);

        /**
         * <p>
         * The user type.
         * </p>
         * 
         * @param userType
         *        The user type.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder userType(UserType userType);

        /**
         * <p>
         * The user registration status.
         * </p>
         * 
         * @param userRegistrationStatus
         *        The user registration status.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder userRegistrationStatus(String userRegistrationStatus);

        /**
         * <p>
         * The user registration status.
         * </p>
         * 
         * @param userRegistrationStatus
         *        The user registration status.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder userRegistrationStatus(RegistrationStatus userRegistrationStatus);

        /**
         * <p>
         * The user invite status.
         * </p>
         * 
         * @param userInvitationStatus
         *        The user invite status.
         * @see InviteStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InviteStatus
         */
        Builder userInvitationStatus(String userInvitationStatus);

        /**
         * <p>
         * The user invite status.
         * </p>
         * 
         * @param userInvitationStatus
         *        The user invite status.
         * @see InviteStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InviteStatus
         */
        Builder userInvitationStatus(InviteStatus userInvitationStatus);

        /**
         * <p>
         * Date and time when the user is registered, in ISO 8601 format.
         * </p>
         * 
         * @param registeredOn
         *        Date and time when the user is registered, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredOn(Instant registeredOn);

        /**
         * <p>
         * Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.
         * </p>
         * 
         * @param invitedOn
         *        Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedOn(Instant invitedOn);

        /**
         * <p>
         * The Alexa for Business metadata.
         * </p>
         * 
         * @param alexaForBusinessMetadata
         *        The Alexa for Business metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alexaForBusinessMetadata(AlexaForBusinessMetadata alexaForBusinessMetadata);

        /**
         * <p>
         * The Alexa for Business metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link AlexaForBusinessMetadata.Builder} avoiding the
         * need to create one manually via {@link AlexaForBusinessMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlexaForBusinessMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #alexaForBusinessMetadata(AlexaForBusinessMetadata)}.
         * 
         * @param alexaForBusinessMetadata
         *        a consumer that will call methods on {@link AlexaForBusinessMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alexaForBusinessMetadata(AlexaForBusinessMetadata)
         */
        default Builder alexaForBusinessMetadata(Consumer<AlexaForBusinessMetadata.Builder> alexaForBusinessMetadata) {
            return alexaForBusinessMetadata(AlexaForBusinessMetadata.builder().applyMutation(alexaForBusinessMetadata).build());
        }

        /**
         * <p>
         * The user's personal meeting PIN.
         * </p>
         * 
         * @param personalPIN
         *        The user's personal meeting PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalPIN(String personalPIN);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String accountId;

        private String primaryEmail;

        private String primaryProvisionedNumber;

        private String displayName;

        private String licenseType;

        private String userType;

        private String userRegistrationStatus;

        private String userInvitationStatus;

        private Instant registeredOn;

        private Instant invitedOn;

        private AlexaForBusinessMetadata alexaForBusinessMetadata;

        private String personalPIN;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            userId(model.userId);
            accountId(model.accountId);
            primaryEmail(model.primaryEmail);
            primaryProvisionedNumber(model.primaryProvisionedNumber);
            displayName(model.displayName);
            licenseType(model.licenseType);
            userType(model.userType);
            userRegistrationStatus(model.userRegistrationStatus);
            userInvitationStatus(model.userInvitationStatus);
            registeredOn(model.registeredOn);
            invitedOn(model.invitedOn);
            alexaForBusinessMetadata(model.alexaForBusinessMetadata);
            personalPIN(model.personalPIN);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPrimaryEmail() {
            return primaryEmail;
        }

        public final void setPrimaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
        }

        @Override
        @Transient
        public final Builder primaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
            return this;
        }

        public final String getPrimaryProvisionedNumber() {
            return primaryProvisionedNumber;
        }

        public final void setPrimaryProvisionedNumber(String primaryProvisionedNumber) {
            this.primaryProvisionedNumber = primaryProvisionedNumber;
        }

        @Override
        @Transient
        public final Builder primaryProvisionedNumber(String primaryProvisionedNumber) {
            this.primaryProvisionedNumber = primaryProvisionedNumber;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        @Transient
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        @Transient
        public final Builder licenseType(License licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getUserType() {
            return userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        @Transient
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        @Transient
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final String getUserRegistrationStatus() {
            return userRegistrationStatus;
        }

        public final void setUserRegistrationStatus(String userRegistrationStatus) {
            this.userRegistrationStatus = userRegistrationStatus;
        }

        @Override
        @Transient
        public final Builder userRegistrationStatus(String userRegistrationStatus) {
            this.userRegistrationStatus = userRegistrationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder userRegistrationStatus(RegistrationStatus userRegistrationStatus) {
            this.userRegistrationStatus(userRegistrationStatus == null ? null : userRegistrationStatus.toString());
            return this;
        }

        public final String getUserInvitationStatus() {
            return userInvitationStatus;
        }

        public final void setUserInvitationStatus(String userInvitationStatus) {
            this.userInvitationStatus = userInvitationStatus;
        }

        @Override
        @Transient
        public final Builder userInvitationStatus(String userInvitationStatus) {
            this.userInvitationStatus = userInvitationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder userInvitationStatus(InviteStatus userInvitationStatus) {
            this.userInvitationStatus(userInvitationStatus == null ? null : userInvitationStatus.toString());
            return this;
        }

        public final Instant getRegisteredOn() {
            return registeredOn;
        }

        public final void setRegisteredOn(Instant registeredOn) {
            this.registeredOn = registeredOn;
        }

        @Override
        @Transient
        public final Builder registeredOn(Instant registeredOn) {
            this.registeredOn = registeredOn;
            return this;
        }

        public final Instant getInvitedOn() {
            return invitedOn;
        }

        public final void setInvitedOn(Instant invitedOn) {
            this.invitedOn = invitedOn;
        }

        @Override
        @Transient
        public final Builder invitedOn(Instant invitedOn) {
            this.invitedOn = invitedOn;
            return this;
        }

        public final AlexaForBusinessMetadata.Builder getAlexaForBusinessMetadata() {
            return alexaForBusinessMetadata != null ? alexaForBusinessMetadata.toBuilder() : null;
        }

        public final void setAlexaForBusinessMetadata(AlexaForBusinessMetadata.BuilderImpl alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata != null ? alexaForBusinessMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder alexaForBusinessMetadata(AlexaForBusinessMetadata alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata;
            return this;
        }

        public final String getPersonalPIN() {
            return personalPIN;
        }

        public final void setPersonalPIN(String personalPIN) {
            this.personalPIN = personalPIN;
        }

        @Override
        @Transient
        public final Builder personalPIN(String personalPIN) {
            this.personalPIN = personalPIN;
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
