/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.PhoneNumberProductType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePhoneNumberRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, UpdatePhoneNumberRequest> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberId").getter(UpdatePhoneNumberRequest.getter(UpdatePhoneNumberRequest::phoneNumberId)).setter(UpdatePhoneNumberRequest.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("phoneNumberId").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductType").getter(UpdatePhoneNumberRequest.getter(UpdatePhoneNumberRequest::productTypeAsString)).setter(UpdatePhoneNumberRequest.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()}).build();
    private static final SdkField<String> CALLING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallingName").getter(UpdatePhoneNumberRequest.getter(UpdatePhoneNumberRequest::callingName)).setter(UpdatePhoneNumberRequest.setter(Builder::callingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD, PRODUCT_TYPE_FIELD, CALLING_NAME_FIELD));
    private final String phoneNumberId;
    private final String productType;
    private final String callingName;

    private UpdatePhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberId = builder.phoneNumberId;
        this.productType = builder.productType;
        this.callingName = builder.callingName;
    }

    public final String phoneNumberId() {
        return this.phoneNumberId;
    }

    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public final String callingName() {
        return this.callingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.callingName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberRequest)) {
            return false;
        }
        UpdatePhoneNumberRequest other = (UpdatePhoneNumberRequest)((Object)obj);
        return Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && Objects.equals(this.callingName(), other.callingName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePhoneNumberRequest").add("PhoneNumberId", (Object)this.phoneNumberId()).add("ProductType", (Object)this.productTypeAsString()).add("CallingName", (Object)(this.callingName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "CallingName": {
                return Optional.ofNullable(clazz.cast(this.callingName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberRequest, T> g) {
        return obj -> g.apply((UpdatePhoneNumberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String phoneNumberId;
        private String productType;
        private String callingName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberRequest model) {
            super(model);
            this.phoneNumberId(model.phoneNumberId);
            this.productType(model.productType);
            this.callingName(model.callingName);
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getCallingName() {
            return this.callingName;
        }

        public final void setCallingName(String callingName) {
            this.callingName = callingName;
        }

        @Override
        public final Builder callingName(String callingName) {
            this.callingName = callingName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePhoneNumberRequest build() {
            return new UpdatePhoneNumberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePhoneNumberRequest> {
        public Builder phoneNumberId(String var1);

        public Builder productType(String var1);

        public Builder productType(PhoneNumberProductType var1);

        public Builder callingName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

