/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePhoneNumberOrderRequest extends ChimeRequest implements
        ToCopyableBuilder<CreatePhoneNumberOrderRequest.Builder, CreatePhoneNumberOrderRequest> {
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(CreatePhoneNumberOrderRequest::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()).build();

    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("E164PhoneNumbers")
            .getter(getter(CreatePhoneNumberOrderRequest::e164PhoneNumbers))
            .setter(setter(Builder::e164PhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_TYPE_FIELD,
            E164_PHONE_NUMBERS_FIELD));

    private final String productType;

    private final List<String> e164PhoneNumbers;

    private CreatePhoneNumberOrderRequest(BuilderImpl builder) {
        super(builder);
        this.productType = builder.productType;
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
    }

    /**
     * <p>
     * The phone number product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number product type.
     * @see PhoneNumberProductType
     */
    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(productType);
    }

    /**
     * <p>
     * The phone number product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number product type.
     * @see PhoneNumberProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * For responses, this returns true if the service returned a value for the E164PhoneNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasE164PhoneNumbers() {
        return e164PhoneNumbers != null && !(e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of phone numbers, in E.164 format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasE164PhoneNumbers} method.
     * </p>
     * 
     * @return List of phone numbers, in E.164 format.
     */
    public final List<String> e164PhoneNumbers() {
        return e164PhoneNumbers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasE164PhoneNumbers() ? e164PhoneNumbers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePhoneNumberOrderRequest)) {
            return false;
        }
        CreatePhoneNumberOrderRequest other = (CreatePhoneNumberOrderRequest) obj;
        return Objects.equals(productTypeAsString(), other.productTypeAsString())
                && hasE164PhoneNumbers() == other.hasE164PhoneNumbers()
                && Objects.equals(e164PhoneNumbers(), other.e164PhoneNumbers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePhoneNumberOrderRequest").add("ProductType", productTypeAsString())
                .add("E164PhoneNumbers", e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "E164PhoneNumbers":
            return Optional.ofNullable(clazz.cast(e164PhoneNumbers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePhoneNumberOrderRequest, T> g) {
        return obj -> g.apply((CreatePhoneNumberOrderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePhoneNumberOrderRequest> {
        /**
         * <p>
         * The phone number product type.
         * </p>
         * 
         * @param productType
         *        The phone number product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The phone number product type.
         * </p>
         * 
         * @param productType
         *        The phone number product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(PhoneNumberProductType productType);

        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers);

        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(String... e164PhoneNumbers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String productType;

        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePhoneNumberOrderRequest model) {
            super(model);
            productType(model.productType);
            e164PhoneNumbers(model.e164PhoneNumbers);
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final Collection<String> getE164PhoneNumbers() {
            if (e164PhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return e164PhoneNumbers;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String... e164PhoneNumbers) {
            e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePhoneNumberOrderRequest build() {
            return new CreatePhoneNumberOrderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
