/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.UserError;
import software.amazon.awssdk.services.chime.model.UserErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateUserResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, BatchUpdateUserResponse> {
    private static final SdkField<List<UserError>> USER_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserErrors").getter(BatchUpdateUserResponse.getter(BatchUpdateUserResponse::userErrors)).setter(BatchUpdateUserResponse.setter(Builder::userErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserErrors", USER_ERRORS_FIELD);
        }
    });
    private final List<UserError> userErrors;

    private BatchUpdateUserResponse(BuilderImpl builder) {
        super(builder);
        this.userErrors = builder.userErrors;
    }

    public final boolean hasUserErrors() {
        return this.userErrors != null && !(this.userErrors instanceof SdkAutoConstructList);
    }

    public final List<UserError> userErrors() {
        return this.userErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserErrors() ? this.userErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateUserResponse)) {
            return false;
        }
        BatchUpdateUserResponse other = (BatchUpdateUserResponse)((Object)obj);
        return this.hasUserErrors() == other.hasUserErrors() && Objects.equals(this.userErrors(), other.userErrors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateUserResponse").add("UserErrors", this.hasUserErrors() ? this.userErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserErrors": {
                return Optional.ofNullable(clazz.cast(this.userErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateUserResponse, T> g) {
        return obj -> g.apply((BatchUpdateUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<UserError> userErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateUserResponse model) {
            super(model);
            this.userErrors(model.userErrors);
        }

        public final List<UserError.Builder> getUserErrors() {
            List<UserError.Builder> result = UserErrorListCopier.copyToBuilder(this.userErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserErrors(Collection<UserError.BuilderImpl> userErrors) {
            this.userErrors = UserErrorListCopier.copyFromBuilder(userErrors);
        }

        @Override
        public final Builder userErrors(Collection<UserError> userErrors) {
            this.userErrors = UserErrorListCopier.copy(userErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userErrors(UserError ... userErrors) {
            this.userErrors(Arrays.asList(userErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userErrors(Consumer<UserError.Builder> ... userErrors) {
            this.userErrors(Stream.of(userErrors).map(c -> (UserError)((UserError.Builder)UserError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateUserResponse build() {
            return new BatchUpdateUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateUserResponse> {
        public Builder userErrors(Collection<UserError> var1);

        public Builder userErrors(UserError ... var1);

        public Builder userErrors(Consumer<UserError.Builder> ... var1);
    }
}

