/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName;
import software.amazon.awssdk.services.chime.model.PhoneNumberProductType;
import software.amazon.awssdk.services.chime.model.PhoneNumberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumbersRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, ListPhoneNumbersRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::statusAsString)).setter(ListPhoneNumbersRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductType").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::productTypeAsString)).setter(ListPhoneNumbersRequest.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("product-type").build()}).build();
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterName").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::filterNameAsString)).setter(ListPhoneNumbersRequest.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filter-name").build()}).build();
    private static final SdkField<String> FILTER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterValue").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::filterValue)).setter(ListPhoneNumbersRequest.setter(Builder::filterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filter-value").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::maxResults)).setter(ListPhoneNumbersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::nextToken)).setter(ListPhoneNumbersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, PRODUCT_TYPE_FIELD, FILTER_NAME_FIELD, FILTER_VALUE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("product-type", PRODUCT_TYPE_FIELD);
            this.put("filter-name", FILTER_NAME_FIELD);
            this.put("filter-value", FILTER_VALUE_FIELD);
            this.put("max-results", MAX_RESULTS_FIELD);
            this.put("next-token", NEXT_TOKEN_FIELD);
        }
    });
    private final String status;
    private final String productType;
    private final String filterName;
    private final String filterValue;
    private final Integer maxResults;
    private final String nextToken;

    private ListPhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.productType = builder.productType;
        this.filterName = builder.filterName;
        this.filterValue = builder.filterValue;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final PhoneNumberStatus status() {
        return PhoneNumberStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public final PhoneNumberAssociationName filterName() {
        return PhoneNumberAssociationName.fromValue(this.filterName);
    }

    public final String filterNameAsString() {
        return this.filterName;
    }

    public final String filterValue() {
        return this.filterValue;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersRequest)) {
            return false;
        }
        ListPhoneNumbersRequest other = (ListPhoneNumbersRequest)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && Objects.equals(this.filterNameAsString(), other.filterNameAsString()) && Objects.equals(this.filterValue(), other.filterValue()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPhoneNumbersRequest").add("Status", (Object)this.statusAsString()).add("ProductType", (Object)this.productTypeAsString()).add("FilterName", (Object)this.filterNameAsString()).add("FilterValue", (Object)this.filterValue()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "FilterName": {
                return Optional.ofNullable(clazz.cast(this.filterNameAsString()));
            }
            case "FilterValue": {
                return Optional.ofNullable(clazz.cast(this.filterValue()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersRequest, T> g) {
        return obj -> g.apply((ListPhoneNumbersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String status;
        private String productType;
        private String filterName;
        private String filterValue;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersRequest model) {
            super(model);
            this.status(model.status);
            this.productType(model.productType);
            this.filterName(model.filterName);
            this.filterValue(model.filterValue);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhoneNumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getFilterName() {
            return this.filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        @Override
        public final Builder filterName(PhoneNumberAssociationName filterName) {
            this.filterName(filterName == null ? null : filterName.toString());
            return this;
        }

        public final String getFilterValue() {
            return this.filterValue;
        }

        public final void setFilterValue(String filterValue) {
            this.filterValue = filterValue;
        }

        @Override
        public final Builder filterValue(String filterValue) {
            this.filterValue = filterValue;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPhoneNumbersRequest build() {
            return new ListPhoneNumbersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumbersRequest> {
        public Builder status(String var1);

        public Builder status(PhoneNumberStatus var1);

        public Builder productType(String var1);

        public Builder productType(PhoneNumberProductType var1);

        public Builder filterName(String var1);

        public Builder filterName(PhoneNumberAssociationName var1);

        public Builder filterValue(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

