/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource that allows Enterprise account administrators to configure an interface to receive events from Amazon
 * Chime.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Bot implements SdkPojo, Serializable, ToCopyableBuilder<Bot.Builder, Bot> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("BotId")
            .getter(getter(Bot::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(Bot::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Bot::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> BOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BotType").getter(getter(Bot::botTypeAsString)).setter(setter(Builder::botType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotType").build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(Bot::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(Bot::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(Bot::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> BOT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BotEmail").getter(getter(Bot::botEmail)).setter(setter(Builder::botEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotEmail").build()).build();

    private static final SdkField<String> SECURITY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityToken").getter(getter(Bot::securityToken)).setter(setter(Builder::securityToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, USER_ID_FIELD,
            DISPLAY_NAME_FIELD, BOT_TYPE_FIELD, DISABLED_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD,
            BOT_EMAIL_FIELD, SECURITY_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botId;

    private final String userId;

    private final String displayName;

    private final String botType;

    private final Boolean disabled;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final String botEmail;

    private final String securityToken;

    private Bot(BuilderImpl builder) {
        this.botId = builder.botId;
        this.userId = builder.userId;
        this.displayName = builder.displayName;
        this.botType = builder.botType;
        this.disabled = builder.disabled;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.botEmail = builder.botEmail;
        this.securityToken = builder.securityToken;
    }

    /**
     * <p>
     * The bot ID.
     * </p>
     * 
     * @return The bot ID.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The unique ID for the bot user.
     * </p>
     * 
     * @return The unique ID for the bot user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The bot display name.
     * </p>
     * 
     * @return The bot display name.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The bot type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The bot type.
     * @see BotType
     */
    public final BotType botType() {
        return BotType.fromValue(botType);
    }

    /**
     * <p>
     * The bot type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The bot type.
     * @see BotType
     */
    public final String botTypeAsString() {
        return botType;
    }

    /**
     * <p>
     * When true, the bot is stopped from running in your account.
     * </p>
     * 
     * @return When true, the bot is stopped from running in your account.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * <p>
     * The bot creation timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The bot creation timestamp, in ISO 8601 format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The updated bot timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The updated bot timestamp, in ISO 8601 format.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * The bot email address.
     * </p>
     * 
     * @return The bot email address.
     */
    public final String botEmail() {
        return botEmail;
    }

    /**
     * <p>
     * The security token used to authenticate Amazon Chime with the outgoing event endpoint.
     * </p>
     * 
     * @return The security token used to authenticate Amazon Chime with the outgoing event endpoint.
     */
    public final String securityToken() {
        return securityToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(botTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(botEmail());
        hashCode = 31 * hashCode + Objects.hashCode(securityToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bot)) {
            return false;
        }
        Bot other = (Bot) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(botTypeAsString(), other.botTypeAsString()) && Objects.equals(disabled(), other.disabled())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(botEmail(), other.botEmail())
                && Objects.equals(securityToken(), other.securityToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Bot").add("BotId", botId()).add("UserId", userId())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BotType", botTypeAsString()).add("Disabled", disabled()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp())
                .add("BotEmail", botEmail() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecurityToken", securityToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BotId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "BotType":
            return Optional.ofNullable(clazz.cast(botTypeAsString()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "BotEmail":
            return Optional.ofNullable(clazz.cast(botEmail()));
        case "SecurityToken":
            return Optional.ofNullable(clazz.cast(securityToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BotId", BOT_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("BotType", BOT_TYPE_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("BotEmail", BOT_EMAIL_FIELD);
        map.put("SecurityToken", SECURITY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Bot, T> g) {
        return obj -> g.apply((Bot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Bot> {
        /**
         * <p>
         * The bot ID.
         * </p>
         * 
         * @param botId
         *        The bot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The unique ID for the bot user.
         * </p>
         * 
         * @param userId
         *        The unique ID for the bot user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The bot display name.
         * </p>
         * 
         * @param displayName
         *        The bot display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The bot type.
         * </p>
         * 
         * @param botType
         *        The bot type.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(String botType);

        /**
         * <p>
         * The bot type.
         * </p>
         * 
         * @param botType
         *        The bot type.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(BotType botType);

        /**
         * <p>
         * When true, the bot is stopped from running in your account.
         * </p>
         * 
         * @param disabled
         *        When true, the bot is stopped from running in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * The bot creation timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The bot creation timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The updated bot timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The updated bot timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * The bot email address.
         * </p>
         * 
         * @param botEmail
         *        The bot email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botEmail(String botEmail);

        /**
         * <p>
         * The security token used to authenticate Amazon Chime with the outgoing event endpoint.
         * </p>
         * 
         * @param securityToken
         *        The security token used to authenticate Amazon Chime with the outgoing event endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityToken(String securityToken);
    }

    static final class BuilderImpl implements Builder {
        private String botId;

        private String userId;

        private String displayName;

        private String botType;

        private Boolean disabled;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private String botEmail;

        private String securityToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Bot model) {
            botId(model.botId);
            userId(model.userId);
            displayName(model.displayName);
            botType(model.botType);
            disabled(model.disabled);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            botEmail(model.botEmail);
            securityToken(model.securityToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getBotType() {
            return botType;
        }

        public final void setBotType(String botType) {
            this.botType = botType;
        }

        @Override
        public final Builder botType(String botType) {
            this.botType = botType;
            return this;
        }

        @Override
        public final Builder botType(BotType botType) {
            this.botType(botType == null ? null : botType.toString());
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getBotEmail() {
            return botEmail;
        }

        public final void setBotEmail(String botEmail) {
            this.botEmail = botEmail;
        }

        @Override
        public final Builder botEmail(String botEmail) {
            this.botEmail = botEmail;
            return this;
        }

        public final String getSecurityToken() {
            return securityToken;
        }

        public final void setSecurityToken(String securityToken) {
            this.securityToken = securityToken;
        }

        @Override
        public final Builder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        @Override
        public Bot build() {
            return new Bot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
