/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A suggested address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CandidateAddress implements SdkPojo, Serializable,
        ToCopyableBuilder<CandidateAddress.Builder, CandidateAddress> {
    private static final SdkField<String> STREET_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streetInfo").getter(getter(CandidateAddress::streetInfo)).setter(setter(Builder::streetInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetInfo").build()).build();

    private static final SdkField<String> STREET_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streetNumber").getter(getter(CandidateAddress::streetNumber)).setter(setter(Builder::streetNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetNumber").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("city")
            .getter(getter(CandidateAddress::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(CandidateAddress::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postalCode").getter(getter(CandidateAddress::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()).build();

    private static final SdkField<String> POSTAL_CODE_PLUS4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postalCodePlus4").getter(getter(CandidateAddress::postalCodePlus4))
            .setter(setter(Builder::postalCodePlus4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCodePlus4").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("country")
            .getter(getter(CandidateAddress::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREET_INFO_FIELD,
            STREET_NUMBER_FIELD, CITY_FIELD, STATE_FIELD, POSTAL_CODE_FIELD, POSTAL_CODE_PLUS4_FIELD, COUNTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streetInfo;

    private final String streetNumber;

    private final String city;

    private final String state;

    private final String postalCode;

    private final String postalCodePlus4;

    private final String country;

    private CandidateAddress(BuilderImpl builder) {
        this.streetInfo = builder.streetInfo;
        this.streetNumber = builder.streetNumber;
        this.city = builder.city;
        this.state = builder.state;
        this.postalCode = builder.postalCode;
        this.postalCodePlus4 = builder.postalCodePlus4;
        this.country = builder.country;
    }

    /**
     * <p>
     * The street information of a candidate address
     * </p>
     * 
     * @return The street information of a candidate address
     */
    public final String streetInfo() {
        return streetInfo;
    }

    /**
     * <p>
     * The numeric portion of a candidate address.
     * </p>
     * 
     * @return The numeric portion of a candidate address.
     */
    public final String streetNumber() {
        return streetNumber;
    }

    /**
     * <p>
     * The city of a candidate address.
     * </p>
     * 
     * @return The city of a candidate address.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The state of a candidate address.
     * </p>
     * 
     * @return The state of a candidate address.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The postal code of a candidate address.
     * </p>
     * 
     * @return The postal code of a candidate address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The Zip + 4 or postal code + 4 of a candidate address.
     * </p>
     * 
     * @return The Zip + 4 or postal code + 4 of a candidate address.
     */
    public final String postalCodePlus4() {
        return postalCodePlus4;
    }

    /**
     * <p>
     * The country of a candidate address.
     * </p>
     * 
     * @return The country of a candidate address.
     */
    public final String country() {
        return country;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streetInfo());
        hashCode = 31 * hashCode + Objects.hashCode(streetNumber());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(postalCodePlus4());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateAddress)) {
            return false;
        }
        CandidateAddress other = (CandidateAddress) obj;
        return Objects.equals(streetInfo(), other.streetInfo()) && Objects.equals(streetNumber(), other.streetNumber())
                && Objects.equals(city(), other.city()) && Objects.equals(state(), other.state())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(postalCodePlus4(), other.postalCodePlus4())
                && Objects.equals(country(), other.country());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CandidateAddress")
                .add("StreetInfo", streetInfo() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StreetNumber", streetNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("State", state() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCodePlus4", postalCodePlus4() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streetInfo":
            return Optional.ofNullable(clazz.cast(streetInfo()));
        case "streetNumber":
            return Optional.ofNullable(clazz.cast(streetNumber()));
        case "city":
            return Optional.ofNullable(clazz.cast(city()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "postalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "postalCodePlus4":
            return Optional.ofNullable(clazz.cast(postalCodePlus4()));
        case "country":
            return Optional.ofNullable(clazz.cast(country()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streetInfo", STREET_INFO_FIELD);
        map.put("streetNumber", STREET_NUMBER_FIELD);
        map.put("city", CITY_FIELD);
        map.put("state", STATE_FIELD);
        map.put("postalCode", POSTAL_CODE_FIELD);
        map.put("postalCodePlus4", POSTAL_CODE_PLUS4_FIELD);
        map.put("country", COUNTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CandidateAddress, T> g) {
        return obj -> g.apply((CandidateAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CandidateAddress> {
        /**
         * <p>
         * The street information of a candidate address
         * </p>
         * 
         * @param streetInfo
         *        The street information of a candidate address
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetInfo(String streetInfo);

        /**
         * <p>
         * The numeric portion of a candidate address.
         * </p>
         * 
         * @param streetNumber
         *        The numeric portion of a candidate address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetNumber(String streetNumber);

        /**
         * <p>
         * The city of a candidate address.
         * </p>
         * 
         * @param city
         *        The city of a candidate address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state of a candidate address.
         * </p>
         * 
         * @param state
         *        The state of a candidate address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The postal code of a candidate address.
         * </p>
         * 
         * @param postalCode
         *        The postal code of a candidate address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The Zip + 4 or postal code + 4 of a candidate address.
         * </p>
         * 
         * @param postalCodePlus4
         *        The Zip + 4 or postal code + 4 of a candidate address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCodePlus4(String postalCodePlus4);

        /**
         * <p>
         * The country of a candidate address.
         * </p>
         * 
         * @param country
         *        The country of a candidate address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);
    }

    static final class BuilderImpl implements Builder {
        private String streetInfo;

        private String streetNumber;

        private String city;

        private String state;

        private String postalCode;

        private String postalCodePlus4;

        private String country;

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateAddress model) {
            streetInfo(model.streetInfo);
            streetNumber(model.streetNumber);
            city(model.city);
            state(model.state);
            postalCode(model.postalCode);
            postalCodePlus4(model.postalCodePlus4);
            country(model.country);
        }

        public final String getStreetInfo() {
            return streetInfo;
        }

        public final void setStreetInfo(String streetInfo) {
            this.streetInfo = streetInfo;
        }

        @Override
        public final Builder streetInfo(String streetInfo) {
            this.streetInfo = streetInfo;
            return this;
        }

        public final String getStreetNumber() {
            return streetNumber;
        }

        public final void setStreetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
        }

        @Override
        public final Builder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getPostalCodePlus4() {
            return postalCodePlus4;
        }

        public final void setPostalCodePlus4(String postalCodePlus4) {
            this.postalCodePlus4 = postalCodePlus4;
        }

        @Override
        public final Builder postalCodePlus4(String postalCodePlus4) {
            this.postalCodePlus4 = postalCodePlus4;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        @Override
        public CandidateAddress build() {
            return new CandidateAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
