/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAppInstanceAdminRequest extends ChimeRequest implements
        ToCopyableBuilder<DeleteAppInstanceAdminRequest.Builder, DeleteAppInstanceAdminRequest> {
    private static final SdkField<String> APP_INSTANCE_ADMIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceAdminArn").getter(getter(DeleteAppInstanceAdminRequest::appInstanceAdminArn))
            .setter(setter(Builder::appInstanceAdminArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceAdminArn").build()).build();

    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(DeleteAppInstanceAdminRequest::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ADMIN_ARN_FIELD,
            APP_INSTANCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceAdminArn;

    private final String appInstanceArn;

    private DeleteAppInstanceAdminRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceAdminArn = builder.appInstanceAdminArn;
        this.appInstanceArn = builder.appInstanceArn;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code>'s administrator.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code>'s administrator.
     */
    public final String appInstanceAdminArn() {
        return appInstanceAdminArn;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code>.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceAdminArn());
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppInstanceAdminRequest)) {
            return false;
        }
        DeleteAppInstanceAdminRequest other = (DeleteAppInstanceAdminRequest) obj;
        return Objects.equals(appInstanceAdminArn(), other.appInstanceAdminArn())
                && Objects.equals(appInstanceArn(), other.appInstanceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAppInstanceAdminRequest").add("AppInstanceAdminArn", appInstanceAdminArn())
                .add("AppInstanceArn", appInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceAdminArn":
            return Optional.ofNullable(clazz.cast(appInstanceAdminArn()));
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appInstanceAdminArn", APP_INSTANCE_ADMIN_ARN_FIELD);
        map.put("appInstanceArn", APP_INSTANCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppInstanceAdminRequest, T> g) {
        return obj -> g.apply((DeleteAppInstanceAdminRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAppInstanceAdminRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstance</code>'s administrator.
         * </p>
         * 
         * @param appInstanceAdminArn
         *        The ARN of the <code>AppInstance</code>'s administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceAdminArn(String appInstanceAdminArn);

        /**
         * <p>
         * The ARN of the <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String appInstanceAdminArn;

        private String appInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppInstanceAdminRequest model) {
            super(model);
            appInstanceAdminArn(model.appInstanceAdminArn);
            appInstanceArn(model.appInstanceArn);
        }

        public final String getAppInstanceAdminArn() {
            return appInstanceAdminArn;
        }

        public final void setAppInstanceAdminArn(String appInstanceAdminArn) {
            this.appInstanceAdminArn = appInstanceAdminArn;
        }

        @Override
        public final Builder appInstanceAdminArn(String appInstanceAdminArn) {
            this.appInstanceAdminArn = appInstanceAdminArn;
            return this;
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAppInstanceAdminRequest build() {
            return new DeleteAppInstanceAdminRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
