/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChannelModeratedByAppInstanceUserRequest extends ChimeRequest
        implements
        ToCopyableBuilder<DescribeChannelModeratedByAppInstanceUserRequest.Builder, DescribeChannelModeratedByAppInstanceUserRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(DescribeChannelModeratedByAppInstanceUserRequest::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceUserArn")
            .getter(getter(DescribeChannelModeratedByAppInstanceUserRequest::appInstanceUserArn))
            .setter(setter(Builder::appInstanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("app-instance-user-arn").build())
            .build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(DescribeChannelModeratedByAppInstanceUserRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            APP_INSTANCE_USER_ARN_FIELD, CHIME_BEARER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelArn;

    private final String appInstanceUserArn;

    private final String chimeBearer;

    private DescribeChannelModeratedByAppInstanceUserRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the moderated channel.
     * </p>
     * 
     * @return The ARN of the moderated channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code> in the moderated channel.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code> in the moderated channel.
     */
    public final String appInstanceUserArn() {
        return appInstanceUserArn;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelModeratedByAppInstanceUserRequest)) {
            return false;
        }
        DescribeChannelModeratedByAppInstanceUserRequest other = (DescribeChannelModeratedByAppInstanceUserRequest) obj;
        return Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(appInstanceUserArn(), other.appInstanceUserArn())
                && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChannelModeratedByAppInstanceUserRequest").add("ChannelArn", channelArn())
                .add("AppInstanceUserArn", appInstanceUserArn()).add("ChimeBearer", chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "AppInstanceUserArn":
            return Optional.ofNullable(clazz.cast(appInstanceUserArn()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("app-instance-user-arn", APP_INSTANCE_USER_ARN_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelModeratedByAppInstanceUserRequest, T> g) {
        return obj -> g.apply((DescribeChannelModeratedByAppInstanceUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChannelModeratedByAppInstanceUserRequest> {
        /**
         * <p>
         * The ARN of the moderated channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the moderated channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code> in the moderated channel.
         * </p>
         * 
         * @param appInstanceUserArn
         *        The ARN of the <code>AppInstanceUser</code> in the moderated channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserArn(String appInstanceUserArn);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String appInstanceUserArn;

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelModeratedByAppInstanceUserRequest model) {
            super(model);
            channelArn(model.channelArn);
            appInstanceUserArn(model.appInstanceUserArn);
            chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getAppInstanceUserArn() {
            return appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeChannelModeratedByAppInstanceUserRequest build() {
            return new DescribeChannelModeratedByAppInstanceUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
