/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersRequest extends ChimeRequest implements
        ToCopyableBuilder<ListPhoneNumbersRequest.Builder, ListPhoneNumbersRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListPhoneNumbersRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(ListPhoneNumbersRequest::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("product-type").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterName").getter(getter(ListPhoneNumbersRequest::filterNameAsString))
            .setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filter-name").build()).build();

    private static final SdkField<String> FILTER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterValue").getter(getter(ListPhoneNumbersRequest::filterValue)).setter(setter(Builder::filterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filter-value").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPhoneNumbersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPhoneNumbersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            PRODUCT_TYPE_FIELD, FILTER_NAME_FIELD, FILTER_VALUE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String productType;

    private final String filterName;

    private final String filterValue;

    private final Integer maxResults;

    private final String nextToken;

    private ListPhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.productType = builder.productType;
        this.filterName = builder.filterName;
        this.filterValue = builder.filterValue;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The phone number status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The phone number status.
     * @see PhoneNumberStatus
     */
    public final PhoneNumberStatus status() {
        return PhoneNumberStatus.fromValue(status);
    }

    /**
     * <p>
     * The phone number status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The phone number status.
     * @see PhoneNumberStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The phone number product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number product type.
     * @see PhoneNumberProductType
     */
    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(productType);
    }

    /**
     * <p>
     * The phone number product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number product type.
     * @see PhoneNumberProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The filter to use to limit the number of results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterName} will
     * return {@link PhoneNumberAssociationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterNameAsString}.
     * </p>
     * 
     * @return The filter to use to limit the number of results.
     * @see PhoneNumberAssociationName
     */
    public final PhoneNumberAssociationName filterName() {
        return PhoneNumberAssociationName.fromValue(filterName);
    }

    /**
     * <p>
     * The filter to use to limit the number of results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterName} will
     * return {@link PhoneNumberAssociationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterNameAsString}.
     * </p>
     * 
     * @return The filter to use to limit the number of results.
     * @see PhoneNumberAssociationName
     */
    public final String filterNameAsString() {
        return filterName;
    }

    /**
     * <p>
     * The value to use for the filter.
     * </p>
     * 
     * @return The value to use for the filter.
     */
    public final String filterValue() {
        return filterValue;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersRequest)) {
            return false;
        }
        ListPhoneNumbersRequest other = (ListPhoneNumbersRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(filterNameAsString(), other.filterNameAsString())
                && Objects.equals(filterValue(), other.filterValue()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPhoneNumbersRequest").add("Status", statusAsString())
                .add("ProductType", productTypeAsString()).add("FilterName", filterNameAsString())
                .add("FilterValue", filterValue()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "FilterName":
            return Optional.ofNullable(clazz.cast(filterNameAsString()));
        case "FilterValue":
            return Optional.ofNullable(clazz.cast(filterValue()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("product-type", PRODUCT_TYPE_FIELD);
        map.put("filter-name", FILTER_NAME_FIELD);
        map.put("filter-value", FILTER_VALUE_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersRequest, T> g) {
        return obj -> g.apply((ListPhoneNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersRequest> {
        /**
         * <p>
         * The phone number status.
         * </p>
         * 
         * @param status
         *        The phone number status.
         * @see PhoneNumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The phone number status.
         * </p>
         * 
         * @param status
         *        The phone number status.
         * @see PhoneNumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberStatus
         */
        Builder status(PhoneNumberStatus status);

        /**
         * <p>
         * The phone number product type.
         * </p>
         * 
         * @param productType
         *        The phone number product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The phone number product type.
         * </p>
         * 
         * @param productType
         *        The phone number product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(PhoneNumberProductType productType);

        /**
         * <p>
         * The filter to use to limit the number of results.
         * </p>
         * 
         * @param filterName
         *        The filter to use to limit the number of results.
         * @see PhoneNumberAssociationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberAssociationName
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * The filter to use to limit the number of results.
         * </p>
         * 
         * @param filterName
         *        The filter to use to limit the number of results.
         * @see PhoneNumberAssociationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberAssociationName
         */
        Builder filterName(PhoneNumberAssociationName filterName);

        /**
         * <p>
         * The value to use for the filter.
         * </p>
         * 
         * @param filterValue
         *        The value to use for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValue(String filterValue);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String status;

        private String productType;

        private String filterName;

        private String filterValue;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersRequest model) {
            super(model);
            status(model.status);
            productType(model.productType);
            filterName(model.filterName);
            filterValue(model.filterValue);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhoneNumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        @Override
        public final Builder filterName(PhoneNumberAssociationName filterName) {
            this.filterName(filterName == null ? null : filterName.toString());
            return this;
        }

        public final String getFilterValue() {
            return filterValue;
        }

        public final void setFilterValue(String filterValue) {
            this.filterValue = filterValue;
        }

        @Override
        public final Builder filterValue(String filterValue) {
            this.filterValue = filterValue;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPhoneNumbersRequest build() {
            return new ListPhoneNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
