/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The phone number country.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberCountry implements SdkPojo, Serializable,
        ToCopyableBuilder<PhoneNumberCountry.Builder, PhoneNumberCountry> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(PhoneNumberCountry::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<List<String>> SUPPORTED_PHONE_NUMBER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedPhoneNumberTypes")
            .getter(getter(PhoneNumberCountry::supportedPhoneNumberTypesAsStrings))
            .setter(setter(Builder::supportedPhoneNumberTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPhoneNumberTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD,
            SUPPORTED_PHONE_NUMBER_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String countryCode;

    private final List<String> supportedPhoneNumberTypes;

    private PhoneNumberCountry(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.supportedPhoneNumberTypes = builder.supportedPhoneNumberTypes;
    }

    /**
     * <p>
     * The phone number country code. Format: ISO 3166-1 alpha-2.
     * </p>
     * 
     * @return The phone number country code. Format: ISO 3166-1 alpha-2.
     */
    public final String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The supported phone number types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPhoneNumberTypes} method.
     * </p>
     * 
     * @return The supported phone number types.
     */
    public final List<PhoneNumberType> supportedPhoneNumberTypes() {
        return PhoneNumberTypeListCopier.copyStringToEnum(supportedPhoneNumberTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedPhoneNumberTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedPhoneNumberTypes() {
        return supportedPhoneNumberTypes != null && !(supportedPhoneNumberTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported phone number types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPhoneNumberTypes} method.
     * </p>
     * 
     * @return The supported phone number types.
     */
    public final List<String> supportedPhoneNumberTypesAsStrings() {
        return supportedPhoneNumberTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedPhoneNumberTypes() ? supportedPhoneNumberTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberCountry)) {
            return false;
        }
        PhoneNumberCountry other = (PhoneNumberCountry) obj;
        return Objects.equals(countryCode(), other.countryCode())
                && hasSupportedPhoneNumberTypes() == other.hasSupportedPhoneNumberTypes()
                && Objects.equals(supportedPhoneNumberTypesAsStrings(), other.supportedPhoneNumberTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumberCountry").add("CountryCode", countryCode())
                .add("SupportedPhoneNumberTypes", hasSupportedPhoneNumberTypes() ? supportedPhoneNumberTypesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "SupportedPhoneNumberTypes":
            return Optional.ofNullable(clazz.cast(supportedPhoneNumberTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("SupportedPhoneNumberTypes", SUPPORTED_PHONE_NUMBER_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberCountry, T> g) {
        return obj -> g.apply((PhoneNumberCountry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumberCountry> {
        /**
         * <p>
         * The phone number country code. Format: ISO 3166-1 alpha-2.
         * </p>
         * 
         * @param countryCode
         *        The phone number country code. Format: ISO 3166-1 alpha-2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The supported phone number types.
         * </p>
         * 
         * @param supportedPhoneNumberTypes
         *        The supported phone number types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPhoneNumberTypesWithStrings(Collection<String> supportedPhoneNumberTypes);

        /**
         * <p>
         * The supported phone number types.
         * </p>
         * 
         * @param supportedPhoneNumberTypes
         *        The supported phone number types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPhoneNumberTypesWithStrings(String... supportedPhoneNumberTypes);

        /**
         * <p>
         * The supported phone number types.
         * </p>
         * 
         * @param supportedPhoneNumberTypes
         *        The supported phone number types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPhoneNumberTypes(Collection<PhoneNumberType> supportedPhoneNumberTypes);

        /**
         * <p>
         * The supported phone number types.
         * </p>
         * 
         * @param supportedPhoneNumberTypes
         *        The supported phone number types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPhoneNumberTypes(PhoneNumberType... supportedPhoneNumberTypes);
    }

    static final class BuilderImpl implements Builder {
        private String countryCode;

        private List<String> supportedPhoneNumberTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberCountry model) {
            countryCode(model.countryCode);
            supportedPhoneNumberTypesWithStrings(model.supportedPhoneNumberTypes);
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final Collection<String> getSupportedPhoneNumberTypes() {
            if (supportedPhoneNumberTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedPhoneNumberTypes;
        }

        public final void setSupportedPhoneNumberTypes(Collection<String> supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes = PhoneNumberTypeListCopier.copy(supportedPhoneNumberTypes);
        }

        @Override
        public final Builder supportedPhoneNumberTypesWithStrings(Collection<String> supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes = PhoneNumberTypeListCopier.copy(supportedPhoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPhoneNumberTypesWithStrings(String... supportedPhoneNumberTypes) {
            supportedPhoneNumberTypesWithStrings(Arrays.asList(supportedPhoneNumberTypes));
            return this;
        }

        @Override
        public final Builder supportedPhoneNumberTypes(Collection<PhoneNumberType> supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes = PhoneNumberTypeListCopier.copyEnumToString(supportedPhoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPhoneNumberTypes(PhoneNumberType... supportedPhoneNumberTypes) {
            supportedPhoneNumberTypes(Arrays.asList(supportedPhoneNumberTypes));
            return this;
        }

        @Override
        public PhoneNumberCountry build() {
            return new PhoneNumberCountry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
