/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventsConfigurationRequest extends ChimeRequest implements
        ToCopyableBuilder<PutEventsConfigurationRequest.Builder, PutEventsConfigurationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(PutEventsConfigurationRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("BotId")
            .getter(getter(PutEventsConfigurationRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutboundEventsHTTPSEndpoint")
            .getter(getter(PutEventsConfigurationRequest::outboundEventsHTTPSEndpoint))
            .setter(setter(Builder::outboundEventsHTTPSEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundEventsHTTPSEndpoint")
                    .build()).build();

    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LambdaFunctionArn").getter(getter(PutEventsConfigurationRequest::lambdaFunctionArn))
            .setter(setter(Builder::lambdaFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BOT_ID_FIELD, OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD, LAMBDA_FUNCTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String botId;

    private final String outboundEventsHTTPSEndpoint;

    private final String lambdaFunctionArn;

    private PutEventsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.botId = builder.botId;
        this.outboundEventsHTTPSEndpoint = builder.outboundEventsHTTPSEndpoint;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The bot ID.
     * </p>
     * 
     * @return The bot ID.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * HTTPS endpoint that allows the bot to receive outgoing events.
     * </p>
     * 
     * @return HTTPS endpoint that allows the bot to receive outgoing events.
     */
    public final String outboundEventsHTTPSEndpoint() {
        return outboundEventsHTTPSEndpoint;
    }

    /**
     * <p>
     * Lambda function ARN that allows the bot to receive outgoing events.
     * </p>
     * 
     * @return Lambda function ARN that allows the bot to receive outgoing events.
     */
    public final String lambdaFunctionArn() {
        return lambdaFunctionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(outboundEventsHTTPSEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsConfigurationRequest)) {
            return false;
        }
        PutEventsConfigurationRequest other = (PutEventsConfigurationRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(botId(), other.botId())
                && Objects.equals(outboundEventsHTTPSEndpoint(), other.outboundEventsHTTPSEndpoint())
                && Objects.equals(lambdaFunctionArn(), other.lambdaFunctionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutEventsConfigurationRequest")
                .add("AccountId", accountId())
                .add("BotId", botId())
                .add("OutboundEventsHTTPSEndpoint",
                        outboundEventsHTTPSEndpoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LambdaFunctionArn", lambdaFunctionArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BotId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "OutboundEventsHTTPSEndpoint":
            return Optional.ofNullable(clazz.cast(outboundEventsHTTPSEndpoint()));
        case "LambdaFunctionArn":
            return Optional.ofNullable(clazz.cast(lambdaFunctionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("OutboundEventsHTTPSEndpoint", OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD);
        map.put("LambdaFunctionArn", LAMBDA_FUNCTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEventsConfigurationRequest, T> g) {
        return obj -> g.apply((PutEventsConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutEventsConfigurationRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The bot ID.
         * </p>
         * 
         * @param botId
         *        The bot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * HTTPS endpoint that allows the bot to receive outgoing events.
         * </p>
         * 
         * @param outboundEventsHTTPSEndpoint
         *        HTTPS endpoint that allows the bot to receive outgoing events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint);

        /**
         * <p>
         * Lambda function ARN that allows the bot to receive outgoing events.
         * </p>
         * 
         * @param lambdaFunctionArn
         *        Lambda function ARN that allows the bot to receive outgoing events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionArn(String lambdaFunctionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private String botId;

        private String outboundEventsHTTPSEndpoint;

        private String lambdaFunctionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsConfigurationRequest model) {
            super(model);
            accountId(model.accountId);
            botId(model.botId);
            outboundEventsHTTPSEndpoint(model.outboundEventsHTTPSEndpoint);
            lambdaFunctionArn(model.lambdaFunctionArn);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getOutboundEventsHTTPSEndpoint() {
            return outboundEventsHTTPSEndpoint;
        }

        public final void setOutboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
        }

        @Override
        public final Builder outboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventsConfigurationRequest build() {
            return new PutEventsConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
