/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A validated address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> STREET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streetName").getter(getter(Address::streetName)).setter(setter(Builder::streetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetName").build()).build();

    private static final SdkField<String> STREET_SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streetSuffix").getter(getter(Address::streetSuffix)).setter(setter(Builder::streetSuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetSuffix").build()).build();

    private static final SdkField<String> POST_DIRECTIONAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postDirectional").getter(getter(Address::postDirectional)).setter(setter(Builder::postDirectional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postDirectional").build()).build();

    private static final SdkField<String> PRE_DIRECTIONAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preDirectional").getter(getter(Address::preDirectional)).setter(setter(Builder::preDirectional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preDirectional").build()).build();

    private static final SdkField<String> STREET_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streetNumber").getter(getter(Address::streetNumber)).setter(setter(Builder::streetNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetNumber").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("city")
            .getter(getter(Address::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Address::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postalCode").getter(getter(Address::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()).build();

    private static final SdkField<String> POSTAL_CODE_PLUS4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postalCodePlus4").getter(getter(Address::postalCodePlus4)).setter(setter(Builder::postalCodePlus4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCodePlus4").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("country")
            .getter(getter(Address::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREET_NAME_FIELD,
            STREET_SUFFIX_FIELD, POST_DIRECTIONAL_FIELD, PRE_DIRECTIONAL_FIELD, STREET_NUMBER_FIELD, CITY_FIELD, STATE_FIELD,
            POSTAL_CODE_FIELD, POSTAL_CODE_PLUS4_FIELD, COUNTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streetName;

    private final String streetSuffix;

    private final String postDirectional;

    private final String preDirectional;

    private final String streetNumber;

    private final String city;

    private final String state;

    private final String postalCode;

    private final String postalCodePlus4;

    private final String country;

    private Address(BuilderImpl builder) {
        this.streetName = builder.streetName;
        this.streetSuffix = builder.streetSuffix;
        this.postDirectional = builder.postDirectional;
        this.preDirectional = builder.preDirectional;
        this.streetNumber = builder.streetNumber;
        this.city = builder.city;
        this.state = builder.state;
        this.postalCode = builder.postalCode;
        this.postalCodePlus4 = builder.postalCodePlus4;
        this.country = builder.country;
    }

    /**
     * <p>
     * The address street, such as <code>8th Avenue</code>.
     * </p>
     * 
     * @return The address street, such as <code>8th Avenue</code>.
     */
    public final String streetName() {
        return streetName;
    }

    /**
     * <p>
     * The address suffix, such as the <code>N</code> in <code>8th Avenue N</code>.
     * </p>
     * 
     * @return The address suffix, such as the <code>N</code> in <code>8th Avenue N</code>.
     */
    public final String streetSuffix() {
        return streetSuffix;
    }

    /**
     * <p>
     * An address suffix location, such as the <code>S. Unit A</code> in <code>Central Park S. Unit A</code>.
     * </p>
     * 
     * @return An address suffix location, such as the <code>S. Unit A</code> in <code>Central Park S. Unit A</code>.
     */
    public final String postDirectional() {
        return postDirectional;
    }

    /**
     * <p>
     * An address prefix location, such as the <code>N</code> in <code>N. Third St.</code>.
     * </p>
     * 
     * @return An address prefix location, such as the <code>N</code> in <code>N. Third St.</code>.
     */
    public final String preDirectional() {
        return preDirectional;
    }

    /**
     * <p>
     * The numeric portion of an address.
     * </p>
     * 
     * @return The numeric portion of an address.
     */
    public final String streetNumber() {
        return streetNumber;
    }

    /**
     * <p>
     * The city of an address.
     * </p>
     * 
     * @return The city of an address.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The state of an address.
     * </p>
     * 
     * @return The state of an address.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The postal code of an address.
     * </p>
     * 
     * @return The postal code of an address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The Zip + 4 or postal code + 4 of an address.
     * </p>
     * 
     * @return The Zip + 4 or postal code + 4 of an address.
     */
    public final String postalCodePlus4() {
        return postalCodePlus4;
    }

    /**
     * <p>
     * The country of an address.
     * </p>
     * 
     * @return The country of an address.
     */
    public final String country() {
        return country;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streetName());
        hashCode = 31 * hashCode + Objects.hashCode(streetSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(postDirectional());
        hashCode = 31 * hashCode + Objects.hashCode(preDirectional());
        hashCode = 31 * hashCode + Objects.hashCode(streetNumber());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(postalCodePlus4());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(streetName(), other.streetName()) && Objects.equals(streetSuffix(), other.streetSuffix())
                && Objects.equals(postDirectional(), other.postDirectional())
                && Objects.equals(preDirectional(), other.preDirectional())
                && Objects.equals(streetNumber(), other.streetNumber()) && Objects.equals(city(), other.city())
                && Objects.equals(state(), other.state()) && Objects.equals(postalCode(), other.postalCode())
                && Objects.equals(postalCodePlus4(), other.postalCodePlus4()) && Objects.equals(country(), other.country());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("StreetName", streetName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StreetSuffix", streetSuffix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostDirectional", postDirectional() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PreDirectional", preDirectional() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StreetNumber", streetNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("State", state() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCodePlus4", postalCodePlus4() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streetName":
            return Optional.ofNullable(clazz.cast(streetName()));
        case "streetSuffix":
            return Optional.ofNullable(clazz.cast(streetSuffix()));
        case "postDirectional":
            return Optional.ofNullable(clazz.cast(postDirectional()));
        case "preDirectional":
            return Optional.ofNullable(clazz.cast(preDirectional()));
        case "streetNumber":
            return Optional.ofNullable(clazz.cast(streetNumber()));
        case "city":
            return Optional.ofNullable(clazz.cast(city()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "postalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "postalCodePlus4":
            return Optional.ofNullable(clazz.cast(postalCodePlus4()));
        case "country":
            return Optional.ofNullable(clazz.cast(country()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streetName", STREET_NAME_FIELD);
        map.put("streetSuffix", STREET_SUFFIX_FIELD);
        map.put("postDirectional", POST_DIRECTIONAL_FIELD);
        map.put("preDirectional", PRE_DIRECTIONAL_FIELD);
        map.put("streetNumber", STREET_NUMBER_FIELD);
        map.put("city", CITY_FIELD);
        map.put("state", STATE_FIELD);
        map.put("postalCode", POSTAL_CODE_FIELD);
        map.put("postalCodePlus4", POSTAL_CODE_PLUS4_FIELD);
        map.put("country", COUNTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The address street, such as <code>8th Avenue</code>.
         * </p>
         * 
         * @param streetName
         *        The address street, such as <code>8th Avenue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetName(String streetName);

        /**
         * <p>
         * The address suffix, such as the <code>N</code> in <code>8th Avenue N</code>.
         * </p>
         * 
         * @param streetSuffix
         *        The address suffix, such as the <code>N</code> in <code>8th Avenue N</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetSuffix(String streetSuffix);

        /**
         * <p>
         * An address suffix location, such as the <code>S. Unit A</code> in <code>Central Park S. Unit A</code>.
         * </p>
         * 
         * @param postDirectional
         *        An address suffix location, such as the <code>S. Unit A</code> in <code>Central Park S. Unit A</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postDirectional(String postDirectional);

        /**
         * <p>
         * An address prefix location, such as the <code>N</code> in <code>N. Third St.</code>.
         * </p>
         * 
         * @param preDirectional
         *        An address prefix location, such as the <code>N</code> in <code>N. Third St.</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preDirectional(String preDirectional);

        /**
         * <p>
         * The numeric portion of an address.
         * </p>
         * 
         * @param streetNumber
         *        The numeric portion of an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetNumber(String streetNumber);

        /**
         * <p>
         * The city of an address.
         * </p>
         * 
         * @param city
         *        The city of an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state of an address.
         * </p>
         * 
         * @param state
         *        The state of an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The postal code of an address.
         * </p>
         * 
         * @param postalCode
         *        The postal code of an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The Zip + 4 or postal code + 4 of an address.
         * </p>
         * 
         * @param postalCodePlus4
         *        The Zip + 4 or postal code + 4 of an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCodePlus4(String postalCodePlus4);

        /**
         * <p>
         * The country of an address.
         * </p>
         * 
         * @param country
         *        The country of an address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);
    }

    static final class BuilderImpl implements Builder {
        private String streetName;

        private String streetSuffix;

        private String postDirectional;

        private String preDirectional;

        private String streetNumber;

        private String city;

        private String state;

        private String postalCode;

        private String postalCodePlus4;

        private String country;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            streetName(model.streetName);
            streetSuffix(model.streetSuffix);
            postDirectional(model.postDirectional);
            preDirectional(model.preDirectional);
            streetNumber(model.streetNumber);
            city(model.city);
            state(model.state);
            postalCode(model.postalCode);
            postalCodePlus4(model.postalCodePlus4);
            country(model.country);
        }

        public final String getStreetName() {
            return streetName;
        }

        public final void setStreetName(String streetName) {
            this.streetName = streetName;
        }

        @Override
        public final Builder streetName(String streetName) {
            this.streetName = streetName;
            return this;
        }

        public final String getStreetSuffix() {
            return streetSuffix;
        }

        public final void setStreetSuffix(String streetSuffix) {
            this.streetSuffix = streetSuffix;
        }

        @Override
        public final Builder streetSuffix(String streetSuffix) {
            this.streetSuffix = streetSuffix;
            return this;
        }

        public final String getPostDirectional() {
            return postDirectional;
        }

        public final void setPostDirectional(String postDirectional) {
            this.postDirectional = postDirectional;
        }

        @Override
        public final Builder postDirectional(String postDirectional) {
            this.postDirectional = postDirectional;
            return this;
        }

        public final String getPreDirectional() {
            return preDirectional;
        }

        public final void setPreDirectional(String preDirectional) {
            this.preDirectional = preDirectional;
        }

        @Override
        public final Builder preDirectional(String preDirectional) {
            this.preDirectional = preDirectional;
            return this;
        }

        public final String getStreetNumber() {
            return streetNumber;
        }

        public final void setStreetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
        }

        @Override
        public final Builder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getPostalCodePlus4() {
            return postalCodePlus4;
        }

        public final void setPostalCodePlus4(String postalCodePlus4) {
            this.postalCodePlus4 = postalCodePlus4;
        }

        @Override
        public final Builder postalCodePlus4(String postalCodePlus4) {
            this.postalCodePlus4 = postalCodePlus4;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
