/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttendeesResponse extends ChimeResponse implements
        ToCopyableBuilder<ListAttendeesResponse.Builder, ListAttendeesResponse> {
    private static final SdkField<List<Attendee>> ATTENDEES_FIELD = SdkField
            .<List<Attendee>> builder(MarshallingType.LIST)
            .memberName("Attendees")
            .getter(getter(ListAttendeesResponse::attendees))
            .setter(setter(Builder::attendees))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attendee> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attendee::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAttendeesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENDEES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Attendee> attendees;

    private final String nextToken;

    private ListAttendeesResponse(BuilderImpl builder) {
        super(builder);
        this.attendees = builder.attendees;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attendees property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttendees() {
        return attendees != null && !(attendees instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Chime SDK attendee information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttendees} method.
     * </p>
     * 
     * @return The Amazon Chime SDK attendee information.
     */
    public final List<Attendee> attendees() {
        return attendees;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttendees() ? attendees() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttendeesResponse)) {
            return false;
        }
        ListAttendeesResponse other = (ListAttendeesResponse) obj;
        return hasAttendees() == other.hasAttendees() && Objects.equals(attendees(), other.attendees())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttendeesResponse").add("Attendees", hasAttendees() ? attendees() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attendees":
            return Optional.ofNullable(clazz.cast(attendees()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attendees", ATTENDEES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAttendeesResponse, T> g) {
        return obj -> g.apply((ListAttendeesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAttendeesResponse> {
        /**
         * <p>
         * The Amazon Chime SDK attendee information.
         * </p>
         * 
         * @param attendees
         *        The Amazon Chime SDK attendee information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Collection<Attendee> attendees);

        /**
         * <p>
         * The Amazon Chime SDK attendee information.
         * </p>
         * 
         * @param attendees
         *        The Amazon Chime SDK attendee information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Attendee... attendees);

        /**
         * <p>
         * The Amazon Chime SDK attendee information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chime.model.Attendee.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.chime.model.Attendee#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chime.model.Attendee.Builder#build()} is called immediately and its
         * result is passed to {@link #attendees(List<Attendee>)}.
         * 
         * @param attendees
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chime.model.Attendee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendees(java.util.Collection<Attendee>)
         */
        Builder attendees(Consumer<Attendee.Builder>... attendees);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<Attendee> attendees = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttendeesResponse model) {
            super(model);
            attendees(model.attendees);
            nextToken(model.nextToken);
        }

        public final List<Attendee.Builder> getAttendees() {
            List<Attendee.Builder> result = AttendeeListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<Attendee.BuilderImpl> attendees) {
            this.attendees = AttendeeListCopier.copyFromBuilder(attendees);
        }

        @Override
        public final Builder attendees(Collection<Attendee> attendees) {
            this.attendees = AttendeeListCopier.copy(attendees);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Attendee... attendees) {
            attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Consumer<Attendee.Builder>... attendees) {
            attendees(Stream.of(attendees).map(c -> Attendee.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAttendeesResponse build() {
            return new ListAttendeesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
