/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVoiceConnectorGroupsResponse extends ChimeResponse implements
        ToCopyableBuilder<ListVoiceConnectorGroupsResponse.Builder, ListVoiceConnectorGroupsResponse> {
    private static final SdkField<List<VoiceConnectorGroup>> VOICE_CONNECTOR_GROUPS_FIELD = SdkField
            .<List<VoiceConnectorGroup>> builder(MarshallingType.LIST)
            .memberName("VoiceConnectorGroups")
            .getter(getter(ListVoiceConnectorGroupsResponse::voiceConnectorGroups))
            .setter(setter(Builder::voiceConnectorGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VoiceConnectorGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(VoiceConnectorGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListVoiceConnectorGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VoiceConnectorGroup> voiceConnectorGroups;

    private final String nextToken;

    private ListVoiceConnectorGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorGroups = builder.voiceConnectorGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VoiceConnectorGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVoiceConnectorGroups() {
        return voiceConnectorGroups != null && !(voiceConnectorGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the Amazon Chime Voice Connector groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoiceConnectorGroups} method.
     * </p>
     * 
     * @return The details of the Amazon Chime Voice Connector groups.
     */
    public final List<VoiceConnectorGroup> voiceConnectorGroups() {
        return voiceConnectorGroups;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVoiceConnectorGroups() ? voiceConnectorGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVoiceConnectorGroupsResponse)) {
            return false;
        }
        ListVoiceConnectorGroupsResponse other = (ListVoiceConnectorGroupsResponse) obj;
        return hasVoiceConnectorGroups() == other.hasVoiceConnectorGroups()
                && Objects.equals(voiceConnectorGroups(), other.voiceConnectorGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVoiceConnectorGroupsResponse")
                .add("VoiceConnectorGroups", hasVoiceConnectorGroups() ? voiceConnectorGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorGroups":
            return Optional.ofNullable(clazz.cast(voiceConnectorGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceConnectorGroups", VOICE_CONNECTOR_GROUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVoiceConnectorGroupsResponse, T> g) {
        return obj -> g.apply((ListVoiceConnectorGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVoiceConnectorGroupsResponse> {
        /**
         * <p>
         * The details of the Amazon Chime Voice Connector groups.
         * </p>
         * 
         * @param voiceConnectorGroups
         *        The details of the Amazon Chime Voice Connector groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorGroups(Collection<VoiceConnectorGroup> voiceConnectorGroups);

        /**
         * <p>
         * The details of the Amazon Chime Voice Connector groups.
         * </p>
         * 
         * @param voiceConnectorGroups
         *        The details of the Amazon Chime Voice Connector groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorGroups(VoiceConnectorGroup... voiceConnectorGroups);

        /**
         * <p>
         * The details of the Amazon Chime Voice Connector groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chime.model.VoiceConnectorGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chime.model.VoiceConnectorGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chime.model.VoiceConnectorGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #voiceConnectorGroups(List<VoiceConnectorGroup>)}.
         * 
         * @param voiceConnectorGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chime.model.VoiceConnectorGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnectorGroups(java.util.Collection<VoiceConnectorGroup>)
         */
        Builder voiceConnectorGroups(Consumer<VoiceConnectorGroup.Builder>... voiceConnectorGroups);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<VoiceConnectorGroup> voiceConnectorGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVoiceConnectorGroupsResponse model) {
            super(model);
            voiceConnectorGroups(model.voiceConnectorGroups);
            nextToken(model.nextToken);
        }

        public final List<VoiceConnectorGroup.Builder> getVoiceConnectorGroups() {
            List<VoiceConnectorGroup.Builder> result = VoiceConnectorGroupListCopier.copyToBuilder(this.voiceConnectorGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceConnectorGroups(Collection<VoiceConnectorGroup.BuilderImpl> voiceConnectorGroups) {
            this.voiceConnectorGroups = VoiceConnectorGroupListCopier.copyFromBuilder(voiceConnectorGroups);
        }

        @Override
        public final Builder voiceConnectorGroups(Collection<VoiceConnectorGroup> voiceConnectorGroups) {
            this.voiceConnectorGroups = VoiceConnectorGroupListCopier.copy(voiceConnectorGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorGroups(VoiceConnectorGroup... voiceConnectorGroups) {
            voiceConnectorGroups(Arrays.asList(voiceConnectorGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorGroups(Consumer<VoiceConnectorGroup.Builder>... voiceConnectorGroups) {
            voiceConnectorGroups(Stream.of(voiceConnectorGroups).map(c -> VoiceConnectorGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVoiceConnectorGroupsResponse build() {
            return new ListVoiceConnectorGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
