/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The phone number associations, such as Amazon Chime account ID, Amazon Chime user ID, Amazon Chime Voice Connector
 * ID, or Amazon Chime Voice Connector group ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<PhoneNumberAssociation.Builder, PhoneNumberAssociation> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(PhoneNumberAssociation::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PhoneNumberAssociation::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> ASSOCIATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AssociatedTimestamp")
            .getter(getter(PhoneNumberAssociation::associatedTimestamp))
            .setter(setter(Builder::associatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, NAME_FIELD,
            ASSOCIATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String name;

    private final Instant associatedTimestamp;

    private PhoneNumberAssociation(BuilderImpl builder) {
        this.value = builder.value;
        this.name = builder.name;
        this.associatedTimestamp = builder.associatedTimestamp;
    }

    /**
     * <p>
     * Contains the ID for the entity specified in Name.
     * </p>
     * 
     * @return Contains the ID for the entity specified in Name.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or Amazon
     * Chime Voice Connector group ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link PhoneNumberAssociationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or
     *         Amazon Chime Voice Connector group ID.
     * @see PhoneNumberAssociationName
     */
    public final PhoneNumberAssociationName name() {
        return PhoneNumberAssociationName.fromValue(name);
    }

    /**
     * <p>
     * Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or Amazon
     * Chime Voice Connector group ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link PhoneNumberAssociationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or
     *         Amazon Chime Voice Connector group ID.
     * @see PhoneNumberAssociationName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The timestamp of the phone number association, in ISO 8601 format.
     * </p>
     * 
     * @return The timestamp of the phone number association, in ISO 8601 format.
     */
    public final Instant associatedTimestamp() {
        return associatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberAssociation)) {
            return false;
        }
        PhoneNumberAssociation other = (PhoneNumberAssociation) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(associatedTimestamp(), other.associatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumberAssociation").add("Value", value()).add("Name", nameAsString())
                .add("AssociatedTimestamp", associatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "AssociatedTimestamp":
            return Optional.ofNullable(clazz.cast(associatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AssociatedTimestamp", ASSOCIATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberAssociation, T> g) {
        return obj -> g.apply((PhoneNumberAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumberAssociation> {
        /**
         * <p>
         * Contains the ID for the entity specified in Name.
         * </p>
         * 
         * @param value
         *        Contains the ID for the entity specified in Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or Amazon
         * Chime Voice Connector group ID.
         * </p>
         * 
         * @param name
         *        Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or
         *        Amazon Chime Voice Connector group ID.
         * @see PhoneNumberAssociationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberAssociationName
         */
        Builder name(String name);

        /**
         * <p>
         * Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or Amazon
         * Chime Voice Connector group ID.
         * </p>
         * 
         * @param name
         *        Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or
         *        Amazon Chime Voice Connector group ID.
         * @see PhoneNumberAssociationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberAssociationName
         */
        Builder name(PhoneNumberAssociationName name);

        /**
         * <p>
         * The timestamp of the phone number association, in ISO 8601 format.
         * </p>
         * 
         * @param associatedTimestamp
         *        The timestamp of the phone number association, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedTimestamp(Instant associatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String name;

        private Instant associatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberAssociation model) {
            value(model.value);
            name(model.name);
            associatedTimestamp(model.associatedTimestamp);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(PhoneNumberAssociationName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Instant getAssociatedTimestamp() {
            return associatedTimestamp;
        }

        public final void setAssociatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
        }

        @Override
        public final Builder associatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
            return this;
        }

        @Override
        public PhoneNumberAssociation build() {
            return new PhoneNumberAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
