/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateE911AddressResponse extends ChimeResponse implements
        ToCopyableBuilder<ValidateE911AddressResponse.Builder, ValidateE911AddressResponse> {
    private static final SdkField<Integer> VALIDATION_RESULT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidationResult").getter(getter(ValidateE911AddressResponse::validationResult))
            .setter(setter(Builder::validationResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationResult").build()).build();

    private static final SdkField<String> ADDRESS_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressExternalId").getter(getter(ValidateE911AddressResponse::addressExternalId))
            .setter(setter(Builder::addressExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressExternalId").build()).build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(ValidateE911AddressResponse::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<List<CandidateAddress>> CANDIDATE_ADDRESS_LIST_FIELD = SdkField
            .<List<CandidateAddress>> builder(MarshallingType.LIST)
            .memberName("CandidateAddressList")
            .getter(getter(ValidateE911AddressResponse::candidateAddressList))
            .setter(setter(Builder::candidateAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateAddressList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CandidateAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(CandidateAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_RESULT_FIELD,
            ADDRESS_EXTERNAL_ID_FIELD, ADDRESS_FIELD, CANDIDATE_ADDRESS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer validationResult;

    private final String addressExternalId;

    private final Address address;

    private final List<CandidateAddress> candidateAddressList;

    private ValidateE911AddressResponse(BuilderImpl builder) {
        super(builder);
        this.validationResult = builder.validationResult;
        this.addressExternalId = builder.addressExternalId;
        this.address = builder.address;
        this.candidateAddressList = builder.candidateAddressList;
    }

    /**
     * <p>
     * Number indicating the result of address validation. <code>0</code> means the address was perfect as is and
     * successfully validated. <code>1</code> means the address was corrected. <code>2</code> means the address sent was
     * not close enough and was not validated.
     * </p>
     * 
     * @return Number indicating the result of address validation. <code>0</code> means the address was perfect as is
     *         and successfully validated. <code>1</code> means the address was corrected. <code>2</code> means the
     *         address sent was not close enough and was not validated.
     */
    public final Integer validationResult() {
        return validationResult;
    }

    /**
     * <p>
     * The ID that represents the address.
     * </p>
     * 
     * @return The ID that represents the address.
     */
    public final String addressExternalId() {
        return addressExternalId;
    }

    /**
     * <p>
     * The validated address.
     * </p>
     * 
     * @return The validated address.
     */
    public final Address address() {
        return address;
    }

    /**
     * For responses, this returns true if the service returned a value for the CandidateAddressList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCandidateAddressList() {
        return candidateAddressList != null && !(candidateAddressList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of address suggestions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCandidateAddressList} method.
     * </p>
     * 
     * @return The list of address suggestions.
     */
    public final List<CandidateAddress> candidateAddressList() {
        return candidateAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(validationResult());
        hashCode = 31 * hashCode + Objects.hashCode(addressExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(hasCandidateAddressList() ? candidateAddressList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateE911AddressResponse)) {
            return false;
        }
        ValidateE911AddressResponse other = (ValidateE911AddressResponse) obj;
        return Objects.equals(validationResult(), other.validationResult())
                && Objects.equals(addressExternalId(), other.addressExternalId()) && Objects.equals(address(), other.address())
                && hasCandidateAddressList() == other.hasCandidateAddressList()
                && Objects.equals(candidateAddressList(), other.candidateAddressList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateE911AddressResponse").add("ValidationResult", validationResult())
                .add("AddressExternalId", addressExternalId()).add("Address", address())
                .add("CandidateAddressList", hasCandidateAddressList() ? candidateAddressList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValidationResult":
            return Optional.ofNullable(clazz.cast(validationResult()));
        case "AddressExternalId":
            return Optional.ofNullable(clazz.cast(addressExternalId()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "CandidateAddressList":
            return Optional.ofNullable(clazz.cast(candidateAddressList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValidationResult", VALIDATION_RESULT_FIELD);
        map.put("AddressExternalId", ADDRESS_EXTERNAL_ID_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("CandidateAddressList", CANDIDATE_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidateE911AddressResponse, T> g) {
        return obj -> g.apply((ValidateE911AddressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ValidateE911AddressResponse> {
        /**
         * <p>
         * Number indicating the result of address validation. <code>0</code> means the address was perfect as is and
         * successfully validated. <code>1</code> means the address was corrected. <code>2</code> means the address sent
         * was not close enough and was not validated.
         * </p>
         * 
         * @param validationResult
         *        Number indicating the result of address validation. <code>0</code> means the address was perfect as is
         *        and successfully validated. <code>1</code> means the address was corrected. <code>2</code> means the
         *        address sent was not close enough and was not validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationResult(Integer validationResult);

        /**
         * <p>
         * The ID that represents the address.
         * </p>
         * 
         * @param addressExternalId
         *        The ID that represents the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressExternalId(String addressExternalId);

        /**
         * <p>
         * The validated address.
         * </p>
         * 
         * @param address
         *        The validated address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * The validated address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * The list of address suggestions.
         * </p>
         * 
         * @param candidateAddressList
         *        The list of address suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateAddressList(Collection<CandidateAddress> candidateAddressList);

        /**
         * <p>
         * The list of address suggestions.
         * </p>
         * 
         * @param candidateAddressList
         *        The list of address suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateAddressList(CandidateAddress... candidateAddressList);

        /**
         * <p>
         * The list of address suggestions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chime.model.CandidateAddress.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.chime.model.CandidateAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chime.model.CandidateAddress.Builder#build()} is called immediately
         * and its result is passed to {@link #candidateAddressList(List<CandidateAddress>)}.
         * 
         * @param candidateAddressList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chime.model.CandidateAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateAddressList(java.util.Collection<CandidateAddress>)
         */
        Builder candidateAddressList(Consumer<CandidateAddress.Builder>... candidateAddressList);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private Integer validationResult;

        private String addressExternalId;

        private Address address;

        private List<CandidateAddress> candidateAddressList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateE911AddressResponse model) {
            super(model);
            validationResult(model.validationResult);
            addressExternalId(model.addressExternalId);
            address(model.address);
            candidateAddressList(model.candidateAddressList);
        }

        public final Integer getValidationResult() {
            return validationResult;
        }

        public final void setValidationResult(Integer validationResult) {
            this.validationResult = validationResult;
        }

        @Override
        public final Builder validationResult(Integer validationResult) {
            this.validationResult = validationResult;
            return this;
        }

        public final String getAddressExternalId() {
            return addressExternalId;
        }

        public final void setAddressExternalId(String addressExternalId) {
            this.addressExternalId = addressExternalId;
        }

        @Override
        public final Builder addressExternalId(String addressExternalId) {
            this.addressExternalId = addressExternalId;
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final List<CandidateAddress.Builder> getCandidateAddressList() {
            List<CandidateAddress.Builder> result = CandidateAddressListCopier.copyToBuilder(this.candidateAddressList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCandidateAddressList(Collection<CandidateAddress.BuilderImpl> candidateAddressList) {
            this.candidateAddressList = CandidateAddressListCopier.copyFromBuilder(candidateAddressList);
        }

        @Override
        public final Builder candidateAddressList(Collection<CandidateAddress> candidateAddressList) {
            this.candidateAddressList = CandidateAddressListCopier.copy(candidateAddressList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateAddressList(CandidateAddress... candidateAddressList) {
            candidateAddressList(Arrays.asList(candidateAddressList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateAddressList(Consumer<CandidateAddress.Builder>... candidateAddressList) {
            candidateAddressList(Stream.of(candidateAddressList).map(c -> CandidateAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValidateE911AddressResponse build() {
            return new ValidateE911AddressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
