/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A phone number for which an order has been placed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrderedPhoneNumber implements SdkPojo, Serializable,
        ToCopyableBuilder<OrderedPhoneNumber.Builder, OrderedPhoneNumber> {
    private static final SdkField<String> E164_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("E164PhoneNumber").getter(getter(OrderedPhoneNumber::e164PhoneNumber))
            .setter(setter(Builder::e164PhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OrderedPhoneNumber::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBER_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String e164PhoneNumber;

    private final String status;

    private OrderedPhoneNumber(BuilderImpl builder) {
        this.e164PhoneNumber = builder.e164PhoneNumber;
        this.status = builder.status;
    }

    /**
     * <p>
     * The phone number, in E.164 format.
     * </p>
     * 
     * @return The phone number, in E.164 format.
     */
    public final String e164PhoneNumber() {
        return e164PhoneNumber;
    }

    /**
     * <p>
     * The phone number status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrderedPhoneNumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The phone number status.
     * @see OrderedPhoneNumberStatus
     */
    public final OrderedPhoneNumberStatus status() {
        return OrderedPhoneNumberStatus.fromValue(status);
    }

    /**
     * <p>
     * The phone number status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrderedPhoneNumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The phone number status.
     * @see OrderedPhoneNumberStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(e164PhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderedPhoneNumber)) {
            return false;
        }
        OrderedPhoneNumber other = (OrderedPhoneNumber) obj;
        return Objects.equals(e164PhoneNumber(), other.e164PhoneNumber())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrderedPhoneNumber")
                .add("E164PhoneNumber", e164PhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "E164PhoneNumber":
            return Optional.ofNullable(clazz.cast(e164PhoneNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("E164PhoneNumber", E164_PHONE_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrderedPhoneNumber, T> g) {
        return obj -> g.apply((OrderedPhoneNumber) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrderedPhoneNumber> {
        /**
         * <p>
         * The phone number, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumber
         *        The phone number, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumber(String e164PhoneNumber);

        /**
         * <p>
         * The phone number status.
         * </p>
         * 
         * @param status
         *        The phone number status.
         * @see OrderedPhoneNumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderedPhoneNumberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The phone number status.
         * </p>
         * 
         * @param status
         *        The phone number status.
         * @see OrderedPhoneNumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderedPhoneNumberStatus
         */
        Builder status(OrderedPhoneNumberStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String e164PhoneNumber;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderedPhoneNumber model) {
            e164PhoneNumber(model.e164PhoneNumber);
            status(model.status);
        }

        public final String getE164PhoneNumber() {
            return e164PhoneNumber;
        }

        public final void setE164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
        }

        @Override
        public final Builder e164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrderedPhoneNumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public OrderedPhoneNumber build() {
            return new OrderedPhoneNumber(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
