/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the details of an <code>AppInstanceAdmin</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceAdminSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AppInstanceAdminSummary.Builder, AppInstanceAdminSummary> {
    private static final SdkField<Identity> ADMIN_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("Admin").getter(getter(AppInstanceAdminSummary::admin)).setter(setter(Builder::admin))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Admin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Identity admin;

    private AppInstanceAdminSummary(BuilderImpl builder) {
        this.admin = builder.admin;
    }

    /**
     * <p>
     * The details of the <code>AppInstanceAdmin</code>.
     * </p>
     * 
     * @return The details of the <code>AppInstanceAdmin</code>.
     */
    public final Identity admin() {
        return admin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(admin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceAdminSummary)) {
            return false;
        }
        AppInstanceAdminSummary other = (AppInstanceAdminSummary) obj;
        return Objects.equals(admin(), other.admin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceAdminSummary").add("Admin", admin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Admin":
            return Optional.ofNullable(clazz.cast(admin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceAdminSummary, T> g) {
        return obj -> g.apply((AppInstanceAdminSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceAdminSummary> {
        /**
         * <p>
         * The details of the <code>AppInstanceAdmin</code>.
         * </p>
         * 
         * @param admin
         *        The details of the <code>AppInstanceAdmin</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admin(Identity admin);

        /**
         * <p>
         * The details of the <code>AppInstanceAdmin</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #admin(Identity)}.
         * 
         * @param admin
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #admin(Identity)
         */
        default Builder admin(Consumer<Identity.Builder> admin) {
            return admin(Identity.builder().applyMutation(admin).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Identity admin;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceAdminSummary model) {
            admin(model.admin);
        }

        public final Identity.Builder getAdmin() {
            return admin != null ? admin.toBuilder() : null;
        }

        public final void setAdmin(Identity.BuilderImpl admin) {
            this.admin = admin != null ? admin.build() : null;
        }

        @Override
        public final Builder admin(Identity admin) {
            this.admin = admin;
            return this;
        }

        @Override
        public AppInstanceAdminSummary build() {
            return new AppInstanceAdminSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
