/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppInstanceResponse extends ChimeSdkIdentityResponse implements
        ToCopyableBuilder<DescribeAppInstanceResponse.Builder, DescribeAppInstanceResponse> {
    private static final SdkField<AppInstance> APP_INSTANCE_FIELD = SdkField.<AppInstance> builder(MarshallingType.SDK_POJO)
            .memberName("AppInstance").getter(getter(DescribeAppInstanceResponse::appInstance))
            .setter(setter(Builder::appInstance)).constructor(AppInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_FIELD));

    private final AppInstance appInstance;

    private DescribeAppInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.appInstance = builder.appInstance;
    }

    /**
     * <p>
     * The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All
     * timestamps use epoch milliseconds.
     * </p>
     * 
     * @return The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All
     *         timestamps use epoch milliseconds.
     */
    public final AppInstance appInstance() {
        return appInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppInstanceResponse)) {
            return false;
        }
        DescribeAppInstanceResponse other = (DescribeAppInstanceResponse) obj;
        return Objects.equals(appInstance(), other.appInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppInstanceResponse").add("AppInstance", appInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstance":
            return Optional.ofNullable(clazz.cast(appInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppInstanceResponse, T> g) {
        return obj -> g.apply((DescribeAppInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppInstanceResponse> {
        /**
         * <p>
         * The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All
         * timestamps use epoch milliseconds.
         * </p>
         * 
         * @param appInstance
         *        The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>.
         *        All timestamps use epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstance(AppInstance appInstance);

        /**
         * <p>
         * The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All
         * timestamps use epoch milliseconds.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppInstance.Builder} avoiding the need to
         * create one manually via {@link AppInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppInstance.Builder#build()} is called immediately and its result
         * is passed to {@link #appInstance(AppInstance)}.
         * 
         * @param appInstance
         *        a consumer that will call methods on {@link AppInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstance(AppInstance)
         */
        default Builder appInstance(Consumer<AppInstance.Builder> appInstance) {
            return appInstance(AppInstance.builder().applyMutation(appInstance).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkIdentityResponse.BuilderImpl implements Builder {
        private AppInstance appInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppInstanceResponse model) {
            super(model);
            appInstance(model.appInstance);
        }

        public final AppInstance.Builder getAppInstance() {
            return appInstance != null ? appInstance.toBuilder() : null;
        }

        public final void setAppInstance(AppInstance.BuilderImpl appInstance) {
            this.appInstance = appInstance != null ? appInstance.build() : null;
        }

        @Override
        public final Builder appInstance(AppInstance appInstance) {
            this.appInstance = appInstance;
            return this;
        }

        @Override
        public DescribeAppInstanceResponse build() {
            return new DescribeAppInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
