/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppInstanceUserEndpointRequest extends ChimeSdkIdentityRequest implements
        ToCopyableBuilder<UpdateAppInstanceUserEndpointRequest.Builder, UpdateAppInstanceUserEndpointRequest> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceUserArn").getter(getter(UpdateAppInstanceUserEndpointRequest::appInstanceUserArn))
            .setter(setter(Builder::appInstanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceUserArn").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(UpdateAppInstanceUserEndpointRequest::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAppInstanceUserEndpointRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ALLOW_MESSAGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowMessages").getter(getter(UpdateAppInstanceUserEndpointRequest::allowMessagesAsString))
            .setter(setter(Builder::allowMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMessages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD,
            ENDPOINT_ID_FIELD, NAME_FIELD, ALLOW_MESSAGES_FIELD));

    private final String appInstanceUserArn;

    private final String endpointId;

    private final String name;

    private final String allowMessages;

    private UpdateAppInstanceUserEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.endpointId = builder.endpointId;
        this.name = builder.name;
        this.allowMessages = builder.allowMessages;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code>.
     */
    public final String appInstanceUserArn() {
        return appInstanceUserArn;
    }

    /**
     * <p>
     * The unique identifier of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * 
     * @return The unique identifier of the <code>AppInstanceUserEndpoint</code>.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The name of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>AppInstanceUserEndpoint</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will
     * receive no messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allowMessages}
     * will return {@link AllowMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #allowMessagesAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     *         <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the
     *         endpoint will receive no messages.
     * @see AllowMessages
     */
    public final AllowMessages allowMessages() {
        return AllowMessages.fromValue(allowMessages);
    }

    /**
     * <p>
     * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will
     * receive no messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allowMessages}
     * will return {@link AllowMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #allowMessagesAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     *         <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the
     *         endpoint will receive no messages.
     * @see AllowMessages
     */
    public final String allowMessagesAsString() {
        return allowMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(allowMessagesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppInstanceUserEndpointRequest)) {
            return false;
        }
        UpdateAppInstanceUserEndpointRequest other = (UpdateAppInstanceUserEndpointRequest) obj;
        return Objects.equals(appInstanceUserArn(), other.appInstanceUserArn())
                && Objects.equals(endpointId(), other.endpointId()) && Objects.equals(name(), other.name())
                && Objects.equals(allowMessagesAsString(), other.allowMessagesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppInstanceUserEndpointRequest")
                .add("AppInstanceUserArn", appInstanceUserArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EndpointId", endpointId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AllowMessages", allowMessagesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUserArn":
            return Optional.ofNullable(clazz.cast(appInstanceUserArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AllowMessages":
            return Optional.ofNullable(clazz.cast(allowMessagesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppInstanceUserEndpointRequest, T> g) {
        return obj -> g.apply((UpdateAppInstanceUserEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAppInstanceUserEndpointRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUserArn
         *        The ARN of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserArn(String appInstanceUserArn);

        /**
         * <p>
         * The unique identifier of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param endpointId
         *        The unique identifier of the <code>AppInstanceUserEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The name of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>AppInstanceUserEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
         * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint
         * will receive no messages.
         * </p>
         * 
         * @param allowMessages
         *        Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive
         *        messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code>
         *        indicates the endpoint will receive no messages.
         * @see AllowMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowMessages
         */
        Builder allowMessages(String allowMessages);

        /**
         * <p>
         * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
         * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint
         * will receive no messages.
         * </p>
         * 
         * @param allowMessages
         *        Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive
         *        messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code>
         *        indicates the endpoint will receive no messages.
         * @see AllowMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowMessages
         */
        Builder allowMessages(AllowMessages allowMessages);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkIdentityRequest.BuilderImpl implements Builder {
        private String appInstanceUserArn;

        private String endpointId;

        private String name;

        private String allowMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppInstanceUserEndpointRequest model) {
            super(model);
            appInstanceUserArn(model.appInstanceUserArn);
            endpointId(model.endpointId);
            name(model.name);
            allowMessages(model.allowMessages);
        }

        public final String getAppInstanceUserArn() {
            return appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAllowMessages() {
            return allowMessages;
        }

        public final void setAllowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
        }

        @Override
        public final Builder allowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
            return this;
        }

        @Override
        public final Builder allowMessages(AllowMessages allowMessages) {
            this.allowMessages(allowMessages == null ? null : allowMessages.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppInstanceUserEndpointRequest build() {
            return new UpdateAppInstanceUserEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
