/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.chimesdkidentity.model.BadRequestException;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityException;
import software.amazon.awssdk.services.chimesdkidentity.model.ConflictException;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ForbiddenException;
import software.amazon.awssdk.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chimesdkidentity.model.ServiceFailureException;
import software.amazon.awssdk.services.chimesdkidentity.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chimesdkidentity.model.ThrottledClientException;
import software.amazon.awssdk.services.chimesdkidentity.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable;
import software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable;
import software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable;

/**
 * Service client for accessing Amazon Chime SDK Identity. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The Amazon Chime SDK Identity APIs in this section allow software developers to create and manage unique instances of
 * their messaging applications. These APIs provide the overarching framework for creating and sending messages. For
 * more information about the identity APIs, refer to .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ChimeSdkIdentityClient extends SdkClient {
    String SERVICE_NAME = "chime";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "identity-chime";

    /**
     * Create a {@link ChimeSdkIdentityClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ChimeSdkIdentityClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ChimeSdkIdentityClient}.
     */
    static ChimeSdkIdentityClientBuilder builder() {
        return new DefaultChimeSdkIdentityClientBuilder();
    }

    /**
     * <p>
     * Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers
     * use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.
     * </p>
     * <p>
     * identity
     * </p>
     *
     * @param createAppInstanceRequest
     * @return Result of the CreateAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppInstanceResponse createAppInstance(CreateAppInstanceRequest createAppInstanceRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers
     * use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.
     * </p>
     * <p>
     * identity
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAppInstanceRequest#builder()}
     * </p>
     *
     * @param createAppInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppInstanceRequest.Builder} to create a request.
     * @return Result of the CreateAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppInstanceResponse createAppInstance(Consumer<CreateAppInstanceRequest.Builder> createAppInstanceRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return createAppInstance(CreateAppInstanceRequest.builder().applyMutation(createAppInstanceRequest).build());
    }

    /**
     * <p>
     * Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the
     * following actions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteChannelMessage</code> actions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.
     * </p>
     *
     * @param createAppInstanceAdminRequest
     * @return Result of the CreateAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppInstanceAdminResponse createAppInstanceAdmin(CreateAppInstanceAdminRequest createAppInstanceAdminRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the
     * following actions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteChannelMessage</code> actions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppInstanceAdminRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAppInstanceAdminRequest#builder()}
     * </p>
     *
     * @param createAppInstanceAdminRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppInstanceAdminRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppInstanceAdminResponse createAppInstanceAdmin(
            Consumer<CreateAppInstanceAdminRequest.Builder> createAppInstanceAdminRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        return createAppInstanceAdmin(CreateAppInstanceAdminRequest.builder().applyMutation(createAppInstanceAdminRequest)
                .build());
    }

    /**
     * <p>
     * Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique
     * <code>appInstanceUserId</code> and <code>Name</code> for that user.
     * </p>
     *
     * @param createAppInstanceUserRequest
     * @return Result of the CreateAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppInstanceUserResponse createAppInstanceUser(CreateAppInstanceUserRequest createAppInstanceUserRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique
     * <code>appInstanceUserId</code> and <code>Name</code> for that user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppInstanceUserRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAppInstanceUserRequest#builder()}
     * </p>
     *
     * @param createAppInstanceUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppInstanceUserRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppInstanceUserResponse createAppInstanceUser(
            Consumer<CreateAppInstanceUserRequest.Builder> createAppInstanceUserRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        return createAppInstanceUser(CreateAppInstanceUserRequest.builder().applyMutation(createAppInstanceUserRequest).build());
    }

    /**
     * <p>
     * Deletes an <code>AppInstance</code> and all associated data asynchronously.
     * </p>
     *
     * @param deleteAppInstanceRequest
     * @return Result of the DeleteAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppInstanceResponse deleteAppInstance(DeleteAppInstanceRequest deleteAppInstanceRequest)
            throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <code>AppInstance</code> and all associated data asynchronously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAppInstanceRequest#builder()}
     * </p>
     *
     * @param deleteAppInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppInstanceRequest.Builder} to create a request.
     * @return Result of the DeleteAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppInstanceResponse deleteAppInstance(Consumer<DeleteAppInstanceRequest.Builder> deleteAppInstanceRequest)
            throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        return deleteAppInstance(DeleteAppInstanceRequest.builder().applyMutation(deleteAppInstanceRequest).build());
    }

    /**
     * <p>
     * Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the
     * user.
     * </p>
     *
     * @param deleteAppInstanceAdminRequest
     * @return Result of the DeleteAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppInstanceAdminResponse deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest deleteAppInstanceAdminRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the
     * user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppInstanceAdminRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAppInstanceAdminRequest#builder()}
     * </p>
     *
     * @param deleteAppInstanceAdminRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppInstanceAdminRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppInstanceAdminResponse deleteAppInstanceAdmin(
            Consumer<DeleteAppInstanceAdminRequest.Builder> deleteAppInstanceAdminRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        return deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest.builder().applyMutation(deleteAppInstanceAdminRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an <code>AppInstanceUser</code>.
     * </p>
     *
     * @param deleteAppInstanceUserRequest
     * @return Result of the DeleteAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppInstanceUserResponse deleteAppInstanceUser(DeleteAppInstanceUserRequest deleteAppInstanceUserRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <code>AppInstanceUser</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppInstanceUserRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAppInstanceUserRequest#builder()}
     * </p>
     *
     * @param deleteAppInstanceUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppInstanceUserRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppInstanceUserResponse deleteAppInstanceUser(
            Consumer<DeleteAppInstanceUserRequest.Builder> deleteAppInstanceUserRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        return deleteAppInstanceUser(DeleteAppInstanceUserRequest.builder().applyMutation(deleteAppInstanceUserRequest).build());
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstance</code>.
     * </p>
     *
     * @param describeAppInstanceRequest
     * @return Result of the DescribeAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppInstanceResponse describeAppInstance(DescribeAppInstanceRequest describeAppInstanceRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAppInstanceRequest#builder()}
     * </p>
     *
     * @param describeAppInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppInstanceResponse describeAppInstance(
            Consumer<DescribeAppInstanceRequest.Builder> describeAppInstanceRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return describeAppInstance(DescribeAppInstanceRequest.builder().applyMutation(describeAppInstanceRequest).build());
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstanceAdmin</code>.
     * </p>
     *
     * @param describeAppInstanceAdminRequest
     * @return Result of the DescribeAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppInstanceAdminResponse describeAppInstanceAdmin(
            DescribeAppInstanceAdminRequest describeAppInstanceAdminRequest) throws BadRequestException, ForbiddenException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstanceAdmin</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppInstanceAdminRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAppInstanceAdminRequest#builder()}
     * </p>
     *
     * @param describeAppInstanceAdminRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppInstanceAdminRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppInstanceAdminResponse describeAppInstanceAdmin(
            Consumer<DescribeAppInstanceAdminRequest.Builder> describeAppInstanceAdminRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return describeAppInstanceAdmin(DescribeAppInstanceAdminRequest.builder().applyMutation(describeAppInstanceAdminRequest)
                .build());
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstanceUser</code>.
     * </p>
     *
     * @param describeAppInstanceUserRequest
     * @return Result of the DescribeAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppInstanceUserResponse describeAppInstanceUser(DescribeAppInstanceUserRequest describeAppInstanceUserRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstanceUser</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppInstanceUserRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAppInstanceUserRequest#builder()}
     * </p>
     *
     * @param describeAppInstanceUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppInstanceUserRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppInstanceUserResponse describeAppInstanceUser(
            Consumer<DescribeAppInstanceUserRequest.Builder> describeAppInstanceUserRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return describeAppInstanceUser(DescribeAppInstanceUserRequest.builder().applyMutation(describeAppInstanceUserRequest)
                .build());
    }

    /**
     * <p>
     * Gets the retention settings for an <code>AppInstance</code>.
     * </p>
     *
     * @param getAppInstanceRetentionSettingsRequest
     * @return Result of the GetAppInstanceRetentionSettings operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.GetAppInstanceRetentionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/GetAppInstanceRetentionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAppInstanceRetentionSettingsResponse getAppInstanceRetentionSettings(
            GetAppInstanceRetentionSettingsRequest getAppInstanceRetentionSettingsRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the retention settings for an <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppInstanceRetentionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetAppInstanceRetentionSettingsRequest#builder()}
     * </p>
     *
     * @param getAppInstanceRetentionSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetAppInstanceRetentionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the GetAppInstanceRetentionSettings operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.GetAppInstanceRetentionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/GetAppInstanceRetentionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAppInstanceRetentionSettingsResponse getAppInstanceRetentionSettings(
            Consumer<GetAppInstanceRetentionSettingsRequest.Builder> getAppInstanceRetentionSettingsRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        return getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest.builder()
                .applyMutation(getAppInstanceRetentionSettingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the administrators in the <code>AppInstance</code>.
     * </p>
     *
     * @param listAppInstanceAdminsRequest
     * @return Result of the ListAppInstanceAdmins operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceAdmins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceAdminsResponse listAppInstanceAdmins(ListAppInstanceAdminsRequest listAppInstanceAdminsRequest)
            throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the administrators in the <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppInstanceAdminsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppInstanceAdminsRequest#builder()}
     * </p>
     *
     * @param listAppInstanceAdminsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppInstanceAdminsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAppInstanceAdmins operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceAdmins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceAdminsResponse listAppInstanceAdmins(
            Consumer<ListAppInstanceAdminsRequest.Builder> listAppInstanceAdminsRequest) throws BadRequestException,
            ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        return listAppInstanceAdmins(ListAppInstanceAdminsRequest.builder().applyMutation(listAppInstanceAdminsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the administrators in the <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppInstanceAdmins(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable responses = client.listAppInstanceAdminsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable responses = client
     *             .listAppInstanceAdminsPaginator(request);
     *     for (software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable responses = client.listAppInstanceAdminsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppInstanceAdmins(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppInstanceAdminsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceAdmins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceAdminsIterable listAppInstanceAdminsPaginator(ListAppInstanceAdminsRequest listAppInstanceAdminsRequest)
            throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the administrators in the <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppInstanceAdmins(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable responses = client.listAppInstanceAdminsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable responses = client
     *             .listAppInstanceAdminsPaginator(request);
     *     for (software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable responses = client.listAppInstanceAdminsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppInstanceAdmins(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppInstanceAdminsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppInstanceAdminsRequest#builder()}
     * </p>
     *
     * @param listAppInstanceAdminsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppInstanceAdminsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceAdmins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceAdminsIterable listAppInstanceAdminsPaginator(
            Consumer<ListAppInstanceAdminsRequest.Builder> listAppInstanceAdminsRequest) throws BadRequestException,
            ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        return listAppInstanceAdminsPaginator(ListAppInstanceAdminsRequest.builder().applyMutation(listAppInstanceAdminsRequest)
                .build());
    }

    /**
     * <p>
     * List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.
     * </p>
     *
     * @param listAppInstanceUsersRequest
     * @return Result of the ListAppInstanceUsers operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceUsersResponse listAppInstanceUsers(ListAppInstanceUsersRequest listAppInstanceUsersRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppInstanceUsersRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppInstanceUsersRequest#builder()}
     * </p>
     *
     * @param listAppInstanceUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListAppInstanceUsersRequest.Builder} to create a
     *        request.
     * @return Result of the ListAppInstanceUsers operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceUsersResponse listAppInstanceUsers(
            Consumer<ListAppInstanceUsersRequest.Builder> listAppInstanceUsersRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return listAppInstanceUsers(ListAppInstanceUsersRequest.builder().applyMutation(listAppInstanceUsersRequest).build());
    }

    /**
     * <p>
     * List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppInstanceUsers(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable responses = client.listAppInstanceUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable responses = client
     *             .listAppInstanceUsersPaginator(request);
     *     for (software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable responses = client.listAppInstanceUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppInstanceUsers(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppInstanceUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceUsersIterable listAppInstanceUsersPaginator(ListAppInstanceUsersRequest listAppInstanceUsersRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppInstanceUsers(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable responses = client.listAppInstanceUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable responses = client
     *             .listAppInstanceUsersPaginator(request);
     *     for (software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable responses = client.listAppInstanceUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppInstanceUsers(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppInstanceUsersRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppInstanceUsersRequest#builder()}
     * </p>
     *
     * @param listAppInstanceUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListAppInstanceUsersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstanceUsersIterable listAppInstanceUsersPaginator(
            Consumer<ListAppInstanceUsersRequest.Builder> listAppInstanceUsersRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return listAppInstanceUsersPaginator(ListAppInstanceUsersRequest.builder().applyMutation(listAppInstanceUsersRequest)
                .build());
    }

    /**
     * <p>
     * Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.
     * </p>
     *
     * @param listAppInstancesRequest
     * @return Result of the ListAppInstances operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstancesResponse listAppInstances(ListAppInstancesRequest listAppInstancesRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAppInstancesRequest#builder()}
     * </p>
     *
     * @param listAppInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListAppInstancesRequest.Builder} to create a request.
     * @return Result of the ListAppInstances operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstancesResponse listAppInstances(Consumer<ListAppInstancesRequest.Builder> listAppInstancesRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        return listAppInstances(ListAppInstancesRequest.builder().applyMutation(listAppInstancesRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppInstances(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable responses = client.listAppInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable responses = client
     *             .listAppInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable responses = client.listAppInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppInstances(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstancesIterable listAppInstancesPaginator(ListAppInstancesRequest listAppInstancesRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppInstances(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable responses = client.listAppInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable responses = client
     *             .listAppInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable responses = client.listAppInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppInstances(software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAppInstancesRequest#builder()}
     * </p>
     *
     * @param listAppInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListAppInstancesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppInstancesIterable listAppInstancesPaginator(Consumer<ListAppInstancesRequest.Builder> listAppInstancesRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        return listAppInstancesPaginator(ListAppInstancesRequest.builder().applyMutation(listAppInstancesRequest).build());
    }

    /**
     * <p>
     * Sets the amount of time in days that a given <code>AppInstance</code> retains data.
     * </p>
     *
     * @param putAppInstanceRetentionSettingsRequest
     * @return Result of the PutAppInstanceRetentionSettings operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.PutAppInstanceRetentionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceRetentionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAppInstanceRetentionSettingsResponse putAppInstanceRetentionSettings(
            PutAppInstanceRetentionSettingsRequest putAppInstanceRetentionSettingsRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the amount of time in days that a given <code>AppInstance</code> retains data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAppInstanceRetentionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link PutAppInstanceRetentionSettingsRequest#builder()}
     * </p>
     *
     * @param putAppInstanceRetentionSettingsRequest
     *        A {@link Consumer} that will call methods on {@link PutAppInstanceRetentionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the PutAppInstanceRetentionSettings operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.PutAppInstanceRetentionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceRetentionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAppInstanceRetentionSettingsResponse putAppInstanceRetentionSettings(
            Consumer<PutAppInstanceRetentionSettingsRequest.Builder> putAppInstanceRetentionSettingsRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        return putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest.builder()
                .applyMutation(putAppInstanceRetentionSettingsRequest).build());
    }

    /**
     * <p>
     * Updates <code>AppInstance</code> metadata.
     * </p>
     *
     * @param updateAppInstanceRequest
     * @return Result of the UpdateAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAppInstanceResponse updateAppInstance(UpdateAppInstanceRequest updateAppInstanceRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates <code>AppInstance</code> metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAppInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAppInstanceRequest#builder()}
     * </p>
     *
     * @param updateAppInstanceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAppInstanceRequest.Builder} to create a request.
     * @return Result of the UpdateAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAppInstanceResponse updateAppInstance(Consumer<UpdateAppInstanceRequest.Builder> updateAppInstanceRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        return updateAppInstance(UpdateAppInstanceRequest.builder().applyMutation(updateAppInstanceRequest).build());
    }

    /**
     * <p>
     * Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.
     * </p>
     *
     * @param updateAppInstanceUserRequest
     * @return Result of the UpdateAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAppInstanceUserResponse updateAppInstanceUser(UpdateAppInstanceUserRequest updateAppInstanceUserRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAppInstanceUserRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAppInstanceUserRequest#builder()}
     * </p>
     *
     * @param updateAppInstanceUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAppInstanceUserRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAppInstanceUserResponse updateAppInstanceUser(
            Consumer<UpdateAppInstanceUserRequest.Builder> updateAppInstanceUserRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        return updateAppInstanceUser(UpdateAppInstanceUserRequest.builder().applyMutation(updateAppInstanceUserRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
