/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an <code>AppInstanceAdmin</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceAdmin implements SdkPojo, Serializable,
        ToCopyableBuilder<AppInstanceAdmin.Builder, AppInstanceAdmin> {
    private static final SdkField<Identity> ADMIN_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("Admin").getter(getter(AppInstanceAdmin::admin)).setter(setter(Builder::admin))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Admin").build()).build();

    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(AppInstanceAdmin::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(AppInstanceAdmin::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_FIELD,
            APP_INSTANCE_ARN_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Identity admin;

    private final String appInstanceArn;

    private final Instant createdTimestamp;

    private AppInstanceAdmin(BuilderImpl builder) {
        this.admin = builder.admin;
        this.appInstanceArn = builder.appInstanceArn;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The <code>AppInstanceAdmin</code> data.
     * </p>
     * 
     * @return The <code>AppInstanceAdmin</code> data.
     */
    public final Identity admin() {
        return admin;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code> for which the user is an administrator.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code> for which the user is an administrator.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * <p>
     * The time at which an administrator was created.
     * </p>
     * 
     * @return The time at which an administrator was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(admin());
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceAdmin)) {
            return false;
        }
        AppInstanceAdmin other = (AppInstanceAdmin) obj;
        return Objects.equals(admin(), other.admin()) && Objects.equals(appInstanceArn(), other.appInstanceArn())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceAdmin").add("Admin", admin()).add("AppInstanceArn", appInstanceArn())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Admin":
            return Optional.ofNullable(clazz.cast(admin()));
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceAdmin, T> g) {
        return obj -> g.apply((AppInstanceAdmin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceAdmin> {
        /**
         * <p>
         * The <code>AppInstanceAdmin</code> data.
         * </p>
         * 
         * @param admin
         *        The <code>AppInstanceAdmin</code> data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admin(Identity admin);

        /**
         * <p>
         * The <code>AppInstanceAdmin</code> data.
         * </p>
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #admin(Identity)}.
         * 
         * @param admin
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #admin(Identity)
         */
        default Builder admin(Consumer<Identity.Builder> admin) {
            return admin(Identity.builder().applyMutation(admin).build());
        }

        /**
         * <p>
         * The ARN of the <code>AppInstance</code> for which the user is an administrator.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the <code>AppInstance</code> for which the user is an administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The time at which an administrator was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which an administrator was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Identity admin;

        private String appInstanceArn;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceAdmin model) {
            admin(model.admin);
            appInstanceArn(model.appInstanceArn);
            createdTimestamp(model.createdTimestamp);
        }

        public final Identity.Builder getAdmin() {
            return admin != null ? admin.toBuilder() : null;
        }

        public final void setAdmin(Identity.BuilderImpl admin) {
            this.admin = admin != null ? admin.build() : null;
        }

        @Override
        @Transient
        public final Builder admin(Identity admin) {
            this.admin = admin;
            return this;
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        @Transient
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        @Transient
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public AppInstanceAdmin build() {
            return new AppInstanceAdmin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
