/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When
 * <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When INACTIVE,
 * the corresponding reason will be conveyed through EndpointStatusReason.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due
 * to invalid device token
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due
 * to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointState implements SdkPojo, Serializable, ToCopyableBuilder<EndpointState.Builder, EndpointState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EndpointState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(EndpointState::statusReasonAsString)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusReason;

    private EndpointState(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
     * @see EndpointStatus
     */
    public final EndpointStatus status() {
        return EndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
     * @see EndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the <code>EndpointStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link EndpointStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the <code>EndpointStatus</code>.
     * @see EndpointStatusReason
     */
    public final EndpointStatusReason statusReason() {
        return EndpointStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * The reason for the <code>EndpointStatus</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link EndpointStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the <code>EndpointStatus</code>.
     * @see EndpointStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointState)) {
            return false;
        }
        EndpointState other = (EndpointState) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointState").add("Status", statusAsString()).add("StatusReason", statusReasonAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointState, T> g) {
        return obj -> g.apply((EndpointState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointState> {
        /**
         * <p>
         * Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param status
         *        Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param status
         *        Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(EndpointStatus status);

        /**
         * <p>
         * The reason for the <code>EndpointStatus</code>.
         * </p>
         * 
         * @param statusReason
         *        The reason for the <code>EndpointStatus</code>.
         * @see EndpointStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The reason for the <code>EndpointStatus</code>.
         * </p>
         * 
         * @param statusReason
         *        The reason for the <code>EndpointStatus</code>.
         * @see EndpointStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatusReason
         */
        Builder statusReason(EndpointStatusReason statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointState model) {
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        @Transient
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        @Transient
        public final Builder statusReason(EndpointStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        @Override
        public EndpointState build() {
            return new EndpointState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
