/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAppInstanceUserEndpointRequest extends ChimeSdkIdentityRequest implements
        ToCopyableBuilder<RegisterAppInstanceUserEndpointRequest.Builder, RegisterAppInstanceUserEndpointRequest> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceUserArn").getter(getter(RegisterAppInstanceUserEndpointRequest::appInstanceUserArn))
            .setter(setter(Builder::appInstanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceUserArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RegisterAppInstanceUserEndpointRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RegisterAppInstanceUserEndpointRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(RegisterAppInstanceUserEndpointRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<EndpointAttributes> ENDPOINT_ATTRIBUTES_FIELD = SdkField
            .<EndpointAttributes> builder(MarshallingType.SDK_POJO).memberName("EndpointAttributes")
            .getter(getter(RegisterAppInstanceUserEndpointRequest::endpointAttributes))
            .setter(setter(Builder::endpointAttributes)).constructor(EndpointAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAttributes").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(RegisterAppInstanceUserEndpointRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ALLOW_MESSAGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowMessages").getter(getter(RegisterAppInstanceUserEndpointRequest::allowMessagesAsString))
            .setter(setter(Builder::allowMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMessages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD,
            NAME_FIELD, TYPE_FIELD, RESOURCE_ARN_FIELD, ENDPOINT_ATTRIBUTES_FIELD, CLIENT_REQUEST_TOKEN_FIELD,
            ALLOW_MESSAGES_FIELD));

    private final String appInstanceUserArn;

    private final String name;

    private final String type;

    private final String resourceArn;

    private final EndpointAttributes endpointAttributes;

    private final String clientRequestToken;

    private final String allowMessages;

    private RegisterAppInstanceUserEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.name = builder.name;
        this.type = builder.type;
        this.resourceArn = builder.resourceArn;
        this.endpointAttributes = builder.endpointAttributes;
        this.clientRequestToken = builder.clientRequestToken;
        this.allowMessages = builder.allowMessages;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code>.
     */
    public final String appInstanceUserArn() {
        return appInstanceUserArn;
    }

    /**
     * <p>
     * The name of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>AppInstanceUserEndpoint</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the <code>AppInstanceUserEndpoint</code>. Supported types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APNS</code>: The mobile notification service for an Apple device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GCM</code>: The mobile notification service for an Android device.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppInstanceUserEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APNS</code>: The mobile notification service for an Apple device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple
     *         device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GCM</code>: The mobile notification service for an Android device.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
     * @see AppInstanceUserEndpointType
     */
    public final AppInstanceUserEndpointType type() {
        return AppInstanceUserEndpointType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>AppInstanceUserEndpoint</code>. Supported types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APNS</code>: The mobile notification service for an Apple device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GCM</code>: The mobile notification service for an Android device.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppInstanceUserEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APNS</code>: The mobile notification service for an Apple device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple
     *         device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GCM</code>: The mobile notification service for an Android device.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
     * @see AppInstanceUserEndpointType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ARN of the resource to which the endpoint belongs.
     * </p>
     * 
     * @return The ARN of the resource to which the endpoint belongs.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The attributes of an <code>Endpoint</code>.
     * </p>
     * 
     * @return The attributes of an <code>Endpoint</code>.
     */
    public final EndpointAttributes endpointAttributes() {
        return endpointAttributes;
    }

    /**
     * <p>
     * The idempotency token for each client request.
     * </p>
     * 
     * @return The idempotency token for each client request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code>
     * indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allowMessages}
     * will return {@link AllowMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #allowMessagesAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages.
     *         <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint
     *         receives no messages.
     * @see AllowMessages
     */
    public final AllowMessages allowMessages() {
        return AllowMessages.fromValue(allowMessages);
    }

    /**
     * <p>
     * Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code>
     * indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allowMessages}
     * will return {@link AllowMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #allowMessagesAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages.
     *         <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint
     *         receives no messages.
     * @see AllowMessages
     */
    public final String allowMessagesAsString() {
        return allowMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(allowMessagesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAppInstanceUserEndpointRequest)) {
            return false;
        }
        RegisterAppInstanceUserEndpointRequest other = (RegisterAppInstanceUserEndpointRequest) obj;
        return Objects.equals(appInstanceUserArn(), other.appInstanceUserArn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(endpointAttributes(), other.endpointAttributes())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(allowMessagesAsString(), other.allowMessagesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAppInstanceUserEndpointRequest")
                .add("AppInstanceUserArn", appInstanceUserArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("ResourceArn", resourceArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EndpointAttributes", endpointAttributes())
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AllowMessages", allowMessagesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUserArn":
            return Optional.ofNullable(clazz.cast(appInstanceUserArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "EndpointAttributes":
            return Optional.ofNullable(clazz.cast(endpointAttributes()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "AllowMessages":
            return Optional.ofNullable(clazz.cast(allowMessagesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAppInstanceUserEndpointRequest, T> g) {
        return obj -> g.apply((RegisterAppInstanceUserEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterAppInstanceUserEndpointRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUserArn
         *        The ARN of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserArn(String appInstanceUserArn);

        /**
         * <p>
         * The name of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>AppInstanceUserEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the <code>AppInstanceUserEndpoint</code>. Supported types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APNS</code>: The mobile notification service for an Apple device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GCM</code>: The mobile notification service for an Android device.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APNS</code>: The mobile notification service for an Apple device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple
         *        device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GCM</code>: The mobile notification service for an Android device.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
         * @see AppInstanceUserEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceUserEndpointType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>AppInstanceUserEndpoint</code>. Supported types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APNS</code>: The mobile notification service for an Apple device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GCM</code>: The mobile notification service for an Android device.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APNS</code>: The mobile notification service for an Apple device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple
         *        device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GCM</code>: The mobile notification service for an Android device.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.
         * @see AppInstanceUserEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceUserEndpointType
         */
        Builder type(AppInstanceUserEndpointType type);

        /**
         * <p>
         * The ARN of the resource to which the endpoint belongs.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource to which the endpoint belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The attributes of an <code>Endpoint</code>.
         * </p>
         * 
         * @param endpointAttributes
         *        The attributes of an <code>Endpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAttributes(EndpointAttributes endpointAttributes);

        /**
         * <p>
         * The attributes of an <code>Endpoint</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointAttributes.Builder} avoiding the
         * need to create one manually via {@link EndpointAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointAttributes(EndpointAttributes)}.
         * 
         * @param endpointAttributes
         *        a consumer that will call methods on {@link EndpointAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointAttributes(EndpointAttributes)
         */
        default Builder endpointAttributes(Consumer<EndpointAttributes.Builder> endpointAttributes) {
            return endpointAttributes(EndpointAttributes.builder().applyMutation(endpointAttributes).build());
        }

        /**
         * <p>
         * The idempotency token for each client request.
         * </p>
         * 
         * @param clientRequestToken
         *        The idempotency token for each client request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code>
         * indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.
         * </p>
         * 
         * @param allowMessages
         *        Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages.
         *        <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the
         *        endpoint receives no messages.
         * @see AllowMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowMessages
         */
        Builder allowMessages(String allowMessages);

        /**
         * <p>
         * Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code>
         * indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.
         * </p>
         * 
         * @param allowMessages
         *        Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages.
         *        <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the
         *        endpoint receives no messages.
         * @see AllowMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowMessages
         */
        Builder allowMessages(AllowMessages allowMessages);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkIdentityRequest.BuilderImpl implements Builder {
        private String appInstanceUserArn;

        private String name;

        private String type;

        private String resourceArn;

        private EndpointAttributes endpointAttributes;

        private String clientRequestToken;

        private String allowMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAppInstanceUserEndpointRequest model) {
            super(model);
            appInstanceUserArn(model.appInstanceUserArn);
            name(model.name);
            type(model.type);
            resourceArn(model.resourceArn);
            endpointAttributes(model.endpointAttributes);
            clientRequestToken(model.clientRequestToken);
            allowMessages(model.allowMessages);
        }

        public final String getAppInstanceUserArn() {
            return appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppInstanceUserEndpointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final EndpointAttributes.Builder getEndpointAttributes() {
            return endpointAttributes != null ? endpointAttributes.toBuilder() : null;
        }

        public final void setEndpointAttributes(EndpointAttributes.BuilderImpl endpointAttributes) {
            this.endpointAttributes = endpointAttributes != null ? endpointAttributes.build() : null;
        }

        @Override
        public final Builder endpointAttributes(EndpointAttributes endpointAttributes) {
            this.endpointAttributes = endpointAttributes;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getAllowMessages() {
            return allowMessages;
        }

        public final void setAllowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
        }

        @Override
        public final Builder allowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
            return this;
        }

        @Override
        public final Builder allowMessages(AllowMessages allowMessages) {
            this.allowMessages(allowMessages == null ? null : allowMessages.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAppInstanceUserEndpointRequest build() {
            return new RegisterAppInstanceUserEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
