/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An endpoint under an Amazon Chime <code>AppInstanceUser</code> that receives messages for a user. For push
 * notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceUserEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<AppInstanceUserEndpoint.Builder, AppInstanceUserEndpoint> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceUserArn").getter(getter(AppInstanceUserEndpoint::appInstanceUserArn))
            .setter(setter(Builder::appInstanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUserArn").build())
            .build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(AppInstanceUserEndpoint::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AppInstanceUserEndpoint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AppInstanceUserEndpoint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(AppInstanceUserEndpoint::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<EndpointAttributes> ENDPOINT_ATTRIBUTES_FIELD = SdkField
            .<EndpointAttributes> builder(MarshallingType.SDK_POJO).memberName("EndpointAttributes")
            .getter(getter(AppInstanceUserEndpoint::endpointAttributes)).setter(setter(Builder::endpointAttributes))
            .constructor(EndpointAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAttributes").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(AppInstanceUserEndpoint::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(AppInstanceUserEndpoint::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> ALLOW_MESSAGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowMessages").getter(getter(AppInstanceUserEndpoint::allowMessagesAsString))
            .setter(setter(Builder::allowMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMessages").build()).build();

    private static final SdkField<EndpointState> ENDPOINT_STATE_FIELD = SdkField
            .<EndpointState> builder(MarshallingType.SDK_POJO).memberName("EndpointState")
            .getter(getter(AppInstanceUserEndpoint::endpointState)).setter(setter(Builder::endpointState))
            .constructor(EndpointState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD,
            ENDPOINT_ID_FIELD, NAME_FIELD, TYPE_FIELD, RESOURCE_ARN_FIELD, ENDPOINT_ATTRIBUTES_FIELD, CREATED_TIMESTAMP_FIELD,
            LAST_UPDATED_TIMESTAMP_FIELD, ALLOW_MESSAGES_FIELD, ENDPOINT_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appInstanceUserArn;

    private final String endpointId;

    private final String name;

    private final String type;

    private final String resourceArn;

    private final EndpointAttributes endpointAttributes;

    private final Instant createdTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final String allowMessages;

    private final EndpointState endpointState;

    private AppInstanceUserEndpoint(BuilderImpl builder) {
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.endpointId = builder.endpointId;
        this.name = builder.name;
        this.type = builder.type;
        this.resourceArn = builder.resourceArn;
        this.endpointAttributes = builder.endpointAttributes;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.allowMessages = builder.allowMessages;
        this.endpointState = builder.endpointState;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code>.
     */
    public final String appInstanceUserArn() {
        return appInstanceUserArn;
    }

    /**
     * <p>
     * The unique identifier of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * 
     * @return The unique identifier of the <code>AppInstanceUserEndpoint</code>.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The name of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>AppInstanceUserEndpoint</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppInstanceUserEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>AppInstanceUserEndpoint</code>.
     * @see AppInstanceUserEndpointType
     */
    public final AppInstanceUserEndpointType type() {
        return AppInstanceUserEndpointType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>AppInstanceUserEndpoint</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppInstanceUserEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>AppInstanceUserEndpoint</code>.
     * @see AppInstanceUserEndpointType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ARN of the resource to which the endpoint belongs.
     * </p>
     * 
     * @return The ARN of the resource to which the endpoint belongs.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The attributes of an <code>Endpoint</code>.
     * </p>
     * 
     * @return The attributes of an <code>Endpoint</code>.
     */
    public final EndpointAttributes endpointAttributes() {
        return endpointAttributes;
    }

    /**
     * <p>
     * The time at which an <code>AppInstanceUserEndpoint</code> was created.
     * </p>
     * 
     * @return The time at which an <code>AppInstanceUserEndpoint</code> was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which an <code>AppInstanceUserEndpoint</code> was last updated.
     * </p>
     * 
     * @return The time at which an <code>AppInstanceUserEndpoint</code> was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will
     * receive no messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allowMessages}
     * will return {@link AllowMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #allowMessagesAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     *         <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the
     *         endpoint will receive no messages.
     * @see AllowMessages
     */
    public final AllowMessages allowMessages() {
        return AllowMessages.fromValue(allowMessages);
    }

    /**
     * <p>
     * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will
     * receive no messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allowMessages}
     * will return {@link AllowMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #allowMessagesAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
     *         <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the
     *         endpoint will receive no messages.
     * @see AllowMessages
     */
    public final String allowMessagesAsString() {
        return allowMessages;
    }

    /**
     * <p>
     * A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When
     * <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When
     * <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code>
     * due to invalid device token
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code>
     * due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages.
     *         When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message.
     *         When <code>INACTIVE</code>, the corresponding reason will be conveyed through
     *         <code>EndpointStatusReason</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
     *         <code>INACTIVE</code> due to invalid device token
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
     *         <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code>
     *         field.
     *         </p>
     *         </li>
     */
    public final EndpointState endpointState() {
        return endpointState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(allowMessagesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceUserEndpoint)) {
            return false;
        }
        AppInstanceUserEndpoint other = (AppInstanceUserEndpoint) obj;
        return Objects.equals(appInstanceUserArn(), other.appInstanceUserArn())
                && Objects.equals(endpointId(), other.endpointId()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(endpointAttributes(), other.endpointAttributes())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(allowMessagesAsString(), other.allowMessagesAsString())
                && Objects.equals(endpointState(), other.endpointState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceUserEndpoint")
                .add("AppInstanceUserArn", appInstanceUserArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EndpointId", endpointId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("ResourceArn", resourceArn()).add("EndpointAttributes", endpointAttributes())
                .add("CreatedTimestamp", createdTimestamp()).add("LastUpdatedTimestamp", lastUpdatedTimestamp())
                .add("AllowMessages", allowMessagesAsString()).add("EndpointState", endpointState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUserArn":
            return Optional.ofNullable(clazz.cast(appInstanceUserArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "EndpointAttributes":
            return Optional.ofNullable(clazz.cast(endpointAttributes()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "AllowMessages":
            return Optional.ofNullable(clazz.cast(allowMessagesAsString()));
        case "EndpointState":
            return Optional.ofNullable(clazz.cast(endpointState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceUserEndpoint, T> g) {
        return obj -> g.apply((AppInstanceUserEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceUserEndpoint> {
        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUserArn
         *        The ARN of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserArn(String appInstanceUserArn);

        /**
         * <p>
         * The unique identifier of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param endpointId
         *        The unique identifier of the <code>AppInstanceUserEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The name of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>AppInstanceUserEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>AppInstanceUserEndpoint</code>.
         * @see AppInstanceUserEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceUserEndpointType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>AppInstanceUserEndpoint</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>AppInstanceUserEndpoint</code>.
         * @see AppInstanceUserEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceUserEndpointType
         */
        Builder type(AppInstanceUserEndpointType type);

        /**
         * <p>
         * The ARN of the resource to which the endpoint belongs.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource to which the endpoint belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The attributes of an <code>Endpoint</code>.
         * </p>
         * 
         * @param endpointAttributes
         *        The attributes of an <code>Endpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAttributes(EndpointAttributes endpointAttributes);

        /**
         * <p>
         * The attributes of an <code>Endpoint</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointAttributes.Builder} avoiding the
         * need to create one manually via {@link EndpointAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointAttributes(EndpointAttributes)}.
         * 
         * @param endpointAttributes
         *        a consumer that will call methods on {@link EndpointAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointAttributes(EndpointAttributes)
         */
        default Builder endpointAttributes(Consumer<EndpointAttributes.Builder> endpointAttributes) {
            return endpointAttributes(EndpointAttributes.builder().applyMutation(endpointAttributes).build());
        }

        /**
         * <p>
         * The time at which an <code>AppInstanceUserEndpoint</code> was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which an <code>AppInstanceUserEndpoint</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which an <code>AppInstanceUserEndpoint</code> was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time at which an <code>AppInstanceUserEndpoint</code> was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
         * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint
         * will receive no messages.
         * </p>
         * 
         * @param allowMessages
         *        Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive
         *        messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code>
         *        indicates the endpoint will receive no messages.
         * @see AllowMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowMessages
         */
        Builder allowMessages(String allowMessages);

        /**
         * <p>
         * Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages.
         * <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint
         * will receive no messages.
         * </p>
         * 
         * @param allowMessages
         *        Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive
         *        messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code>
         *        indicates the endpoint will receive no messages.
         * @see AllowMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowMessages
         */
        Builder allowMessages(AllowMessages allowMessages);

        /**
         * <p>
         * A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When
         * <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When
         * <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
         * <code>INACTIVE</code> due to invalid device token
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
         * <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code>
         * field.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpointState
         *        A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages.
         *        When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message.
         *        When <code>INACTIVE</code>, the corresponding reason will be conveyed through
         *        <code>EndpointStatusReason</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
         *        <code>INACTIVE</code> due to invalid device token
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
         *        <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the
         *        <code>ResourceArn</code> field.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointState(EndpointState endpointState);

        /**
         * <p>
         * A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When
         * <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can't receive message. When
         * <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
         * <code>INACTIVE</code> due to invalid device token
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is
         * <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code>
         * field.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link EndpointState.Builder} avoiding the need
         * to create one manually via {@link EndpointState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointState.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointState(EndpointState)}.
         * 
         * @param endpointState
         *        a consumer that will call methods on {@link EndpointState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointState(EndpointState)
         */
        default Builder endpointState(Consumer<EndpointState.Builder> endpointState) {
            return endpointState(EndpointState.builder().applyMutation(endpointState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String appInstanceUserArn;

        private String endpointId;

        private String name;

        private String type;

        private String resourceArn;

        private EndpointAttributes endpointAttributes;

        private Instant createdTimestamp;

        private Instant lastUpdatedTimestamp;

        private String allowMessages;

        private EndpointState endpointState;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceUserEndpoint model) {
            appInstanceUserArn(model.appInstanceUserArn);
            endpointId(model.endpointId);
            name(model.name);
            type(model.type);
            resourceArn(model.resourceArn);
            endpointAttributes(model.endpointAttributes);
            createdTimestamp(model.createdTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            allowMessages(model.allowMessages);
            endpointState(model.endpointState);
        }

        public final String getAppInstanceUserArn() {
            return appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppInstanceUserEndpointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final EndpointAttributes.Builder getEndpointAttributes() {
            return endpointAttributes != null ? endpointAttributes.toBuilder() : null;
        }

        public final void setEndpointAttributes(EndpointAttributes.BuilderImpl endpointAttributes) {
            this.endpointAttributes = endpointAttributes != null ? endpointAttributes.build() : null;
        }

        @Override
        public final Builder endpointAttributes(EndpointAttributes endpointAttributes) {
            this.endpointAttributes = endpointAttributes;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getAllowMessages() {
            return allowMessages;
        }

        public final void setAllowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
        }

        @Override
        public final Builder allowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
            return this;
        }

        @Override
        public final Builder allowMessages(AllowMessages allowMessages) {
            this.allowMessages(allowMessages == null ? null : allowMessages.toString());
            return this;
        }

        public final EndpointState.Builder getEndpointState() {
            return endpointState != null ? endpointState.toBuilder() : null;
        }

        public final void setEndpointState(EndpointState.BuilderImpl endpointState) {
            this.endpointState = endpointState != null ? endpointState.build() : null;
        }

        @Override
        public final Builder endpointState(EndpointState endpointState) {
            this.endpointState = endpointState;
            return this;
        }

        @Override
        public AppInstanceUserEndpoint build() {
            return new AppInstanceUserEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
