/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Lex V2 chat bot created under an <code>AppInstance</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceBot implements SdkPojo, Serializable, ToCopyableBuilder<AppInstanceBot.Builder, AppInstanceBot> {
    private static final SdkField<String> APP_INSTANCE_BOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceBotArn").getter(getter(AppInstanceBot::appInstanceBotArn))
            .setter(setter(Builder::appInstanceBotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceBotArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AppInstanceBot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Configuration> CONFIGURATION_FIELD = SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
            .memberName("Configuration").getter(getter(AppInstanceBot::configuration)).setter(setter(Builder::configuration))
            .constructor(Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(AppInstanceBot::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(AppInstanceBot::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(AppInstanceBot::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_BOT_ARN_FIELD,
            NAME_FIELD, CONFIGURATION_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appInstanceBotArn;

    private final String name;

    private final Configuration configuration;

    private final Instant createdTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final String metadata;

    private AppInstanceBot(BuilderImpl builder) {
        this.appInstanceBotArn = builder.appInstanceBotArn;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The ARN of the AppInstanceBot.
     * </p>
     * 
     * @return The ARN of the AppInstanceBot.
     */
    public final String appInstanceBotArn() {
        return appInstanceBotArn;
    }

    /**
     * <p>
     * The name of the AppInstanceBot.
     * </p>
     * 
     * @return The name of the AppInstanceBot.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data processing instructions for an AppInstanceBot.
     * </p>
     * 
     * @return The data processing instructions for an AppInstanceBot.
     */
    public final Configuration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The time at which the <code>AppInstanceBot</code> was created.
     * </p>
     * 
     * @return The time at which the <code>AppInstanceBot</code> was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the <code>AppInstanceBot</code> was last updated.
     * </p>
     * 
     * @return The time at which the <code>AppInstanceBot</code> was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The metadata for an AppInstanceBot.
     * </p>
     * 
     * @return The metadata for an AppInstanceBot.
     */
    public final String metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceBotArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceBot)) {
            return false;
        }
        AppInstanceBot other = (AppInstanceBot) obj;
        return Objects.equals(appInstanceBotArn(), other.appInstanceBotArn()) && Objects.equals(name(), other.name())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceBot").add("AppInstanceBotArn", appInstanceBotArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Configuration", configuration())
                .add("CreatedTimestamp", createdTimestamp()).add("LastUpdatedTimestamp", lastUpdatedTimestamp())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceBotArn":
            return Optional.ofNullable(clazz.cast(appInstanceBotArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceBot, T> g) {
        return obj -> g.apply((AppInstanceBot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceBot> {
        /**
         * <p>
         * The ARN of the AppInstanceBot.
         * </p>
         * 
         * @param appInstanceBotArn
         *        The ARN of the AppInstanceBot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceBotArn(String appInstanceBotArn);

        /**
         * <p>
         * The name of the AppInstanceBot.
         * </p>
         * 
         * @param name
         *        The name of the AppInstanceBot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data processing instructions for an AppInstanceBot.
         * </p>
         * 
         * @param configuration
         *        The data processing instructions for an AppInstanceBot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Configuration configuration);

        /**
         * <p>
         * The data processing instructions for an AppInstanceBot.
         * </p>
         * This is a convenience method that creates an instance of the {@link Configuration.Builder} avoiding the need
         * to create one manually via {@link Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(Configuration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(Configuration)
         */
        default Builder configuration(Consumer<Configuration.Builder> configuration) {
            return configuration(Configuration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The time at which the <code>AppInstanceBot</code> was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the <code>AppInstanceBot</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the <code>AppInstanceBot</code> was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time at which the <code>AppInstanceBot</code> was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The metadata for an AppInstanceBot.
         * </p>
         * 
         * @param metadata
         *        The metadata for an AppInstanceBot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);
    }

    static final class BuilderImpl implements Builder {
        private String appInstanceBotArn;

        private String name;

        private Configuration configuration;

        private Instant createdTimestamp;

        private Instant lastUpdatedTimestamp;

        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceBot model) {
            appInstanceBotArn(model.appInstanceBotArn);
            name(model.name);
            configuration(model.configuration);
            createdTimestamp(model.createdTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            metadata(model.metadata);
        }

        public final String getAppInstanceBotArn() {
            return appInstanceBotArn;
        }

        public final void setAppInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
        }

        @Override
        public final Builder appInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Configuration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(Configuration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public AppInstanceBot build() {
            return new AppInstanceBot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
