/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.chimesdkidentity.internal.ChimeSdkIdentityServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.chimesdkidentity.model.BadRequestException;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityException;
import software.amazon.awssdk.services.chimesdkidentity.model.ConflictException;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceBotRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceBotResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceBotRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceBotResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeregisterAppInstanceUserEndpointRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeregisterAppInstanceUserEndpointResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceBotRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceBotResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserEndpointRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserEndpointResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ForbiddenException;
import software.amazon.awssdk.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceBotsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceBotsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUserEndpointsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUserEndpointsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.NotFoundException;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceUserExpirationSettingsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceUserExpirationSettingsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.RegisterAppInstanceUserEndpointRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.RegisterAppInstanceUserEndpointResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chimesdkidentity.model.ServiceFailureException;
import software.amazon.awssdk.services.chimesdkidentity.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chimesdkidentity.model.TagResourceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.TagResourceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ThrottledClientException;
import software.amazon.awssdk.services.chimesdkidentity.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chimesdkidentity.model.UntagResourceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UntagResourceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceBotRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceBotResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserEndpointRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserEndpointResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.transform.CreateAppInstanceAdminRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.CreateAppInstanceBotRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.CreateAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.CreateAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeleteAppInstanceAdminRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeleteAppInstanceBotRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeleteAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeleteAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeregisterAppInstanceUserEndpointRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceAdminRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceBotRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceUserEndpointRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.GetAppInstanceRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstanceAdminsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstanceBotsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstanceUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstanceUsersRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstancesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.PutAppInstanceRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.PutAppInstanceUserExpirationSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.RegisterAppInstanceUserEndpointRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.UpdateAppInstanceBotRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.UpdateAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.UpdateAppInstanceUserEndpointRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.UpdateAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ChimeSdkIdentityClient}.
 *
 * @see ChimeSdkIdentityClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultChimeSdkIdentityClient implements ChimeSdkIdentityClient {
    private static final Logger log = Logger.loggerFor(DefaultChimeSdkIdentityClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultChimeSdkIdentityClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers
     * use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.
     * </p>
     * <p>
     * identity
     * </p>
     *
     * @param createAppInstanceRequest
     * @return Result of the CreateAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAppInstanceResponse createAppInstance(CreateAppInstanceRequest createAppInstanceRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAppInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppInstance");

            return clientHandler.execute(new ClientExecutionParams<CreateAppInstanceRequest, CreateAppInstanceResponse>()
                    .withOperationName("CreateAppInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAppInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAppInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Promotes an <code>AppInstanceUser</code> or <code>AppInstanceBot</code> to an <code>AppInstanceAdmin</code>. The
     * promoted entity can perform the following actions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteChannelMessage</code> actions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Only an <code>AppInstanceUser</code> and <code>AppInstanceBot</code> can be promoted to an
     * <code>AppInstanceAdmin</code> role.
     * </p>
     *
     * @param createAppInstanceAdminRequest
     * @return Result of the CreateAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAppInstanceAdminResponse createAppInstanceAdmin(CreateAppInstanceAdminRequest createAppInstanceAdminRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppInstanceAdminResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAppInstanceAdminResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppInstanceAdminRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppInstanceAdminRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppInstanceAdmin");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAppInstanceAdminRequest, CreateAppInstanceAdminResponse>()
                            .withOperationName("CreateAppInstanceAdmin").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAppInstanceAdminRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAppInstanceAdminRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a bot under an Amazon Chime <code>AppInstance</code>. The request consists of a unique
     * <code>Configuration</code> and <code>Name</code> for that bot.
     * </p>
     *
     * @param createAppInstanceBotRequest
     * @return Result of the CreateAppInstanceBot operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstanceBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceBot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAppInstanceBotResponse createAppInstanceBot(CreateAppInstanceBotRequest createAppInstanceBotRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppInstanceBotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAppInstanceBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppInstanceBotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppInstanceBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppInstanceBot");

            return clientHandler.execute(new ClientExecutionParams<CreateAppInstanceBotRequest, CreateAppInstanceBotResponse>()
                    .withOperationName("CreateAppInstanceBot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAppInstanceBotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAppInstanceBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique
     * <code>appInstanceUserId</code> and <code>Name</code> for that user.
     * </p>
     *
     * @param createAppInstanceUserRequest
     * @return Result of the CreateAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.CreateAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAppInstanceUserResponse createAppInstanceUser(CreateAppInstanceUserRequest createAppInstanceUserRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppInstanceUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAppInstanceUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppInstanceUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppInstanceUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppInstanceUser");

            return clientHandler.execute(new ClientExecutionParams<CreateAppInstanceUserRequest, CreateAppInstanceUserResponse>()
                    .withOperationName("CreateAppInstanceUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAppInstanceUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAppInstanceUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an <code>AppInstance</code> and all associated data asynchronously.
     * </p>
     *
     * @param deleteAppInstanceRequest
     * @return Result of the DeleteAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppInstanceResponse deleteAppInstance(DeleteAppInstanceRequest deleteAppInstanceRequest)
            throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAppInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppInstance");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppInstanceRequest, DeleteAppInstanceResponse>()
                    .withOperationName("DeleteAppInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAppInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code> or <code>AppInstanceBot</code>. This
     * action does not delete the user.
     * </p>
     *
     * @param deleteAppInstanceAdminRequest
     * @return Result of the DeleteAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppInstanceAdminResponse deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest deleteAppInstanceAdminRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppInstanceAdminResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppInstanceAdminResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppInstanceAdminRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppInstanceAdminRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppInstanceAdmin");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAppInstanceAdminRequest, DeleteAppInstanceAdminResponse>()
                            .withOperationName("DeleteAppInstanceAdmin").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAppInstanceAdminRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAppInstanceAdminRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an <code>AppInstanceBot</code>.
     * </p>
     *
     * @param deleteAppInstanceBotRequest
     * @return Result of the DeleteAppInstanceBot operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstanceBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceBot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppInstanceBotResponse deleteAppInstanceBot(DeleteAppInstanceBotRequest deleteAppInstanceBotRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppInstanceBotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppInstanceBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppInstanceBotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppInstanceBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppInstanceBot");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppInstanceBotRequest, DeleteAppInstanceBotResponse>()
                    .withOperationName("DeleteAppInstanceBot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAppInstanceBotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppInstanceBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an <code>AppInstanceUser</code>.
     * </p>
     *
     * @param deleteAppInstanceUserRequest
     * @return Result of the DeleteAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeleteAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppInstanceUserResponse deleteAppInstanceUser(DeleteAppInstanceUserRequest deleteAppInstanceUserRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppInstanceUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppInstanceUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppInstanceUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppInstanceUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppInstanceUser");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppInstanceUserRequest, DeleteAppInstanceUserResponse>()
                    .withOperationName("DeleteAppInstanceUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAppInstanceUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppInstanceUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters an <code>AppInstanceUserEndpoint</code>.
     * </p>
     *
     * @param deregisterAppInstanceUserEndpointRequest
     * @return Result of the DeregisterAppInstanceUserEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DeregisterAppInstanceUserEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeregisterAppInstanceUserEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterAppInstanceUserEndpointResponse deregisterAppInstanceUserEndpoint(
            DeregisterAppInstanceUserEndpointRequest deregisterAppInstanceUserEndpointRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterAppInstanceUserEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterAppInstanceUserEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterAppInstanceUserEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterAppInstanceUserEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterAppInstanceUserEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterAppInstanceUserEndpointRequest, DeregisterAppInstanceUserEndpointResponse>()
                            .withOperationName("DeregisterAppInstanceUserEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deregisterAppInstanceUserEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterAppInstanceUserEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstance</code>.
     * </p>
     *
     * @param describeAppInstanceRequest
     * @return Result of the DescribeAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppInstanceResponse describeAppInstance(DescribeAppInstanceRequest describeAppInstanceRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppInstance");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppInstanceRequest, DescribeAppInstanceResponse>()
                    .withOperationName("DescribeAppInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAppInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstanceAdmin</code>.
     * </p>
     *
     * @param describeAppInstanceAdminRequest
     * @return Result of the DescribeAppInstanceAdmin operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppInstanceAdminResponse describeAppInstanceAdmin(
            DescribeAppInstanceAdminRequest describeAppInstanceAdminRequest) throws BadRequestException, ForbiddenException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppInstanceAdminResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppInstanceAdminResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppInstanceAdminRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppInstanceAdminRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppInstanceAdmin");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppInstanceAdminRequest, DescribeAppInstanceAdminResponse>()
                            .withOperationName("DescribeAppInstanceAdmin").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAppInstanceAdminRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppInstanceAdminRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The <code>AppInstanceBot's</code> information.
     * </p>
     *
     * @param describeAppInstanceBotRequest
     * @return Result of the DescribeAppInstanceBot operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceBot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppInstanceBotResponse describeAppInstanceBot(DescribeAppInstanceBotRequest describeAppInstanceBotRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            NotFoundException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppInstanceBotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppInstanceBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppInstanceBotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppInstanceBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppInstanceBot");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppInstanceBotRequest, DescribeAppInstanceBotResponse>()
                            .withOperationName("DescribeAppInstanceBot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAppInstanceBotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppInstanceBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstanceUser</code>.
     * </p>
     *
     * @param describeAppInstanceUserRequest
     * @return Result of the DescribeAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppInstanceUserResponse describeAppInstanceUser(DescribeAppInstanceUserRequest describeAppInstanceUserRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppInstanceUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppInstanceUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppInstanceUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppInstanceUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppInstanceUser");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppInstanceUserRequest, DescribeAppInstanceUserResponse>()
                            .withOperationName("DescribeAppInstanceUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAppInstanceUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppInstanceUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the full details of an <code>AppInstanceUserEndpoint</code>.
     * </p>
     *
     * @param describeAppInstanceUserEndpointRequest
     * @return Result of the DescribeAppInstanceUserEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.DescribeAppInstanceUserEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUserEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppInstanceUserEndpointResponse describeAppInstanceUserEndpoint(
            DescribeAppInstanceUserEndpointRequest describeAppInstanceUserEndpointRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppInstanceUserEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppInstanceUserEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppInstanceUserEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAppInstanceUserEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppInstanceUserEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppInstanceUserEndpointRequest, DescribeAppInstanceUserEndpointResponse>()
                            .withOperationName("DescribeAppInstanceUserEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAppInstanceUserEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppInstanceUserEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the retention settings for an <code>AppInstance</code>.
     * </p>
     *
     * @param getAppInstanceRetentionSettingsRequest
     * @return Result of the GetAppInstanceRetentionSettings operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.GetAppInstanceRetentionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/GetAppInstanceRetentionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAppInstanceRetentionSettingsResponse getAppInstanceRetentionSettings(
            GetAppInstanceRetentionSettingsRequest getAppInstanceRetentionSettingsRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAppInstanceRetentionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAppInstanceRetentionSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAppInstanceRetentionSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAppInstanceRetentionSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAppInstanceRetentionSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAppInstanceRetentionSettingsRequest, GetAppInstanceRetentionSettingsResponse>()
                            .withOperationName("GetAppInstanceRetentionSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAppInstanceRetentionSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAppInstanceRetentionSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the administrators in the <code>AppInstance</code>.
     * </p>
     *
     * @param listAppInstanceAdminsRequest
     * @return Result of the ListAppInstanceAdmins operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceAdmins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppInstanceAdminsResponse listAppInstanceAdmins(ListAppInstanceAdminsRequest listAppInstanceAdminsRequest)
            throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppInstanceAdminsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppInstanceAdminsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppInstanceAdminsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppInstanceAdminsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppInstanceAdmins");

            return clientHandler.execute(new ClientExecutionParams<ListAppInstanceAdminsRequest, ListAppInstanceAdminsResponse>()
                    .withOperationName("ListAppInstanceAdmins").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAppInstanceAdminsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppInstanceAdminsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all <code>AppInstanceBots</code> created under a single <code>AppInstance</code>.
     * </p>
     *
     * @param listAppInstanceBotsRequest
     * @return Result of the ListAppInstanceBots operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceBots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppInstanceBotsResponse listAppInstanceBots(ListAppInstanceBotsRequest listAppInstanceBotsRequest)
            throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppInstanceBotsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppInstanceBotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppInstanceBotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppInstanceBotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppInstanceBots");

            return clientHandler.execute(new ClientExecutionParams<ListAppInstanceBotsRequest, ListAppInstanceBotsResponse>()
                    .withOperationName("ListAppInstanceBots").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAppInstanceBotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppInstanceBotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the <code>AppInstanceUserEndpoints</code> created under a single <code>AppInstanceUser</code>.
     * </p>
     *
     * @param listAppInstanceUserEndpointsRequest
     * @return Result of the ListAppInstanceUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUserEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppInstanceUserEndpointsResponse listAppInstanceUserEndpoints(
            ListAppInstanceUserEndpointsRequest listAppInstanceUserEndpointsRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppInstanceUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppInstanceUserEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppInstanceUserEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppInstanceUserEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppInstanceUserEndpoints");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppInstanceUserEndpointsRequest, ListAppInstanceUserEndpointsResponse>()
                            .withOperationName("ListAppInstanceUserEndpoints").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAppInstanceUserEndpointsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppInstanceUserEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.
     * </p>
     *
     * @param listAppInstanceUsersRequest
     * @return Result of the ListAppInstanceUsers operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstanceUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppInstanceUsersResponse listAppInstanceUsers(ListAppInstanceUsersRequest listAppInstanceUsersRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppInstanceUsersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppInstanceUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppInstanceUsersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppInstanceUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppInstanceUsers");

            return clientHandler.execute(new ClientExecutionParams<ListAppInstanceUsersRequest, ListAppInstanceUsersResponse>()
                    .withOperationName("ListAppInstanceUsers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAppInstanceUsersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppInstanceUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.
     * </p>
     *
     * @param listAppInstancesRequest
     * @return Result of the ListAppInstances operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListAppInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppInstancesResponse listAppInstances(ListAppInstancesRequest listAppInstancesRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppInstancesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAppInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAppInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppInstances");

            return clientHandler.execute(new ClientExecutionParams<ListAppInstancesRequest, ListAppInstancesResponse>()
                    .withOperationName("ListAppInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAppInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon Chime SDK identity resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the amount of time in days that a given <code>AppInstance</code> retains data.
     * </p>
     *
     * @param putAppInstanceRetentionSettingsRequest
     * @return Result of the PutAppInstanceRetentionSettings operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.PutAppInstanceRetentionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceRetentionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutAppInstanceRetentionSettingsResponse putAppInstanceRetentionSettings(
            PutAppInstanceRetentionSettingsRequest putAppInstanceRetentionSettingsRequest) throws BadRequestException,
            ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutAppInstanceRetentionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutAppInstanceRetentionSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAppInstanceRetentionSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putAppInstanceRetentionSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAppInstanceRetentionSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<PutAppInstanceRetentionSettingsRequest, PutAppInstanceRetentionSettingsResponse>()
                            .withOperationName("PutAppInstanceRetentionSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putAppInstanceRetentionSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutAppInstanceRetentionSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the number of days before the <code>AppInstanceUser</code> is automatically deleted.
     * </p>
     * <note>
     * <p>
     * A background process deletes expired <code>AppInstanceUsers</code> within 6 hours of expiration. Actual deletion
     * times may vary.
     * </p>
     * <p>
     * Expired <code>AppInstanceUsers</code> that have not yet been deleted appear as active, and you can update their
     * expiration settings. The system honors the new settings.
     * </p>
     * </note>
     *
     * @param putAppInstanceUserExpirationSettingsRequest
     * @return Result of the PutAppInstanceUserExpirationSettings operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.PutAppInstanceUserExpirationSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceUserExpirationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutAppInstanceUserExpirationSettingsResponse putAppInstanceUserExpirationSettings(
            PutAppInstanceUserExpirationSettingsRequest putAppInstanceUserExpirationSettingsRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutAppInstanceUserExpirationSettingsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, PutAppInstanceUserExpirationSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAppInstanceUserExpirationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putAppInstanceUserExpirationSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAppInstanceUserExpirationSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<PutAppInstanceUserExpirationSettingsRequest, PutAppInstanceUserExpirationSettingsResponse>()
                            .withOperationName("PutAppInstanceUserExpirationSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putAppInstanceUserExpirationSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutAppInstanceUserExpirationSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers an endpoint under an Amazon Chime <code>AppInstanceUser</code>. The endpoint receives messages for a
     * user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a
     * user.
     * </p>
     *
     * @param registerAppInstanceUserEndpointRequest
     * @return Result of the RegisterAppInstanceUserEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.RegisterAppInstanceUserEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/RegisterAppInstanceUserEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterAppInstanceUserEndpointResponse registerAppInstanceUserEndpoint(
            RegisterAppInstanceUserEndpointRequest registerAppInstanceUserEndpointRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterAppInstanceUserEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterAppInstanceUserEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerAppInstanceUserEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerAppInstanceUserEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterAppInstanceUserEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterAppInstanceUserEndpointRequest, RegisterAppInstanceUserEndpointResponse>()
                            .withOperationName("RegisterAppInstanceUserEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(registerAppInstanceUserEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterAppInstanceUserEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon Chime SDK identity resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ForbiddenException,
            UnauthorizedClientException, ResourceLimitExceededException, ThrottledClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified Amazon Chime SDK identity resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            ForbiddenException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates <code>AppInstance</code> metadata.
     * </p>
     *
     * @param updateAppInstanceRequest
     * @return Result of the UpdateAppInstance operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAppInstanceResponse updateAppInstance(UpdateAppInstanceRequest updateAppInstanceRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ThrottledClientException,
            UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAppInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppInstance");

            return clientHandler.execute(new ClientExecutionParams<UpdateAppInstanceRequest, UpdateAppInstanceResponse>()
                    .withOperationName("UpdateAppInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAppInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAppInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the name and metadata of an <code>AppInstanceBot</code>.
     * </p>
     *
     * @param updateAppInstanceBotRequest
     * @return Result of the UpdateAppInstanceBot operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstanceBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceBot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAppInstanceBotResponse updateAppInstanceBot(UpdateAppInstanceBotRequest updateAppInstanceBotRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppInstanceBotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAppInstanceBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppInstanceBotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppInstanceBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppInstanceBot");

            return clientHandler.execute(new ClientExecutionParams<UpdateAppInstanceBotRequest, UpdateAppInstanceBotResponse>()
                    .withOperationName("UpdateAppInstanceBot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAppInstanceBotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAppInstanceBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.
     * </p>
     *
     * @param updateAppInstanceUserRequest
     * @return Result of the UpdateAppInstanceUser operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstanceUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAppInstanceUserResponse updateAppInstanceUser(UpdateAppInstanceUserRequest updateAppInstanceUserRequest)
            throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException,
            ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppInstanceUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAppInstanceUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppInstanceUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppInstanceUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppInstanceUser");

            return clientHandler.execute(new ClientExecutionParams<UpdateAppInstanceUserRequest, UpdateAppInstanceUserResponse>()
                    .withOperationName("UpdateAppInstanceUser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAppInstanceUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAppInstanceUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the details of an <code>AppInstanceUserEndpoint</code>. You can update the name and
     * <code>AllowMessage</code> values.
     * </p>
     *
     * @param updateAppInstanceUserEndpointRequest
     * @return Result of the UpdateAppInstanceUserEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkIdentityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkIdentityClient.UpdateAppInstanceUserEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUserEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAppInstanceUserEndpointResponse updateAppInstanceUserEndpoint(
            UpdateAppInstanceUserEndpointRequest updateAppInstanceUserEndpointRequest) throws BadRequestException,
            ConflictException, ForbiddenException, ThrottledClientException, UnauthorizedClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppInstanceUserEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAppInstanceUserEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAppInstanceUserEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAppInstanceUserEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAppInstanceUserEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAppInstanceUserEndpointRequest, UpdateAppInstanceUserEndpointResponse>()
                            .withOperationName("UpdateAppInstanceUserEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAppInstanceUserEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAppInstanceUserEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ChimeSdkIdentityServiceClientConfigurationBuilder serviceConfigBuilder = new ChimeSdkIdentityServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ChimeSdkIdentityException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedClientException")
                                .exceptionBuilderSupplier(UnauthorizedClientException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceFailureException")
                                .exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottledClientException")
                                .exceptionBuilderSupplier(ThrottledClientException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    @Override
    public final ChimeSdkIdentityServiceClientConfiguration serviceClientConfiguration() {
        return new ChimeSdkIdentityServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
