/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityAsyncClient;
import software.amazon.awssdk.services.chimesdkidentity.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceBotsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceBotsResponse;

public class ListAppInstanceBotsPublisher
implements SdkPublisher<ListAppInstanceBotsResponse> {
    private final ChimeSdkIdentityAsyncClient client;
    private final ListAppInstanceBotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppInstanceBotsPublisher(ChimeSdkIdentityAsyncClient client, ListAppInstanceBotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppInstanceBotsPublisher(ChimeSdkIdentityAsyncClient client, ListAppInstanceBotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppInstanceBotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppInstanceBotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppInstanceBotsResponseFetcher
    implements AsyncPageFetcher<ListAppInstanceBotsResponse> {
        private ListAppInstanceBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstanceBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppInstanceBotsResponse> nextPage(ListAppInstanceBotsResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstanceBotsPublisher.this.client.listAppInstanceBots(ListAppInstanceBotsPublisher.this.firstRequest);
            }
            return ListAppInstanceBotsPublisher.this.client.listAppInstanceBots((ListAppInstanceBotsRequest)((Object)ListAppInstanceBotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

